/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.shorts;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;
import org.elasticsearch.index.field.data.shorts.ShortFieldData;

public class MultiValueShortFieldData
extends ShortFieldData {
    private static final int VALUE_CACHE_SIZE = 10;
    private ThreadLocal<ThreadLocals.CleanableValue<double[][]>> doublesValuesCache = new ThreadLocal<ThreadLocals.CleanableValue<double[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[][]> initialValue() {
            double[][] value2 = new double[10][];
            for (int i2 = 0; i2 < value2.length; ++i2) {
                value2[i2] = new double[i2];
            }
            return new ThreadLocals.CleanableValue<double[][]>(value2);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<short[][]>> valuesCache = new ThreadLocal<ThreadLocals.CleanableValue<short[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<short[][]> initialValue() {
            short[][] value2 = new short[10][];
            for (int i2 = 0; i2 < value2.length; ++i2) {
                value2[i2] = new short[i2];
            }
            return new ThreadLocals.CleanableValue<short[][]>(value2);
        }
    };
    private final int[][] ordinals;

    public MultiValueShortFieldData(String fieldName, int[][] ordinals, short[] values2) {
        super(fieldName, values2);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        long size2 = super.computeSizeInBytes();
        size2 += (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
        for (int[] ordinal : this.ordinals) {
            size2 += (long)(4 * ordinal.length + RamUsage.NUM_BYTES_ARRAY_HEADER);
        }
        return size2;
    }

    @Override
    public boolean multiValued() {
        return true;
    }

    @Override
    public boolean hasValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc2) {
        boolean found = false;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            found = true;
            proc2.onValue(docId, Short.toString(this.values[loc]));
        }
        if (!found) {
            proc2.onMissing(docId);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.DoubleValueInDocProc proc2) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.LongValueInDocProc proc2) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingDoubleValueInDocProc proc2) {
        boolean found = false;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            found = true;
            proc2.onValue(docId, this.values[loc]);
        }
        if (!found) {
            proc2.onMissing(docId);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingLongValueInDocProc proc2) {
        boolean found = false;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            found = true;
            proc2.onValue(docId, this.values[loc]);
        }
        if (!found) {
            proc2.onMissing(docId);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, ShortFieldData.ValueInDocProc proc2) {
        boolean found = false;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            found = true;
            proc2.onValue(docId, this.values[loc]);
        }
        if (!found) {
            proc2.onMissing(docId);
        }
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc2) {
        boolean found = false;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            found = true;
            proc2.onOrdinal(docId, loc);
        }
        if (!found) {
            proc2.onOrdinal(docId, 0);
        }
    }

    @Override
    public double[] doubleValues(int docId) {
        int length2 = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            ++length2;
        }
        if (length2 == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] doubles = length2 < 10 ? this.doublesValuesCache.get().get()[length2] : new double[length2];
        int i2 = 0;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            doubles[i2++] = this.values[loc];
        }
        return doubles;
    }

    @Override
    public short value(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            return this.values[loc];
        }
        return 0;
    }

    @Override
    public short[] values(int docId) {
        int length2 = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            ++length2;
        }
        if (length2 == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] shorts = length2 < 10 ? this.valuesCache.get().get()[length2] : new short[length2];
        int i2 = 0;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            shorts[i2++] = this.values[loc];
        }
        return shorts;
    }
}

