/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.ints;

import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.support.NumericFieldDataComparator;

public class IntFieldDataMissingComparator
extends NumericFieldDataComparator {
    private final int[] values;
    private int bottom;
    private final int missingValue;

    public IntFieldDataMissingComparator(int numHits, String fieldName, FieldDataCache fieldDataCache, int missingValue) {
        super(fieldName, fieldDataCache);
        this.values = new int[numHits];
        this.missingValue = missingValue;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.INT;
    }

    @Override
    public int compare(int slot1, int slot2) {
        int v1 = this.values[slot1];
        int v2 = this.values[slot2];
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareBottom(int doc) {
        int v2 = this.missingValue;
        if (this.currentFieldData.hasValue(doc)) {
            v2 = this.currentFieldData.intValue(doc);
        }
        if (this.bottom > v2) {
            return 1;
        }
        if (this.bottom < v2) {
            return -1;
        }
        return 0;
    }

    @Override
    public void copy(int slot, int doc) {
        int value2 = this.missingValue;
        if (this.currentFieldData.hasValue(doc)) {
            value2 = this.currentFieldData.intValue(doc);
        }
        this.values[slot] = value2;
    }

    @Override
    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return Integer.valueOf(this.values[slot]);
    }
}

