/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.floats;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.trove.list.array.TFloatArrayList;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.floats.FloatDocFieldData;
import org.elasticsearch.index.field.data.floats.MultiValueFloatFieldData;
import org.elasticsearch.index.field.data.floats.SingleValueFloatFieldData;
import org.elasticsearch.index.field.data.support.FieldDataLoader;

public abstract class FloatFieldData
extends NumericFieldData<FloatDocFieldData> {
    static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    protected final float[] values;

    protected FloatFieldData(String fieldName, float[] values2) {
        super(fieldName);
        this.values = values2;
    }

    @Override
    protected long computeSizeInBytes() {
        return 4 * this.values.length + RamUsage.NUM_BYTES_ARRAY_HEADER;
    }

    public final float[] values() {
        return this.values;
    }

    public abstract float value(int var1);

    public abstract float[] values(int var1);

    @Override
    public FloatDocFieldData docFieldData(int docId) {
        return (FloatDocFieldData)super.docFieldData(docId);
    }

    @Override
    protected FloatDocFieldData createFieldData() {
        return new FloatDocFieldData(this);
    }

    @Override
    public String stringValue(int docId) {
        return Float.toString(this.value(docId));
    }

    @Override
    public void forEachValue(FieldData.StringValueProc proc2) {
        for (int i2 = 1; i2 < this.values.length; ++i2) {
            proc2.onValue(Float.toString(this.values[i2]));
        }
    }

    @Override
    public byte byteValue(int docId) {
        return (byte)this.value(docId);
    }

    @Override
    public short shortValue(int docId) {
        return (short)this.value(docId);
    }

    @Override
    public int intValue(int docId) {
        return (int)this.value(docId);
    }

    @Override
    public long longValue(int docId) {
        return (long)this.value(docId);
    }

    @Override
    public float floatValue(int docId) {
        return this.value(docId);
    }

    @Override
    public double doubleValue(int docId) {
        return this.value(docId);
    }

    @Override
    public FieldDataType type() {
        return FieldDataType.DefaultTypes.FLOAT;
    }

    public void forEachValue(ValueProc proc2) {
        for (int i2 = 1; i2 < this.values.length; ++i2) {
            proc2.onValue(this.values[i2]);
        }
    }

    public abstract void forEachValueInDoc(int var1, ValueInDocProc var2);

    public static FloatFieldData load(IndexReader reader, String field2) throws IOException {
        return FieldDataLoader.load(reader, field2, new FloatTypeLoader());
    }

    static class FloatTypeLoader
    extends FieldDataLoader.FreqsTypeLoader<FloatFieldData> {
        private final TFloatArrayList terms = new TFloatArrayList();

        FloatTypeLoader() {
            this.terms.add(0.0f);
        }

        @Override
        public void collectTerm(String term) {
            this.terms.add(FieldCache.NUMERIC_UTILS_FLOAT_PARSER.parseFloat(term));
        }

        @Override
        public FloatFieldData buildSingleValue(String field2, int[] ordinals) {
            return new SingleValueFloatFieldData(field2, ordinals, this.terms.toArray());
        }

        @Override
        public FloatFieldData buildMultiValue(String field2, int[][] ordinals) {
            return new MultiValueFloatFieldData(field2, ordinals, this.terms.toArray());
        }
    }

    public static interface ValueInDocProc {
        public void onValue(int var1, float var2);

        public void onMissing(int var1);
    }

    public static interface ValueProc {
        public void onValue(float var1);
    }
}

