/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.doubles;

import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.support.NumericFieldDataComparator;

public class DoubleFieldDataMissingComparator
extends NumericFieldDataComparator {
    private final double[] values;
    private double bottom;
    private final double missingValue;

    public DoubleFieldDataMissingComparator(int numHits, String fieldName, FieldDataCache fieldDataCache, double missingValue) {
        super(fieldName, fieldDataCache);
        this.values = new double[numHits];
        this.missingValue = missingValue;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.DOUBLE;
    }

    @Override
    public int compare(int slot1, int slot2) {
        double v1 = this.values[slot1];
        double v2 = this.values[slot2];
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareBottom(int doc) {
        double v2 = this.missingValue;
        if (this.currentFieldData.hasValue(doc)) {
            v2 = this.currentFieldData.doubleValue(doc);
        }
        if (this.bottom > v2) {
            return 1;
        }
        if (this.bottom < v2) {
            return -1;
        }
        return 0;
    }

    @Override
    public void copy(int slot, int doc) {
        double value2 = this.missingValue;
        if (this.currentFieldData.hasValue(doc)) {
            value2 = this.currentFieldData.doubleValue(doc);
        }
        this.values[slot] = value2;
    }

    @Override
    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return Double.valueOf(this.values[slot]);
    }
}

