/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.id.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.ExtTObjectIntHasMap;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.id.IdCache;
import org.elasticsearch.index.cache.id.IdReaderCache;
import org.elasticsearch.index.cache.id.simple.SimpleIdReaderCache;
import org.elasticsearch.index.cache.id.simple.SimpleIdReaderTypeCache;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class SimpleIdCache
extends AbstractIndexComponent
implements IdCache,
SegmentReader.CoreClosedListener {
    private final ConcurrentMap<Object, SimpleIdReaderCache> idReaders = ConcurrentCollections.newConcurrentMap();
    private final boolean reuse = this.componentSettings.getAsBoolean("reuse", false);

    @Inject
    public SimpleIdCache(Index index2, @IndexSettings Settings indexSettings) {
        super(index2, indexSettings);
    }

    @Override
    public void close() throws ElasticSearchException {
        this.clear();
    }

    @Override
    public void clear() {
        this.idReaders.clear();
    }

    @Override
    public void onClose(SegmentReader owner2) {
        this.clear(owner2);
    }

    @Override
    public void clear(IndexReader reader) {
        this.idReaders.remove(reader.getCoreCacheKey());
    }

    @Override
    public IdReaderCache reader(IndexReader reader) {
        return (IdReaderCache)this.idReaders.get(reader.getCoreCacheKey());
    }

    @Override
    public Iterator<IdReaderCache> iterator() {
        return (Iterator)((Object)this.idReaders.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(IndexReader[] readers) throws Exception {
        if (this.refreshNeeded(readers)) {
            ConcurrentMap<Object, SimpleIdReaderCache> concurrentMap = this.idReaders;
            synchronized (concurrentMap) {
                HashedBytesArray idAsBytes;
                TypeBuilder typeBuilder;
                Uid uid2;
                Term term;
                TermEnum termEnum;
                TermDocs termDocs;
                String field2;
                Map<String, TypeBuilder> readerBuilder;
                if (!this.refreshNeeded(readers)) {
                    return;
                }
                HashMap<Object, Map<String, TypeBuilder>> builders = new HashMap<Object, Map<String, TypeBuilder>>();
                block9: for (IndexReader reader : readers) {
                    if (this.idReaders.containsKey(reader.getCoreCacheKey())) continue;
                    if (reader instanceof SegmentReader) {
                        ((SegmentReader)reader).addCoreClosedListener(this);
                    }
                    readerBuilder = new HashMap();
                    builders.put(reader.getCoreCacheKey(), readerBuilder);
                    field2 = StringHelper.intern(UidFieldMapper.NAME);
                    termDocs = reader.termDocs();
                    termEnum = reader.terms(new Term(field2));
                    try {
                        while ((term = termEnum.term()) != null) {
                            if (term.field() != field2) {
                                continue block9;
                            }
                            uid2 = Uid.createUid(term.text());
                            typeBuilder = (TypeBuilder)((HashMap)readerBuilder).get(uid2.type());
                            if (typeBuilder == null) {
                                typeBuilder = new TypeBuilder(reader);
                                ((HashMap)readerBuilder).put(StringHelper.intern(uid2.type()), typeBuilder);
                            }
                            idAsBytes = this.checkIfCanReuse(builders, new HashedBytesArray(uid2.id()));
                            termDocs.seek(termEnum);
                            while (termDocs.next()) {
                                if (reader.isDeleted(termDocs.doc())) continue;
                                typeBuilder.idToDoc.put(idAsBytes, termDocs.doc());
                                typeBuilder.docToId[termDocs.doc()] = idAsBytes;
                            }
                            if (termEnum.next()) continue;
                            continue block9;
                        }
                    }
                    finally {
                        termDocs.close();
                        termEnum.close();
                    }
                }
                block12: for (IndexReader reader : readers) {
                    if (this.idReaders.containsKey(reader.getCoreCacheKey())) continue;
                    readerBuilder = (Map)builders.get(reader.getCoreCacheKey());
                    field2 = StringHelper.intern("_parent");
                    termDocs = reader.termDocs();
                    termEnum = reader.terms(new Term(field2));
                    try {
                        while ((term = termEnum.term()) != null) {
                            if (term.field() != field2) {
                                continue block12;
                            }
                            uid2 = Uid.createUid(term.text());
                            typeBuilder = (TypeBuilder)readerBuilder.get(uid2.type());
                            if (typeBuilder == null) {
                                typeBuilder = new TypeBuilder(reader);
                                readerBuilder.put(StringHelper.intern(uid2.type()), typeBuilder);
                            }
                            idAsBytes = this.checkIfCanReuse(builders, new HashedBytesArray(uid2.id()));
                            boolean added = false;
                            termDocs.seek(termEnum);
                            while (termDocs.next()) {
                                if (reader.isDeleted(termDocs.doc())) continue;
                                if (!added) {
                                    typeBuilder.parentIdsValues.add(idAsBytes);
                                    added = true;
                                }
                                typeBuilder.parentIdsOrdinals[termDocs.doc()] = typeBuilder.t;
                            }
                            if (added) {
                                ++typeBuilder.t;
                            }
                            if (termEnum.next()) continue;
                            continue block12;
                        }
                    }
                    finally {
                        termDocs.close();
                        termEnum.close();
                    }
                }
                for (Map.Entry entry : builders.entrySet()) {
                    MapBuilder types = MapBuilder.newMapBuilder();
                    for (Map.Entry typeBuilderEntry : ((Map)entry.getValue()).entrySet()) {
                        types.put(typeBuilderEntry.getKey(), new SimpleIdReaderTypeCache((String)typeBuilderEntry.getKey(), ((TypeBuilder)typeBuilderEntry.getValue()).idToDoc, ((TypeBuilder)typeBuilderEntry.getValue()).docToId, ((TypeBuilder)typeBuilderEntry.getValue()).parentIdsValues.toArray(new HashedBytesArray[((TypeBuilder)typeBuilderEntry.getValue()).parentIdsValues.size()]), ((TypeBuilder)typeBuilderEntry.getValue()).parentIdsOrdinals));
                    }
                    SimpleIdReaderCache readerCache = new SimpleIdReaderCache(entry.getKey(), types.immutableMap());
                    this.idReaders.put(readerCache.readerCacheKey(), readerCache);
                }
            }
        }
    }

    @Override
    public long sizeInBytes() {
        long sizeInBytes = 0L;
        for (SimpleIdReaderCache idReaderCache : this.idReaders.values()) {
            sizeInBytes += idReaderCache.sizeInBytes();
        }
        return sizeInBytes;
    }

    private HashedBytesArray checkIfCanReuse(Map<Object, Map<String, TypeBuilder>> builders, HashedBytesArray idAsBytes) {
        HashedBytesArray finalIdAsBytes;
        if (this.reuse) {
            for (SimpleIdReaderCache idReaderCache : this.idReaders.values()) {
                finalIdAsBytes = idReaderCache.canReuse(idAsBytes);
                if (finalIdAsBytes == null) continue;
                return finalIdAsBytes;
            }
        }
        for (Map<String, TypeBuilder> map : builders.values()) {
            for (TypeBuilder typeBuilder : map.values()) {
                finalIdAsBytes = typeBuilder.canReuse(idAsBytes);
                if (finalIdAsBytes == null) continue;
                return finalIdAsBytes;
            }
        }
        return idAsBytes;
    }

    private boolean refreshNeeded(IndexReader[] readers) {
        for (IndexReader reader : readers) {
            if (this.idReaders.containsKey(reader.getCoreCacheKey())) continue;
            return true;
        }
        return false;
    }

    static class TypeBuilder {
        final ExtTObjectIntHasMap<HashedBytesArray> idToDoc = new ExtTObjectIntHasMap(10, 0.5f, -1);
        final HashedBytesArray[] docToId;
        final ArrayList<HashedBytesArray> parentIdsValues = new ArrayList();
        final int[] parentIdsOrdinals;
        int t = 1;

        TypeBuilder(IndexReader reader) {
            this.parentIdsOrdinals = new int[reader.maxDoc()];
            this.parentIdsValues.add(null);
            this.docToId = new HashedBytesArray[reader.maxDoc()];
        }

        public HashedBytesArray canReuse(HashedBytesArray id2) {
            return this.idToDoc.key(id2);
        }
    }
}

