/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.support;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.Unicode;

public interface CacheKeyFilter {
    public Key cacheKey();

    public static class Wrapper
    extends Filter
    implements CacheKeyFilter {
        private final Filter filter;
        private final Key key;

        public Wrapper(Filter filter, Key key2) {
            this.filter = filter;
            this.key = key2;
        }

        @Override
        public Key cacheKey() {
            return this.key;
        }

        @Override
        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            return this.filter.getDocIdSet(reader);
        }

        public int hashCode() {
            return this.filter.hashCode();
        }

        public boolean equals(Object obj) {
            return this.filter.equals(obj);
        }

        public String toString() {
            return this.filter.toString();
        }
    }

    public static class Key {
        private final byte[] bytes;
        private final int hashCode;

        public Key(byte[] bytes2) {
            this.bytes = bytes2;
            this.hashCode = Arrays.hashCode(bytes2);
        }

        public Key(String str) {
            this(Unicode.fromStringAsBytes(str));
        }

        public byte[] bytes() {
            return this.bytes;
        }

        public String utf8ToString() {
            return Unicode.fromBytes(this.bytes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Key bytesWrap = (Key)o;
            return Arrays.equals(this.bytes, bytesWrap.bytes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

