/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class ShingleTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int maxShingleSize;
    private final boolean outputUnigrams;
    private Boolean outputUnigramsIfNoShingles;
    private String tokenSeparator;
    private int minShingleSize;

    @Inject
    public ShingleTokenFilterFactory(Index index2, @IndexSettings Settings indexSettings, @Assisted String name2, @Assisted Settings settings) {
        super(index2, indexSettings, name2, settings);
        this.maxShingleSize = settings.getAsInt("max_shingle_size", 2);
        this.minShingleSize = settings.getAsInt("min_shingle_size", 2);
        this.outputUnigrams = settings.getAsBoolean("output_unigrams", true);
        this.outputUnigramsIfNoShingles = settings.getAsBoolean("output_unigrams_if_no_shingles", false);
        this.tokenSeparator = settings.get("token_separator", " ");
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        ShingleFilter filter = new ShingleFilter(tokenStream, this.minShingleSize, this.maxShingleSize);
        filter.setOutputUnigrams(this.outputUnigrams);
        filter.setOutputUnigramsIfNoShingles(this.outputUnigramsIfNoShingles);
        filter.setTokenSeparator(this.tokenSeparator);
        return filter;
    }
}

