/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class PatternTokenizerFactory
extends AbstractTokenizerFactory {
    private final Pattern pattern;
    private final int group;

    @Inject
    public PatternTokenizerFactory(Index index2, @IndexSettings Settings indexSettings, @Assisted String name2, @Assisted Settings settings) {
        super(index2, indexSettings, name2, settings);
        String sPattern = settings.get("pattern", "\\W+");
        if (sPattern == null) {
            throw new ElasticSearchIllegalArgumentException("pattern is missing for [" + name2 + "] tokenizer of type 'pattern'");
        }
        this.pattern = Regex.compile(sPattern, settings.get("flags"));
        this.group = settings.getAsInt("group", -1);
    }

    @Override
    public Tokenizer create(Reader reader) {
        try {
            return new PatternTokenizer(reader, this.pattern, this.group);
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalStateException("failed to create pattern tokenizer", e);
        }
    }
}

