/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.common.collect.ImmutableMap;

public final class FieldNameAnalyzer
extends Analyzer {
    private final ImmutableMap<String, Analyzer> analyzers;
    private final Analyzer defaultAnalyzer;

    public FieldNameAnalyzer(Map<String, Analyzer> analyzers, Analyzer defaultAnalyzer) {
        this.analyzers = ImmutableMap.copyOf(analyzers);
        this.defaultAnalyzer = defaultAnalyzer;
    }

    public ImmutableMap<String, Analyzer> analyzers() {
        return this.analyzers;
    }

    public Analyzer defaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    @Override
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        return this.getAnalyzer(fieldName).tokenStream(fieldName, reader);
    }

    @Override
    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        return this.getAnalyzer(fieldName).reusableTokenStream(fieldName, reader);
    }

    @Override
    public int getPositionIncrementGap(String fieldName) {
        return this.getAnalyzer(fieldName).getPositionIncrementGap(fieldName);
    }

    @Override
    public int getOffsetGap(Fieldable field2) {
        return this.getAnalyzer(field2.name()).getOffsetGap(field2);
    }

    private Analyzer getAnalyzer(String name2) {
        Analyzer analyzer = this.analyzers.get(name2);
        if (analyzer != null) {
            return analyzer;
        }
        return this.defaultAnalyzer;
    }
}

