/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.nl.DutchStemFilter;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class DutchStemTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Set<?> exclusions;

    @Inject
    public DutchStemTokenFilterFactory(Index index2, @IndexSettings Settings indexSettings, @Assisted String name2, @Assisted Settings settings) {
        super(index2, indexSettings, name2, settings);
        String[] stemExclusion = settings.getAsArray("stem_exclusion");
        this.exclusions = stemExclusion.length > 0 ? ImmutableSet.copyOf(Iterators.forArray(stemExclusion)) : ImmutableSet.of();
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new DutchStemFilter(tokenStream, this.exclusions);
    }
}

