/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.CloseableComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.AnalyzerProviderFactory;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CharFilterFactoryFactory;
import org.elasticsearch.index.analysis.CustomAnalyzerProvider;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.elasticsearch.index.analysis.PreBuiltCharFilterFactoryFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenFilterFactoryFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenizerFactoryFactory;
import org.elasticsearch.index.analysis.StandardAnalyzerProvider;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactoryFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.analysis.TokenizerFactoryFactory;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;

public class AnalysisService
extends AbstractIndexComponent
implements CloseableComponent {
    private final ImmutableMap<String, NamedAnalyzer> analyzers;
    private final ImmutableMap<String, TokenizerFactory> tokenizers;
    private final ImmutableMap<String, CharFilterFactory> charFilters;
    private final ImmutableMap<String, TokenFilterFactory> tokenFilters;
    private final NamedAnalyzer defaultAnalyzer;
    private final NamedAnalyzer defaultIndexAnalyzer;
    private final NamedAnalyzer defaultSearchAnalyzer;
    private final NamedAnalyzer defaultSearchQuoteAnalyzer;

    public AnalysisService(Index index2) {
        this(index2, ImmutableSettings.Builder.EMPTY_SETTINGS, null, null, null, null, null);
    }

    @Inject
    public AnalysisService(Index index2, @IndexSettings Settings indexSettings, @Nullable IndicesAnalysisService indicesAnalysisService, @Nullable Map<String, AnalyzerProviderFactory> analyzerFactoryFactories, @Nullable Map<String, TokenizerFactoryFactory> tokenizerFactoryFactories, @Nullable Map<String, CharFilterFactoryFactory> charFilterFactoryFactories, @Nullable Map<String, TokenFilterFactoryFactory> tokenFilterFactoryFactories) {
        super(index2, indexSettings);
        HashMap<String, TokenizerFactory> tokenizers = Maps.newHashMap();
        if (tokenizerFactoryFactories != null) {
            Map<String, Settings> tokenizersSettings = indexSettings.getGroups("index.analysis.tokenizer");
            for (Map.Entry<String, TokenizerFactoryFactory> entry : tokenizerFactoryFactories.entrySet()) {
                String string2 = entry.getKey();
                TokenizerFactoryFactory tokenizerFactoryFactory = entry.getValue();
                Settings tokenizerSettings = tokenizersSettings.get(string2);
                if (tokenizerSettings == null) {
                    tokenizerSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                TokenizerFactory tokenizerFactory = tokenizerFactoryFactory.create(string2, tokenizerSettings);
                tokenizers.put(string2, tokenizerFactory);
                tokenizers.put(Strings.toCamelCase(string2), tokenizerFactory);
            }
        }
        if (indicesAnalysisService != null) {
            for (Map.Entry<String, PreBuiltTokenizerFactoryFactory> entry : indicesAnalysisService.tokenizerFactories().entrySet()) {
                String string3;
                String string4 = entry.getKey();
                if (!tokenizers.containsKey(string4)) {
                    tokenizers.put(string4, entry.getValue().create(string4, ImmutableSettings.Builder.EMPTY_SETTINGS));
                }
                if ((string3 = Strings.toCamelCase(entry.getKey())).equals(entry.getKey()) || tokenizers.containsKey(string3)) continue;
                tokenizers.put(string3, entry.getValue().create(string3, ImmutableSettings.Builder.EMPTY_SETTINGS));
            }
        }
        this.tokenizers = ImmutableMap.copyOf(tokenizers);
        HashMap<String, CharFilterFactory> charFilters = Maps.newHashMap();
        if (charFilterFactoryFactories != null) {
            Map<String, Settings> charFiltersSettings = indexSettings.getGroups("index.analysis.char_filter");
            for (Map.Entry<String, CharFilterFactoryFactory> entry : charFilterFactoryFactories.entrySet()) {
                String string5 = entry.getKey();
                CharFilterFactoryFactory charFilterFactoryFactory = entry.getValue();
                Settings charFilterSettings = charFiltersSettings.get(string5);
                if (charFilterSettings == null) {
                    charFilterSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                CharFilterFactory tokenFilterFactory = charFilterFactoryFactory.create(string5, charFilterSettings);
                charFilters.put(string5, tokenFilterFactory);
                charFilters.put(Strings.toCamelCase(string5), tokenFilterFactory);
            }
        }
        if (indicesAnalysisService != null) {
            for (Map.Entry<String, Object> entry : indicesAnalysisService.charFilterFactories().entrySet()) {
                String string6;
                String string7 = entry.getKey();
                if (!charFilters.containsKey(string7)) {
                    charFilters.put(string7, ((PreBuiltCharFilterFactoryFactory)entry.getValue()).create(string7, ImmutableSettings.Builder.EMPTY_SETTINGS));
                }
                if ((string6 = Strings.toCamelCase(entry.getKey())).equals(entry.getKey()) || charFilters.containsKey(string6)) continue;
                charFilters.put(string6, ((PreBuiltCharFilterFactoryFactory)entry.getValue()).create(string6, ImmutableSettings.Builder.EMPTY_SETTINGS));
            }
        }
        this.charFilters = ImmutableMap.copyOf(charFilters);
        HashMap<String, TokenFilterFactory> tokenFilters = Maps.newHashMap();
        if (tokenFilterFactoryFactories != null) {
            Map<String, Settings> map = indexSettings.getGroups("index.analysis.filter");
            for (Map.Entry<String, TokenFilterFactoryFactory> entry : tokenFilterFactoryFactories.entrySet()) {
                String tokenFilterName = entry.getKey();
                TokenFilterFactoryFactory tokenFilterFactoryFactory = entry.getValue();
                Settings tokenFilterSettings = map.get(tokenFilterName);
                if (tokenFilterSettings == null) {
                    tokenFilterSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                TokenFilterFactory tokenFilterFactory = tokenFilterFactoryFactory.create(tokenFilterName, tokenFilterSettings);
                tokenFilters.put(tokenFilterName, tokenFilterFactory);
                tokenFilters.put(Strings.toCamelCase(tokenFilterName), tokenFilterFactory);
            }
        }
        if (indicesAnalysisService != null) {
            for (Map.Entry<String, PreBuiltTokenFilterFactoryFactory> entry : indicesAnalysisService.tokenFilterFactories().entrySet()) {
                String string8;
                String string9 = entry.getKey();
                if (!tokenFilters.containsKey(string9)) {
                    tokenFilters.put(string9, entry.getValue().create(string9, ImmutableSettings.Builder.EMPTY_SETTINGS));
                }
                if ((string8 = Strings.toCamelCase(entry.getKey())).equals(entry.getKey()) || tokenFilters.containsKey(string8)) continue;
                tokenFilters.put(string8, entry.getValue().create(string8, ImmutableSettings.Builder.EMPTY_SETTINGS));
            }
        }
        this.tokenFilters = ImmutableMap.copyOf(tokenFilters);
        HashMap<String, AnalyzerProvider<Analyzer>> hashMap = Maps.newHashMap();
        if (analyzerFactoryFactories != null) {
            Map<String, Settings> map = indexSettings.getGroups("index.analysis.analyzer");
            for (Map.Entry<String, AnalyzerProviderFactory> entry : analyzerFactoryFactories.entrySet()) {
                String analyzerName = entry.getKey();
                AnalyzerProviderFactory analyzerFactoryFactory = entry.getValue();
                Settings analyzerSettings = map.get(analyzerName);
                if (analyzerSettings == null) {
                    analyzerSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                AnalyzerProvider analyzerFactory = analyzerFactoryFactory.create(analyzerName, analyzerSettings);
                hashMap.put(analyzerName, analyzerFactory);
            }
        }
        if (indicesAnalysisService != null) {
            for (Map.Entry<String, PreBuiltAnalyzerProviderFactory> entry : indicesAnalysisService.analyzerProviderFactories().entrySet()) {
                String name5 = entry.getKey();
                if (!hashMap.containsKey(name5)) {
                    hashMap.put(name5, entry.getValue().create(name5, ImmutableSettings.Builder.EMPTY_SETTINGS));
                }
                if ((name5 = Strings.toCamelCase(entry.getKey())).equals(entry.getKey()) || hashMap.containsKey(name5)) continue;
                hashMap.put(name5, entry.getValue().create(name5, ImmutableSettings.Builder.EMPTY_SETTINGS));
            }
        }
        if (!hashMap.containsKey("default")) {
            hashMap.put("default", new StandardAnalyzerProvider(index2, indexSettings, null, "default", ImmutableSettings.Builder.EMPTY_SETTINGS));
        }
        if (!hashMap.containsKey("default_index")) {
            hashMap.put("default_index", (AnalyzerProvider<Analyzer>)hashMap.get("default"));
        }
        if (!hashMap.containsKey("default_search")) {
            hashMap.put("default_search", (AnalyzerProvider<Analyzer>)hashMap.get("default"));
        }
        if (!hashMap.containsKey("default_search_quoted")) {
            hashMap.put("default_search_quoted", (AnalyzerProvider<Analyzer>)hashMap.get("default_search"));
        }
        HashMap<String, NamedAnalyzer> hashMap2 = Maps.newHashMap();
        for (AnalyzerProvider analyzerFactory : hashMap.values()) {
            String[] aliases2;
            Object analyzerF;
            if (analyzerFactory instanceof CustomAnalyzerProvider) {
                ((CustomAnalyzerProvider)analyzerFactory).build(this);
            }
            if ((analyzerF = analyzerFactory.get()) == null) {
                throw new ElasticSearchIllegalArgumentException("analyzer [" + analyzerFactory.name() + "] created null analyzer");
            }
            NamedAnalyzer analyzer = new NamedAnalyzer(analyzerFactory.name(), analyzerFactory.scope(), (Analyzer)analyzerF);
            hashMap2.put(analyzerFactory.name(), analyzer);
            hashMap2.put(Strings.toCamelCase(analyzerFactory.name()), analyzer);
            String strAliases = indexSettings.get("index.analysis.analyzer." + analyzerFactory.name() + ".alias");
            if (strAliases != null) {
                for (String alias2 : Strings.commaDelimitedListToStringArray(strAliases)) {
                    hashMap2.put(alias2, analyzer);
                }
            }
            for (String alias3 : aliases2 = indexSettings.getAsArray("index.analysis.analyzer." + analyzerFactory.name() + ".alias")) {
                hashMap2.put(alias3, analyzer);
            }
        }
        this.defaultAnalyzer = (NamedAnalyzer)hashMap2.get("default");
        if (this.defaultAnalyzer == null) {
            throw new ElasticSearchIllegalArgumentException("no default analyzer configured");
        }
        this.defaultIndexAnalyzer = hashMap2.containsKey("default_index") ? (NamedAnalyzer)hashMap2.get("default_index") : (NamedAnalyzer)hashMap2.get("default");
        this.defaultSearchAnalyzer = hashMap2.containsKey("default_search") ? (NamedAnalyzer)hashMap2.get("default_search") : (NamedAnalyzer)hashMap2.get("default");
        this.defaultSearchQuoteAnalyzer = hashMap2.containsKey("default_search_quote") ? (NamedAnalyzer)hashMap2.get("default_search_quote") : this.defaultSearchAnalyzer;
        this.analyzers = ImmutableMap.copyOf(hashMap2);
    }

    @Override
    public void close() {
        for (NamedAnalyzer analyzer : this.analyzers.values()) {
            if (analyzer.scope() != AnalyzerScope.INDEX) continue;
            try {
                analyzer.close();
            }
            catch (NullPointerException e) {
            }
            catch (Exception e) {
                this.logger.debug("failed to close analyzer " + analyzer, new Object[0]);
            }
        }
    }

    public NamedAnalyzer analyzer(String name2) {
        return this.analyzers.get(name2);
    }

    public NamedAnalyzer defaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public NamedAnalyzer defaultIndexAnalyzer() {
        return this.defaultIndexAnalyzer;
    }

    public NamedAnalyzer defaultSearchAnalyzer() {
        return this.defaultSearchAnalyzer;
    }

    public NamedAnalyzer defaultSearchQuoteAnalyzer() {
        return this.defaultSearchQuoteAnalyzer;
    }

    public TokenizerFactory tokenizer(String name2) {
        return this.tokenizers.get(name2);
    }

    public CharFilterFactory charFilter(String name2) {
        return this.charFilters.get(name2);
    }

    public TokenFilterFactory tokenFilter(String name2) {
        return this.tokenFilters.get(name2);
    }
}

