/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ChannelBufferBytesReference;
import org.elasticsearch.common.netty.handler.codec.http.HttpMethod;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.support.AbstractRestRequest;
import org.elasticsearch.rest.support.RestUtils;

public class NettyHttpRequest
extends AbstractRestRequest
implements HttpRequest {
    private final org.elasticsearch.common.netty.handler.codec.http.HttpRequest request;
    private final Map<String, String> params;
    private final String rawPath;
    private final BytesReference content;

    public NettyHttpRequest(org.elasticsearch.common.netty.handler.codec.http.HttpRequest request) {
        this.request = request;
        this.params = new HashMap<String, String>();
        this.content = request.getContent().readable() ? new ChannelBufferBytesReference(request.getContent()) : BytesArray.EMPTY;
        String uri = request.getUri();
        int pathEndPos = uri.indexOf(63);
        if (pathEndPos < 0) {
            this.rawPath = uri;
        } else {
            this.rawPath = uri.substring(0, pathEndPos);
            RestUtils.decodeQueryString(uri, pathEndPos + 1, this.params);
        }
    }

    @Override
    public RestRequest.Method method() {
        HttpMethod httpMethod = this.request.getMethod();
        if (httpMethod == HttpMethod.GET) {
            return RestRequest.Method.GET;
        }
        if (httpMethod == HttpMethod.POST) {
            return RestRequest.Method.POST;
        }
        if (httpMethod == HttpMethod.PUT) {
            return RestRequest.Method.PUT;
        }
        if (httpMethod == HttpMethod.DELETE) {
            return RestRequest.Method.DELETE;
        }
        if (httpMethod == HttpMethod.HEAD) {
            return RestRequest.Method.HEAD;
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return RestRequest.Method.OPTIONS;
        }
        return RestRequest.Method.GET;
    }

    @Override
    public String uri() {
        return this.request.getUri();
    }

    @Override
    public String rawPath() {
        return this.rawPath;
    }

    @Override
    public Map<String, String> params() {
        return this.params;
    }

    @Override
    public boolean hasContent() {
        return this.content.length() > 0;
    }

    @Override
    public boolean contentUnsafe() {
        return false;
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    @Override
    public String header(String name2) {
        return this.request.getHeader(name2);
    }

    @Override
    public boolean hasParam(String key2) {
        return this.params.containsKey(key2);
    }

    @Override
    public String param(String key2) {
        return this.params.get(key2);
    }

    @Override
    public String param(String key2, String defaultValue) {
        String value2 = this.params.get(key2);
        if (value2 == null) {
            return defaultValue;
        }
        return value2;
    }
}

