/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class HttpInfo
implements Streamable,
Serializable,
ToXContent {
    private BoundTransportAddress address;
    private long maxContentLength;

    HttpInfo() {
    }

    public HttpInfo(BoundTransportAddress address2, long maxContentLength) {
        this.address = address2;
        this.maxContentLength = maxContentLength;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject(Fields.HTTP);
        builder.field(Fields.BOUND_ADDRESS, this.address.boundAddress().toString());
        builder.field(Fields.PUBLISH_ADDRESS, this.address.publishAddress().toString());
        builder.field(Fields.MAX_CONTENT_LENGTH, (Object)new ByteSizeValue(this.maxContentLength));
        builder.field(Fields.MAX_CONTENT_LENGTH_IN_BYTES, this.maxContentLength);
        builder.endObject();
        return builder;
    }

    public static HttpInfo readHttpInfo(StreamInput in) throws IOException {
        HttpInfo info = new HttpInfo();
        info.readFrom(in);
        return info;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.address = BoundTransportAddress.readBoundTransportAddress(in);
        this.maxContentLength = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.address.writeTo(out);
        out.writeLong(this.maxContentLength);
    }

    public BoundTransportAddress address() {
        return this.address;
    }

    public BoundTransportAddress getAddress() {
        return this.address();
    }

    public ByteSizeValue maxContentLength() {
        return new ByteSizeValue(this.maxContentLength);
    }

    public ByteSizeValue getMaxContentLength() {
        return this.maxContentLength();
    }

    static final class Fields {
        static final XContentBuilderString HTTP = new XContentBuilderString("http");
        static final XContentBuilderString BOUND_ADDRESS = new XContentBuilderString("bound_address");
        static final XContentBuilderString PUBLISH_ADDRESS = new XContentBuilderString("publish_address");
        static final XContentBuilderString MAX_CONTENT_LENGTH = new XContentBuilderString("max_content_length");
        static final XContentBuilderString MAX_CONTENT_LENGTH_IN_BYTES = new XContentBuilderString("max_content_length_in_bytes");

        Fields() {
        }
    }
}

