/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.FailedToResolveConfigException;

public class Environment {
    private final Settings settings;
    private final File homeFile;
    private final File workFile;
    private final File workWithClusterFile;
    private final File[] dataFiles;
    private final File[] dataWithClusterFiles;
    private final File configFile;
    private final File pluginsFile;
    private final File logsFile;

    public Environment() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public Environment(Settings settings) {
        this.settings = settings;
        this.homeFile = settings.get("path.home") != null ? new File(Strings.cleanPath(settings.get("path.home"))) : new File(System.getProperty("user.dir"));
        this.configFile = settings.get("path.conf") != null ? new File(Strings.cleanPath(settings.get("path.conf"))) : new File(this.homeFile, "config");
        this.pluginsFile = settings.get("path.plugins") != null ? new File(Strings.cleanPath(settings.get("path.plugins"))) : new File(this.homeFile, "plugins");
        this.workFile = settings.get("path.work") != null ? new File(Strings.cleanPath(settings.get("path.work"))) : new File(this.homeFile, "work");
        this.workWithClusterFile = new File(this.workFile, ClusterName.clusterNameFromSettings(settings).value());
        String[] dataPaths = settings.getAsArray("path.data");
        if (dataPaths.length > 0) {
            this.dataFiles = new File[dataPaths.length];
            this.dataWithClusterFiles = new File[dataPaths.length];
            for (int i2 = 0; i2 < dataPaths.length; ++i2) {
                this.dataFiles[i2] = new File(dataPaths[i2]);
                this.dataWithClusterFiles[i2] = new File(this.dataFiles[i2], ClusterName.clusterNameFromSettings(settings).value());
            }
        } else {
            this.dataFiles = new File[]{new File(this.homeFile, "data")};
            this.dataWithClusterFiles = new File[]{new File(new File(this.homeFile, "data"), ClusterName.clusterNameFromSettings(settings).value())};
        }
        this.logsFile = settings.get("path.logs") != null ? new File(Strings.cleanPath(settings.get("path.logs"))) : new File(this.homeFile, "logs");
    }

    public Settings settings() {
        return this.settings;
    }

    public File homeFile() {
        return this.homeFile;
    }

    public File workFile() {
        return this.workFile;
    }

    public File workWithClusterFile() {
        return this.workWithClusterFile;
    }

    public File[] dataFiles() {
        return this.dataFiles;
    }

    public File[] dataWithClusterFiles() {
        return this.dataWithClusterFiles;
    }

    public File configFile() {
        return this.configFile;
    }

    public File pluginsFile() {
        return this.pluginsFile;
    }

    public File logsFile() {
        return this.logsFile;
    }

    public String resolveConfigAndLoadToString(String path2) throws FailedToResolveConfigException, IOException {
        return Streams.copyToString(new InputStreamReader(this.resolveConfig(path2).openStream(), "UTF-8"));
    }

    public URL resolveConfig(String path2) throws FailedToResolveConfigException {
        File f2;
        String origPath = path2;
        File f1 = new File(path2);
        if (f1.exists()) {
            try {
                return f1.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new FailedToResolveConfigException("Failed to resolve path [" + f1 + "]", e);
            }
        }
        if (path2.startsWith("/")) {
            path2 = path2.substring(1);
        }
        if ((f2 = new File(this.configFile, path2)).exists()) {
            try {
                return f2.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new FailedToResolveConfigException("Failed to resolve path [" + f2 + "]", e);
            }
        }
        URL resource2 = this.settings.getClassLoader().getResource(path2);
        if (resource2 != null) {
            return resource2;
        }
        if (!path2.startsWith("config/") && (resource2 = this.settings.getClassLoader().getResource("config/" + path2)) != null) {
            return resource2;
        }
        throw new FailedToResolveConfigException("Failed to resolve config path [" + origPath + "], tried file path [" + f1 + "], path file [" + f2 + "], and classpath");
    }
}

