/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.publish;

import java.io.IOException;
import java.util.HashMap;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.HandlesStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class PublishClusterStateAction
extends AbstractComponent {
    private final TransportService transportService;
    private final DiscoveryNodesProvider nodesProvider;
    private final NewClusterStateListener listener;

    public PublishClusterStateAction(Settings settings, TransportService transportService, DiscoveryNodesProvider nodesProvider, NewClusterStateListener listener) {
        super(settings);
        this.transportService = transportService;
        this.nodesProvider = nodesProvider;
        this.listener = listener;
        transportService.registerHandler("discovery/zen/publish", new PublishClusterStateRequestHandler());
    }

    public void close() {
        this.transportService.removeHandler("discovery/zen/publish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(ClusterState clusterState) {
        DiscoveryNode localNode = this.nodesProvider.nodes().localNode();
        HashMap<Version, CachedStreamOutput.Entry> serializedStates = Maps.newHashMap();
        try {
            for (final DiscoveryNode node : clusterState.nodes()) {
                if (node.equals(localNode)) continue;
                CachedStreamOutput.Entry entry = (CachedStreamOutput.Entry)serializedStates.get(node.version());
                if (entry == null) {
                    try {
                        entry = CachedStreamOutput.popEntry();
                        StreamOutput stream = entry.handles(CompressorFactory.defaultCompressor());
                        stream.setVersion(node.version());
                        ClusterState.Builder.writeTo(clusterState, stream);
                        stream.close();
                        serializedStates.put(node.version(), entry);
                    }
                    catch (Exception e) {
                        this.logger.warn("failed to serialize cluster_state before publishing it to nodes", e, new Object[0]);
                        for (CachedStreamOutput.Entry entry2 : serializedStates.values()) {
                            CachedStreamOutput.pushEntry(entry2);
                        }
                        return;
                    }
                }
                this.transportService.sendRequest(node, "discovery/zen/publish", new PublishClusterStateRequest(entry.bytes().bytes()), TransportRequestOptions.options().withHighType().withCompress(false), new EmptyTransportResponseHandler("same"){

                    @Override
                    public void handleException(TransportException exp2) {
                        PublishClusterStateAction.this.logger.debug("failed to send cluster state to [{}], should be detected as failed soon...", exp2, node);
                    }
                });
            }
        }
        finally {
            for (CachedStreamOutput.Entry entry : serializedStates.values()) {
                CachedStreamOutput.pushEntry(entry);
            }
        }
    }

    private class PublishClusterStateRequestHandler
    extends BaseTransportRequestHandler<PublishClusterStateRequest> {
        static final String ACTION = "discovery/zen/publish";

        private PublishClusterStateRequestHandler() {
        }

        @Override
        public PublishClusterStateRequest newInstance() {
            return new PublishClusterStateRequest();
        }

        @Override
        public void messageReceived(PublishClusterStateRequest request, TransportChannel channel) throws Exception {
            Compressor compressor = CompressorFactory.compressor(request.clusterStateInBytes);
            HandlesStreamInput in = compressor != null ? CachedStreamInput.cachedHandlesCompressed(compressor, request.clusterStateInBytes.streamInput()) : CachedStreamInput.cachedHandles(request.clusterStateInBytes.streamInput());
            ((StreamInput)in).setVersion(request.version);
            ClusterState clusterState = ClusterState.Builder.readFrom(in, PublishClusterStateAction.this.nodesProvider.nodes().localNode());
            PublishClusterStateAction.this.listener.onNewClusterState(clusterState);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    class PublishClusterStateRequest
    extends TransportRequest {
        BytesReference clusterStateInBytes;
        Version version = Version.CURRENT;

        private PublishClusterStateRequest() {
        }

        private PublishClusterStateRequest(BytesReference clusterStateInBytes) {
            this.clusterStateInBytes = clusterStateInBytes;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.clusterStateInBytes = in.readBytesReference();
            this.version = in.getVersion();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBytesReference(this.clusterStateInBytes);
        }
    }

    public static interface NewClusterStateListener {
        public void onNewClusterState(ClusterState var1);
    }
}

