/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping;

import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.multicast.MulticastZenPing;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastZenPing;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class ZenPingService
extends AbstractLifecycleComponent<ZenPing>
implements ZenPing {
    private volatile ImmutableList<? extends ZenPing> zenPings = ImmutableList.of();

    @Inject
    public ZenPingService(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterName clusterName, NetworkService networkService, @Nullable Set<UnicastHostsProvider> unicastHostsProviders) {
        super(settings);
        ImmutableList.Builder zenPingsBuilder = ImmutableList.builder();
        if (this.componentSettings.getAsBoolean("multicast.enabled", true).booleanValue()) {
            zenPingsBuilder.add(new MulticastZenPing(settings, threadPool, transportService, clusterName, networkService));
        }
        zenPingsBuilder.add(new UnicastZenPing(settings, threadPool, transportService, clusterName, unicastHostsProviders));
        this.zenPings = zenPingsBuilder.build();
    }

    public ImmutableList<? extends ZenPing> zenPings() {
        return this.zenPings;
    }

    public void zenPings(ImmutableList<? extends ZenPing> pings) {
        block3: {
            block2: {
                this.zenPings = pings;
                if (!this.lifecycle.started()) break block2;
                for (ZenPing zenPing : this.zenPings) {
                    zenPing.start();
                }
                break block3;
            }
            if (!this.lifecycle.stopped()) break block3;
            for (ZenPing zenPing : this.zenPings) {
                zenPing.stop();
            }
        }
    }

    @Override
    public void setNodesProvider(DiscoveryNodesProvider nodesProvider) {
        if (this.lifecycle.started()) {
            throw new ElasticSearchIllegalStateException("Can't set nodes provider when started");
        }
        for (ZenPing zenPing : this.zenPings) {
            zenPing.setNodesProvider(nodesProvider);
        }
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        for (ZenPing zenPing : this.zenPings) {
            zenPing.start();
        }
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        for (ZenPing zenPing : this.zenPings) {
            zenPing.stop();
        }
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        for (ZenPing zenPing : this.zenPings) {
            zenPing.close();
        }
    }

    public ZenPing.PingResponse[] pingAndWait(TimeValue timeout2) {
        final AtomicReference response = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.ping(new ZenPing.PingListener(){

            @Override
            public void onPing(ZenPing.PingResponse[] pings) {
                response.set(pings);
                latch.countDown();
            }
        }, timeout2);
        try {
            latch.await();
            return (ZenPing.PingResponse[])response.get();
        }
        catch (InterruptedException e) {
            this.logger.trace("pingAndWait interrupted", new Object[0]);
            return null;
        }
    }

    @Override
    public void ping(ZenPing.PingListener listener, TimeValue timeout2) throws ElasticSearchException {
        ImmutableList<? extends ZenPing> zenPings = this.zenPings;
        CompoundPingListener compoundPingListener = new CompoundPingListener(listener, zenPings);
        for (ZenPing zenPing : zenPings) {
            zenPing.ping(compoundPingListener, timeout2);
        }
    }

    private static class CompoundPingListener
    implements ZenPing.PingListener {
        private final ZenPing.PingListener listener;
        private final ImmutableList<? extends ZenPing> zenPings;
        private final AtomicInteger counter;
        private ConcurrentMap<DiscoveryNode, ZenPing.PingResponse> responses = ConcurrentCollections.newConcurrentMap();

        private CompoundPingListener(ZenPing.PingListener listener, ImmutableList<? extends ZenPing> zenPings) {
            this.listener = listener;
            this.zenPings = zenPings;
            this.counter = new AtomicInteger(zenPings.size());
        }

        @Override
        public void onPing(ZenPing.PingResponse[] pings) {
            if (pings != null) {
                for (ZenPing.PingResponse pingResponse : pings) {
                    this.responses.put(pingResponse.target(), pingResponse);
                }
            }
            if (this.counter.decrementAndGet() == 0) {
                this.listener.onPing(this.responses.values().toArray(new ZenPing.PingResponse[this.responses.size()]));
            }
        }
    }
}

