/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.yaml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.jackson.core.JsonEncoding;
import org.elasticsearch.common.jackson.dataformat.yaml.YAMLFactory;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.yaml.YamlXContentGenerator;
import org.elasticsearch.common.xcontent.yaml.YamlXContentParser;

public class YamlXContent
implements XContent {
    static final YAMLFactory yamlFactory = new YAMLFactory();
    public static final YamlXContent yamlXContent = new YamlXContent();

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder(yamlXContent);
    }

    private YamlXContent() {
    }

    @Override
    public XContentType type() {
        return XContentType.YAML;
    }

    @Override
    public byte streamSeparator() {
        throw new ElasticSearchParseException("yaml does not support stream parsing...");
    }

    @Override
    public XContentGenerator createGenerator(OutputStream os) throws IOException {
        return new YamlXContentGenerator(yamlFactory.createJsonGenerator(os, JsonEncoding.UTF8));
    }

    @Override
    public XContentGenerator createGenerator(Writer writer) throws IOException {
        return new YamlXContentGenerator(yamlFactory.createJsonGenerator(writer));
    }

    @Override
    public XContentParser createParser(String content) throws IOException {
        return new YamlXContentParser(yamlFactory.createJsonParser(new FastStringReader(content)));
    }

    @Override
    public XContentParser createParser(InputStream is) throws IOException {
        return new YamlXContentParser(yamlFactory.createJsonParser(is));
    }

    @Override
    public XContentParser createParser(byte[] data2) throws IOException {
        return new YamlXContentParser(yamlFactory.createJsonParser(data2));
    }

    @Override
    public XContentParser createParser(byte[] data2, int offset2, int length2) throws IOException {
        return new YamlXContentParser(yamlFactory.createJsonParser(data2, offset2, length2));
    }

    @Override
    public XContentParser createParser(BytesReference bytes2) throws IOException {
        if (bytes2.hasArray()) {
            return this.createParser(bytes2.array(), bytes2.arrayOffset(), bytes2.length());
        }
        return this.createParser(bytes2.streamInput());
    }

    @Override
    public XContentParser createParser(Reader reader) throws IOException {
        return new YamlXContentParser(yamlFactory.createJsonParser(reader));
    }
}

