/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.smile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.jackson.core.JsonGenerator;
import org.elasticsearch.common.jackson.dataformat.smile.SmileParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContentGenerator;
import org.elasticsearch.common.xcontent.smile.SmileXContent;

public class SmileXContentGenerator
extends JsonXContentGenerator {
    public SmileXContentGenerator(JsonGenerator generator) {
        super(generator);
    }

    @Override
    public XContentType contentType() {
        return XContentType.SMILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRawField(String fieldName, InputStream content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        SmileParser parser = SmileXContent.smileFactory.createJsonParser(content);
        try {
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRawField(String fieldName, byte[] content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        SmileParser parser = SmileXContent.smileFactory.createJsonParser(content);
        try {
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRawField(String fieldName, BytesReference content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        SmileParser parser = content.hasArray() ? SmileXContent.smileFactory.createJsonParser(content.array(), content.arrayOffset(), content.length()) : SmileXContent.smileFactory.createJsonParser(content.streamInput());
        try {
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRawField(String fieldName, byte[] content, int offset2, int length2, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        SmileParser parser = SmileXContent.smileFactory.createJsonParser(content, offset2, length2);
        try {
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
        finally {
            parser.close();
        }
    }
}

