/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.smile.SmileXContent;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;

public class XContentFactory {
    private static int GUESS_HEADER_LENGTH = 20;

    public static XContentBuilder jsonBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.JSON);
    }

    public static XContentBuilder jsonBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(JsonXContent.jsonXContent, os);
    }

    public static XContentBuilder smileBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.SMILE);
    }

    public static XContentBuilder smileBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(SmileXContent.smileXContent, os);
    }

    public static XContentBuilder yamlBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(YamlXContent.yamlXContent, os);
    }

    public static XContentBuilder contentBuilder(XContentType type2, OutputStream outputStream) throws IOException {
        if (type2 == XContentType.JSON) {
            return XContentFactory.jsonBuilder(outputStream);
        }
        if (type2 == XContentType.SMILE) {
            return XContentFactory.smileBuilder(outputStream);
        }
        if (type2 == XContentType.YAML) {
            return XContentFactory.yamlBuilder(outputStream);
        }
        throw new ElasticSearchIllegalArgumentException("No matching content type for " + (Object)((Object)type2));
    }

    public static XContentBuilder contentBuilder(XContentType type2) throws IOException {
        if (type2 == XContentType.JSON) {
            return JsonXContent.contentBuilder();
        }
        if (type2 == XContentType.SMILE) {
            return SmileXContent.contentBuilder();
        }
        if (type2 == XContentType.YAML) {
            return YamlXContent.contentBuilder();
        }
        throw new ElasticSearchIllegalArgumentException("No matching content type for " + (Object)((Object)type2));
    }

    public static XContent xContent(XContentType type2) {
        return type2.xContent();
    }

    public static XContentType xContentType(CharSequence content) {
        int length2;
        int n = length2 = content.length() < GUESS_HEADER_LENGTH ? content.length() : GUESS_HEADER_LENGTH;
        if (length2 == 0) {
            return null;
        }
        char first2 = content.charAt(0);
        if (first2 == '{') {
            return XContentType.JSON;
        }
        if (length2 > 2 && first2 == ':' && content.charAt(1) == ')' && content.charAt(2) == '\n') {
            return XContentType.SMILE;
        }
        if (length2 > 2 && first2 == '-' && content.charAt(1) == '-' && content.charAt(2) == '-') {
            return XContentType.YAML;
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            char c = content.charAt(i2);
            if (c != '{') continue;
            return XContentType.JSON;
        }
        return null;
    }

    public static XContent xContent(CharSequence content) {
        XContentType type2 = XContentFactory.xContentType(content);
        if (type2 == null) {
            throw new ElasticSearchParseException("Failed to derive xcontent from " + content);
        }
        return XContentFactory.xContent(type2);
    }

    public static XContent xContent(byte[] data2) {
        return XContentFactory.xContent(data2, 0, data2.length);
    }

    public static XContent xContent(byte[] data2, int offset2, int length2) {
        XContentType type2 = XContentFactory.xContentType(data2, offset2, length2);
        if (type2 == null) {
            throw new ElasticSearchParseException("Failed to derive xcontent from (offset=" + offset2 + ", length=" + length2 + "): " + Arrays.toString(data2));
        }
        return XContentFactory.xContent(type2);
    }

    public static XContentType xContentType(byte[] data2) {
        return XContentFactory.xContentType(data2, 0, data2.length);
    }

    public static XContentType xContentType(InputStream si) throws IOException {
        int third;
        int first2 = si.read();
        if (first2 == -1) {
            return null;
        }
        int second = si.read();
        if (second == -1) {
            return null;
        }
        if (first2 == 58 && second == 41 && (third = si.read()) == 10) {
            return XContentType.SMILE;
        }
        if (first2 == 123 || second == 123) {
            return XContentType.JSON;
        }
        if (first2 == 45 && second == 45 && (third = si.read()) == 45) {
            return XContentType.YAML;
        }
        for (int i2 = 2; i2 < GUESS_HEADER_LENGTH; ++i2) {
            int val = si.read();
            if (val == -1) {
                return null;
            }
            if (val != 123) continue;
            return XContentType.JSON;
        }
        return null;
    }

    public static XContentType xContentType(byte[] data2, int offset2, int length2) {
        return XContentFactory.xContentType(new BytesArray(data2, offset2, length2));
    }

    public static XContent xContent(BytesReference bytes2) {
        XContentType type2 = XContentFactory.xContentType(bytes2);
        if (type2 == null) {
            throw new ElasticSearchParseException("Failed to derive xcontent from " + bytes2);
        }
        return XContentFactory.xContent(type2);
    }

    public static XContentType xContentType(BytesReference bytes2) {
        int length2;
        int n = length2 = bytes2.length() < GUESS_HEADER_LENGTH ? bytes2.length() : GUESS_HEADER_LENGTH;
        if (length2 == 0) {
            return null;
        }
        byte first2 = bytes2.get(0);
        if (first2 == 123) {
            return XContentType.JSON;
        }
        if (length2 > 2 && first2 == 58 && bytes2.get(1) == 41 && bytes2.get(2) == 10) {
            return XContentType.SMILE;
        }
        if (length2 > 2 && first2 == 45 && bytes2.get(1) == 45 && bytes2.get(2) == 45) {
            return XContentType.YAML;
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            if (bytes2.get(i2) != 123) continue;
            return XContentType.JSON;
        }
        return null;
    }
}

