/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.FastByteArrayOutputStream;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.ReadableInstant;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;
import org.elasticsearch.common.joda.time.format.ISODateTimeFormat;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapConverter;

public final class XContentBuilder
implements BytesStream {
    public static final DateTimeFormatter defaultDatePrinter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    protected static FieldCaseConversion globalFieldCaseConversion = FieldCaseConversion.NONE;
    private XContentGenerator generator;
    private final OutputStream bos;
    private final Object payload;
    private FieldCaseConversion fieldCaseConversion = globalFieldCaseConversion;
    private StringBuilder cachedStringBuilder;

    public static void globalFieldCaseConversion(FieldCaseConversion globalFieldCaseConversion) {
        XContentBuilder.globalFieldCaseConversion = globalFieldCaseConversion;
    }

    public static XContentBuilder builder(XContent xContent) throws IOException {
        return new XContentBuilder(xContent, new FastByteArrayOutputStream());
    }

    public XContentBuilder(XContent xContent, OutputStream bos) throws IOException {
        this(xContent, bos, null);
    }

    public XContentBuilder(XContent xContent, OutputStream bos, @Nullable Object payload) throws IOException {
        this.bos = bos;
        this.generator = xContent.createGenerator(bos);
        this.payload = payload;
    }

    public XContentBuilder fieldCaseConversion(FieldCaseConversion fieldCaseConversion) {
        this.fieldCaseConversion = fieldCaseConversion;
        return this;
    }

    public XContentType contentType() {
        return this.generator.contentType();
    }

    public XContentBuilder prettyPrint() {
        this.generator.usePrettyPrint();
        return this;
    }

    public XContentBuilder field(String name2, ToXContent xContent) throws IOException {
        this.field(name2);
        xContent.toXContent(this, ToXContent.EMPTY_PARAMS);
        return this;
    }

    public XContentBuilder field(String name2, ToXContent xContent, ToXContent.Params params2) throws IOException {
        this.field(name2);
        xContent.toXContent(this, params2);
        return this;
    }

    public XContentBuilder startObject(String name2) throws IOException {
        this.field(name2);
        this.startObject();
        return this;
    }

    public XContentBuilder startObject(String name2, FieldCaseConversion conversion) throws IOException {
        this.field(name2, conversion);
        this.startObject();
        return this;
    }

    public XContentBuilder startObject(XContentBuilderString name2) throws IOException {
        this.field(name2);
        this.startObject();
        return this;
    }

    public XContentBuilder startObject(XContentBuilderString name2, FieldCaseConversion conversion) throws IOException {
        this.field(name2, conversion);
        this.startObject();
        return this;
    }

    public XContentBuilder startObject() throws IOException {
        this.generator.writeStartObject();
        return this;
    }

    public XContentBuilder endObject() throws IOException {
        this.generator.writeEndObject();
        return this;
    }

    public XContentBuilder array(String name2, String ... values2) throws IOException {
        this.startArray(name2);
        for (String value2 : values2) {
            this.value(value2);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder array(XContentBuilderString name2, String ... values2) throws IOException {
        this.startArray(name2);
        for (String value2 : values2) {
            this.value(value2);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder array(String name2, Object ... values2) throws IOException {
        this.startArray(name2);
        for (Object value2 : values2) {
            this.value(value2);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder array(XContentBuilderString name2, Object ... values2) throws IOException {
        this.startArray(name2);
        for (Object value2 : values2) {
            this.value(value2);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder startArray(String name2, FieldCaseConversion conversion) throws IOException {
        this.field(name2, conversion);
        this.startArray();
        return this;
    }

    public XContentBuilder startArray(String name2) throws IOException {
        this.field(name2);
        this.startArray();
        return this;
    }

    public XContentBuilder startArray(XContentBuilderString name2) throws IOException {
        this.field(name2);
        this.startArray();
        return this;
    }

    public XContentBuilder startArray() throws IOException {
        this.generator.writeStartArray();
        return this;
    }

    public XContentBuilder endArray() throws IOException {
        this.generator.writeEndArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2) throws IOException {
        if (this.fieldCaseConversion == FieldCaseConversion.UNDERSCORE) {
            this.generator.writeFieldName(name2.underscore());
        } else if (this.fieldCaseConversion == FieldCaseConversion.CAMELCASE) {
            this.generator.writeFieldName(name2.camelCase());
        } else {
            this.generator.writeFieldName(name2.underscore());
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, FieldCaseConversion conversion) throws IOException {
        if (conversion == FieldCaseConversion.UNDERSCORE) {
            this.generator.writeFieldName(name2.underscore());
        } else if (conversion == FieldCaseConversion.CAMELCASE) {
            this.generator.writeFieldName(name2.camelCase());
        } else {
            this.generator.writeFieldName(name2.underscore());
        }
        return this;
    }

    public XContentBuilder field(String name2) throws IOException {
        if (this.fieldCaseConversion == FieldCaseConversion.UNDERSCORE) {
            if (this.cachedStringBuilder == null) {
                this.cachedStringBuilder = new StringBuilder();
            }
            name2 = Strings.toUnderscoreCase(name2, this.cachedStringBuilder);
        } else if (this.fieldCaseConversion == FieldCaseConversion.CAMELCASE) {
            if (this.cachedStringBuilder == null) {
                this.cachedStringBuilder = new StringBuilder();
            }
            name2 = Strings.toCamelCase(name2, this.cachedStringBuilder);
        }
        this.generator.writeFieldName(name2);
        return this;
    }

    public XContentBuilder field(String name2, FieldCaseConversion conversion) throws IOException {
        if (conversion == FieldCaseConversion.UNDERSCORE) {
            if (this.cachedStringBuilder == null) {
                this.cachedStringBuilder = new StringBuilder();
            }
            name2 = Strings.toUnderscoreCase(name2, this.cachedStringBuilder);
        } else if (conversion == FieldCaseConversion.CAMELCASE) {
            if (this.cachedStringBuilder == null) {
                this.cachedStringBuilder = new StringBuilder();
            }
            name2 = Strings.toCamelCase(name2, this.cachedStringBuilder);
        }
        this.generator.writeFieldName(name2);
        return this;
    }

    public XContentBuilder field(String name2, char[] value2, int offset2, int length2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value2, offset2, length2);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, char[] value2, int offset2, int length2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value2, offset2, length2);
        }
        return this;
    }

    public XContentBuilder field(String name2, String value2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value2);
        }
        return this;
    }

    public XContentBuilder field(String name2, String value2, FieldCaseConversion conversion) throws IOException {
        this.field(name2, conversion);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value2);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, String value2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value2);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, String value2, FieldCaseConversion conversion) throws IOException {
        this.field(name2, conversion);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value2);
        }
        return this;
    }

    public XContentBuilder field(String name2, Integer value2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value2);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, Integer value2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value2);
        }
        return this;
    }

    public XContentBuilder field(String name2, int value2) throws IOException {
        this.field(name2);
        this.generator.writeNumber(value2);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, int value2) throws IOException {
        this.field(name2);
        this.generator.writeNumber(value2);
        return this;
    }

    public XContentBuilder field(String name2, Long value2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value2);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, Long value2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value2);
        }
        return this;
    }

    public XContentBuilder field(String name2, long value2) throws IOException {
        this.field(name2);
        this.generator.writeNumber(value2);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, long value2) throws IOException {
        this.field(name2);
        this.generator.writeNumber(value2);
        return this;
    }

    public XContentBuilder field(String name2, Float value2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value2.floatValue());
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, Float value2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value2.floatValue());
        }
        return this;
    }

    public XContentBuilder field(String name2, float value2) throws IOException {
        this.field(name2);
        this.generator.writeNumber(value2);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, float value2) throws IOException {
        this.field(name2);
        this.generator.writeNumber(value2);
        return this;
    }

    public XContentBuilder field(String name2, Double value2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value2);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, Double value2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value2);
        }
        return this;
    }

    public XContentBuilder field(String name2, double value2) throws IOException {
        this.field(name2);
        this.generator.writeNumber(value2);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, double value2) throws IOException {
        this.field(name2);
        this.generator.writeNumber(value2);
        return this;
    }

    public XContentBuilder field(String name2, BigDecimal value2) throws IOException {
        return this.field(name2, value2, value2.scale(), RoundingMode.HALF_UP, true);
    }

    public XContentBuilder field(XContentBuilderString name2, BigDecimal value2) throws IOException {
        return this.field(name2, value2, value2.scale(), RoundingMode.HALF_UP, true);
    }

    public XContentBuilder field(String name2, BigDecimal value2, int scale, RoundingMode rounding, boolean toDouble) throws IOException {
        this.field(name2);
        if (toDouble) {
            try {
                this.generator.writeNumber(value2.setScale(scale, rounding).doubleValue());
            }
            catch (ArithmeticException e) {
                this.generator.writeString(value2.toEngineeringString());
            }
        } else {
            this.generator.writeString(value2.toEngineeringString());
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, BigDecimal value2, int scale, RoundingMode rounding, boolean toDouble) throws IOException {
        this.field(name2);
        if (toDouble) {
            try {
                this.generator.writeNumber(value2.setScale(scale, rounding).doubleValue());
            }
            catch (ArithmeticException e) {
                this.generator.writeString(value2.toEngineeringString());
            }
        } else {
            this.generator.writeString(value2.toEngineeringString());
        }
        return this;
    }

    public XContentBuilder field(String name2, BytesReference value2) throws IOException {
        this.field(name2);
        if (!value2.hasArray()) {
            value2 = value2.toBytesArray();
        }
        this.generator.writeBinary(value2.array(), value2.arrayOffset(), value2.length());
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, BytesReference value2) throws IOException {
        this.field(name2);
        if (!value2.hasArray()) {
            value2 = value2.toBytesArray();
        }
        this.generator.writeBinary(value2.array(), value2.arrayOffset(), value2.length());
        return this;
    }

    public XContentBuilder field(String name2, Text value2) throws IOException {
        this.field(name2);
        if (value2.hasBytes() && value2.bytes().hasArray()) {
            this.generator.writeUTF8String(value2.bytes().array(), value2.bytes().arrayOffset(), value2.bytes().length());
            return this;
        }
        if (value2.hasString()) {
            this.generator.writeString(value2.string());
            return this;
        }
        BytesArray bytesArray = value2.bytes().toBytesArray();
        this.generator.writeUTF8String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length());
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, Text value2) throws IOException {
        this.field(name2);
        if (value2.hasBytes() && value2.bytes().hasArray()) {
            this.generator.writeUTF8String(value2.bytes().array(), value2.bytes().arrayOffset(), value2.bytes().length());
            return this;
        }
        if (value2.hasString()) {
            this.generator.writeString(value2.string());
            return this;
        }
        BytesArray bytesArray = value2.bytes().toBytesArray();
        this.generator.writeUTF8String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length());
        return this;
    }

    public XContentBuilder field(String name2, byte[] value2, int offset2, int length2) throws IOException {
        this.field(name2);
        this.generator.writeBinary(value2, offset2, length2);
        return this;
    }

    public XContentBuilder field(String name2, Map<String, Object> value2) throws IOException {
        this.field(name2);
        this.value(value2);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, Map<String, Object> value2) throws IOException {
        this.field(name2);
        this.value(value2);
        return this;
    }

    public XContentBuilder field(String name2, Iterable value2) throws IOException {
        this.startArray(name2);
        for (Object o : value2) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, Iterable value2) throws IOException {
        this.startArray(name2);
        for (Object o : value2) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name2, String ... value2) throws IOException {
        this.startArray(name2);
        for (String o : value2) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, String ... value2) throws IOException {
        this.startArray(name2);
        for (String o : value2) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name2, Object ... value2) throws IOException {
        this.startArray(name2);
        for (Object o : value2) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, Object ... value2) throws IOException {
        this.startArray(name2);
        for (Object o : value2) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name2, int ... value2) throws IOException {
        this.startArray(name2);
        int[] arr$ = value2;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, int ... value2) throws IOException {
        this.startArray(name2);
        int[] arr$ = value2;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name2, long ... value2) throws IOException {
        this.startArray(name2);
        long[] arr$ = value2;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, long ... value2) throws IOException {
        this.startArray(name2);
        long[] arr$ = value2;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name2, float ... value2) throws IOException {
        this.startArray(name2);
        float[] arr$ = value2;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Float o = Float.valueOf(arr$[i$]);
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, float ... value2) throws IOException {
        this.startArray(name2);
        float[] arr$ = value2;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Float o = Float.valueOf(arr$[i$]);
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name2, double ... value2) throws IOException {
        this.startArray(name2);
        double[] arr$ = value2;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Double o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, double ... value2) throws IOException {
        this.startArray(name2);
        double[] arr$ = value2;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Double o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name2, Object value2) throws IOException {
        if (value2 == null) {
            this.nullField(name2);
            return this;
        }
        Class<?> type2 = value2.getClass();
        if (type2 == String.class) {
            this.field(name2, (String)value2);
        } else if (type2 == Float.class) {
            this.field(name2, ((Float)value2).floatValue());
        } else if (type2 == Double.class) {
            this.field(name2, (double)((Double)value2));
        } else if (type2 == Integer.class) {
            this.field(name2, (int)((Integer)value2));
        } else if (type2 == Long.class) {
            this.field(name2, (long)((Long)value2));
        } else if (type2 == Short.class) {
            this.field(name2, (int)((Short)value2).shortValue());
        } else if (type2 == Byte.class) {
            this.field(name2, (int)((Byte)value2).byteValue());
        } else if (type2 == Boolean.class) {
            this.field(name2, (boolean)((Boolean)value2));
        } else if (value2 instanceof Date) {
            this.field(name2, (Date)value2);
        } else if (type2 == byte[].class) {
            this.field(name2, (byte[])value2);
        } else if (value2 instanceof ReadableInstant) {
            this.field(name2, (ReadableInstant)value2);
        } else if (value2 instanceof Map) {
            this.field(name2, (Map<String, Object>)((Map)value2));
        } else if (value2 instanceof Iterable) {
            this.field(name2, (Iterable)value2);
        } else if (value2 instanceof Object[]) {
            this.field(name2, (Object[])value2);
        } else if (value2 instanceof int[]) {
            this.field(name2, (int[])value2);
        } else if (value2 instanceof long[]) {
            this.field(name2, (long[])value2);
        } else if (value2 instanceof float[]) {
            this.field(name2, (float[])value2);
        } else if (value2 instanceof double[]) {
            this.field(name2, (double[])value2);
        } else if (value2 instanceof BytesReference) {
            this.field(name2, (BytesReference)value2);
        } else if (value2 instanceof Text) {
            this.field(name2, (Text)value2);
        } else if (value2 instanceof ToXContent) {
            this.field(name2, (ToXContent)value2);
        } else {
            this.field(name2, value2.toString());
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, Object value2) throws IOException {
        if (value2 == null) {
            this.nullField(name2);
            return this;
        }
        Class<?> type2 = value2.getClass();
        if (type2 == String.class) {
            this.field(name2, (String)value2);
        } else if (type2 == Float.class) {
            this.field(name2, ((Float)value2).floatValue());
        } else if (type2 == Double.class) {
            this.field(name2, (double)((Double)value2));
        } else if (type2 == Integer.class) {
            this.field(name2, (int)((Integer)value2));
        } else if (type2 == Long.class) {
            this.field(name2, (long)((Long)value2));
        } else if (type2 == Short.class) {
            this.field(name2, (int)((Short)value2).shortValue());
        } else if (type2 == Byte.class) {
            this.field(name2, (int)((Byte)value2).byteValue());
        } else if (type2 == Boolean.class) {
            this.field(name2, (boolean)((Boolean)value2));
        } else if (value2 instanceof Date) {
            this.field(name2, (Date)value2);
        } else if (type2 == byte[].class) {
            this.field(name2, (byte[])value2);
        } else if (value2 instanceof ReadableInstant) {
            this.field(name2, (ReadableInstant)value2);
        } else if (value2 instanceof Map) {
            this.field(name2, (Map<String, Object>)((Map)value2));
        } else if (value2 instanceof Iterable) {
            this.field(name2, (Iterable)value2);
        } else if (value2 instanceof Object[]) {
            this.field(name2, (Object[])value2);
        } else if (value2 instanceof int[]) {
            this.field(name2, (int[])value2);
        } else if (value2 instanceof long[]) {
            this.field(name2, (long[])value2);
        } else if (value2 instanceof float[]) {
            this.field(name2, (float[])value2);
        } else if (value2 instanceof double[]) {
            this.field(name2, (double[])value2);
        } else if (value2 instanceof BytesReference) {
            this.field(name2, (BytesReference)value2);
        } else if (value2 instanceof Text) {
            this.field(name2, (Text)value2);
        } else {
            this.field(name2, value2.toString());
        }
        return this;
    }

    public XContentBuilder value(Object value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        Class<?> type2 = value2.getClass();
        if (type2 == String.class) {
            this.value((String)value2);
        } else if (type2 == Float.class) {
            this.value(((Float)value2).floatValue());
        } else if (type2 == Double.class) {
            this.value((double)((Double)value2));
        } else if (type2 == Integer.class) {
            this.value((int)((Integer)value2));
        } else if (type2 == Long.class) {
            this.value((long)((Long)value2));
        } else if (type2 == Short.class) {
            this.value(((Short)value2).shortValue());
        } else if (type2 == Byte.class) {
            this.value(((Byte)value2).byteValue());
        } else if (type2 == Boolean.class) {
            this.value((Boolean)value2);
        } else if (type2 == byte[].class) {
            this.value((byte[])value2);
        } else if (value2 instanceof Date) {
            this.value((Date)value2);
        } else if (value2 instanceof ReadableInstant) {
            this.value((ReadableInstant)value2);
        } else if (value2 instanceof BytesReference) {
            this.value((BytesReference)value2);
        } else if (value2 instanceof Text) {
            this.value((Text)value2);
        } else if (value2 instanceof Map) {
            this.value((Map)value2);
        } else if (value2 instanceof Iterable) {
            this.value((Iterable)value2);
        } else {
            throw new IOException("Type not allowed [" + type2 + "]");
        }
        return this;
    }

    public XContentBuilder field(String name2, boolean value2) throws IOException {
        this.field(name2);
        this.generator.writeBoolean(value2);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, boolean value2) throws IOException {
        this.field(name2);
        this.generator.writeBoolean(value2);
        return this;
    }

    public XContentBuilder field(String name2, byte[] value2) throws IOException {
        this.field(name2);
        if (value2 == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeBinary(value2);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name2, byte[] value2) throws IOException {
        this.field(name2);
        return this.value(value2);
    }

    public XContentBuilder field(String name2, ReadableInstant date) throws IOException {
        this.field(name2);
        return this.value(date);
    }

    public XContentBuilder field(XContentBuilderString name2, ReadableInstant date) throws IOException {
        this.field(name2);
        return this.value(date);
    }

    public XContentBuilder field(String name2, ReadableInstant date, DateTimeFormatter formatter) throws IOException {
        this.field(name2);
        return this.value(date, formatter);
    }

    public XContentBuilder field(XContentBuilderString name2, ReadableInstant date, DateTimeFormatter formatter) throws IOException {
        this.field(name2);
        return this.value(date, formatter);
    }

    public XContentBuilder field(String name2, Date date) throws IOException {
        this.field(name2);
        return this.value(date);
    }

    public XContentBuilder field(XContentBuilderString name2, Date date) throws IOException {
        this.field(name2);
        return this.value(date);
    }

    public XContentBuilder field(String name2, Date date, DateTimeFormatter formatter) throws IOException {
        this.field(name2);
        return this.value(date, formatter);
    }

    public XContentBuilder field(XContentBuilderString name2, Date date, DateTimeFormatter formatter) throws IOException {
        this.field(name2);
        return this.value(date, formatter);
    }

    public XContentBuilder nullField(String name2) throws IOException {
        this.generator.writeNullField(name2);
        return this;
    }

    public XContentBuilder nullField(XContentBuilderString name2) throws IOException {
        this.field(name2);
        this.generator.writeNull();
        return this;
    }

    public XContentBuilder nullValue() throws IOException {
        this.generator.writeNull();
        return this;
    }

    public XContentBuilder rawField(String fieldName, byte[] content) throws IOException {
        this.generator.writeRawField(fieldName, content, this.bos);
        return this;
    }

    public XContentBuilder rawField(String fieldName, byte[] content, int offset2, int length2) throws IOException {
        this.generator.writeRawField(fieldName, content, offset2, length2, this.bos);
        return this;
    }

    public XContentBuilder rawField(String fieldName, InputStream content) throws IOException {
        this.generator.writeRawField(fieldName, content, this.bos);
        return this;
    }

    public XContentBuilder rawField(String fieldName, BytesReference content) throws IOException {
        this.generator.writeRawField(fieldName, content, this.bos);
        return this;
    }

    public XContentBuilder value(Boolean value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        return this.value((boolean)value2);
    }

    public XContentBuilder value(boolean value2) throws IOException {
        this.generator.writeBoolean(value2);
        return this;
    }

    public XContentBuilder value(ReadableInstant date) throws IOException {
        return this.value(date, defaultDatePrinter);
    }

    public XContentBuilder value(ReadableInstant date, DateTimeFormatter dateTimeFormatter) throws IOException {
        if (date == null) {
            return this.nullValue();
        }
        return this.value(dateTimeFormatter.print(date));
    }

    public XContentBuilder value(Date date) throws IOException {
        return this.value(date, defaultDatePrinter);
    }

    public XContentBuilder value(Date date, DateTimeFormatter dateTimeFormatter) throws IOException {
        if (date == null) {
            return this.nullValue();
        }
        return this.value(dateTimeFormatter.print(date.getTime()));
    }

    public XContentBuilder value(Integer value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        return this.value((int)value2);
    }

    public XContentBuilder value(int value2) throws IOException {
        this.generator.writeNumber(value2);
        return this;
    }

    public XContentBuilder value(Long value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        return this.value((long)value2);
    }

    public XContentBuilder value(long value2) throws IOException {
        this.generator.writeNumber(value2);
        return this;
    }

    public XContentBuilder value(Float value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        return this.value(value2.floatValue());
    }

    public XContentBuilder value(float value2) throws IOException {
        this.generator.writeNumber(value2);
        return this;
    }

    public XContentBuilder value(Double value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        return this.value((double)value2);
    }

    public XContentBuilder value(double value2) throws IOException {
        this.generator.writeNumber(value2);
        return this;
    }

    public XContentBuilder value(String value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        this.generator.writeString(value2);
        return this;
    }

    public XContentBuilder value(byte[] value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value2);
        return this;
    }

    public XContentBuilder value(byte[] value2, int offset2, int length2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value2, offset2, length2);
        return this;
    }

    public XContentBuilder value(BytesReference value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        if (!value2.hasArray()) {
            value2 = value2.toBytesArray();
        }
        this.generator.writeBinary(value2.array(), value2.arrayOffset(), value2.length());
        return this;
    }

    public XContentBuilder value(Text value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        if (value2.hasBytes() && value2.bytes().hasArray()) {
            this.generator.writeUTF8String(value2.bytes().array(), value2.bytes().arrayOffset(), value2.bytes().length());
            return this;
        }
        if (value2.hasString()) {
            this.generator.writeString(value2.string());
            return this;
        }
        BytesArray bytesArray = value2.bytes().toBytesArray();
        this.generator.writeUTF8String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length());
        return this;
    }

    public XContentBuilder map(Map<String, Object> map) throws IOException {
        if (map == null) {
            return this.nullValue();
        }
        XContentMapConverter.writeMap(this.generator, map);
        return this;
    }

    public XContentBuilder value(Map<String, Object> map) throws IOException {
        if (map == null) {
            return this.nullValue();
        }
        XContentMapConverter.writeMap(this.generator, map);
        return this;
    }

    public XContentBuilder value(Iterable value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        this.startArray();
        for (Object o : value2) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder copyCurrentStructure(XContentParser parser) throws IOException {
        this.generator.copyCurrentStructure(parser);
        return this;
    }

    public XContentBuilder flush() throws IOException {
        this.generator.flush();
        return this;
    }

    public void close() {
        try {
            this.generator.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public Object payload() {
        return this.payload;
    }

    public OutputStream stream() {
        return this.bos;
    }

    @Override
    public BytesReference bytes() {
        this.close();
        return ((BytesStream)((Object)this.bos)).bytes();
    }

    public BytesStream bytesStream() throws IOException {
        this.close();
        return (BytesStream)((Object)this.bos);
    }

    public String string() throws IOException {
        this.close();
        BytesArray bytesArray = this.bytes().toBytesArray();
        return new String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length(), Charsets.UTF_8);
    }

    public static enum FieldCaseConversion {
        NONE,
        UNDERSCORE,
        CAMELCASE;

    }
}

