/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166y;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import sun.misc.Unsafe;

public class ConcurrentLinkedDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    private volatile transient Node<E> head;
    private volatile transient Node<E> tail;
    private static final Node<Object> PREV_TERMINATOR = new Node();
    private static final Node<Object> NEXT_TERMINATOR;
    private static final int HOPS = 2;
    private static final Unsafe UNSAFE;
    private static final long headOffset;
    private static final long tailOffset;

    Node<E> prevTerminator() {
        return PREV_TERMINATOR;
    }

    Node<E> nextTerminator() {
        return NEXT_TERMINATOR;
    }

    private void linkFirst(E e) {
        Node p2;
        Node h;
        ConcurrentLinkedDeque.checkNotNull(e);
        Node newNode = new Node(e);
        block0: while (true) {
            p2 = h = this.head;
            while (true) {
                Node q;
                if ((q = p2.prev) != null) {
                    p2 = q;
                    q = p2.prev;
                    if (q != null) {
                        p2 = h != (h = this.head) ? h : q;
                        continue;
                    }
                }
                if (p2.next == p2) continue block0;
                newNode.lazySetNext(p2);
                if (p2.casPrev(null, newNode)) break block0;
            }
            break;
        }
        if (p2 != h) {
            this.casHead(h, newNode);
        }
    }

    private void linkLast(E e) {
        Node p2;
        Node t;
        ConcurrentLinkedDeque.checkNotNull(e);
        Node newNode = new Node(e);
        block0: while (true) {
            p2 = t = this.tail;
            while (true) {
                Node q;
                if ((q = p2.next) != null) {
                    p2 = q;
                    q = p2.next;
                    if (q != null) {
                        p2 = t != (t = this.tail) ? t : q;
                        continue;
                    }
                }
                if (p2.prev == p2) continue block0;
                newNode.lazySetPrev(p2);
                if (p2.casNext(null, newNode)) break block0;
            }
            break;
        }
        if (p2 != t) {
            this.casTail(t, newNode);
        }
    }

    void unlink(Node<E> x) {
        Node prev = x.prev;
        Node next = x.next;
        if (prev == null) {
            this.unlinkFirst(x, next);
        } else if (next == null) {
            this.unlinkLast(x, prev);
        } else {
            boolean isLast;
            Node activeSucc;
            Node q;
            boolean isFirst;
            Node activePred;
            int hops = 1;
            Node p2 = prev;
            while (true) {
                if (p2.item != null) {
                    activePred = p2;
                    isFirst = false;
                    break;
                }
                q = p2.prev;
                if (q == null) {
                    if (p2.next == p2) {
                        return;
                    }
                    activePred = p2;
                    isFirst = true;
                    break;
                }
                if (p2 == q) {
                    return;
                }
                p2 = q;
                ++hops;
            }
            p2 = next;
            while (true) {
                if (p2.item != null) {
                    activeSucc = p2;
                    isLast = false;
                    break;
                }
                q = p2.next;
                if (q == null) {
                    if (p2.prev == p2) {
                        return;
                    }
                    activeSucc = p2;
                    isLast = true;
                    break;
                }
                if (p2 == q) {
                    return;
                }
                p2 = q;
                ++hops;
            }
            if (hops < 2 && isFirst | isLast) {
                return;
            }
            this.skipDeletedSuccessors(activePred);
            this.skipDeletedPredecessors(activeSucc);
            if (isFirst | isLast && activePred.next == activeSucc && activeSucc.prev == activePred && (isFirst ? activePred.prev == null : activePred.item != null) && (isLast ? activeSucc.next == null : activeSucc.item != null)) {
                this.updateHead();
                this.updateTail();
                x.lazySetPrev(isFirst ? this.prevTerminator() : x);
                x.lazySetNext(isLast ? this.nextTerminator() : x);
            }
        }
    }

    private void unlinkFirst(Node<E> first2, Node<E> next) {
        Node<E> o = null;
        Node<E> p2 = next;
        while (true) {
            Node q;
            if (p2.item != null || (q = p2.next) == null) {
                if (o != null && p2.prev != p2 && first2.casNext(next, p2)) {
                    this.skipDeletedPredecessors(p2);
                    if (first2.prev == null && (p2.next == null || p2.item != null) && p2.prev == first2) {
                        this.updateHead();
                        this.updateTail();
                        o.lazySetNext(o);
                        o.lazySetPrev(this.prevTerminator());
                    }
                }
                return;
            }
            if (p2 == q) {
                return;
            }
            o = p2;
            p2 = q;
        }
    }

    private void unlinkLast(Node<E> last2, Node<E> prev) {
        Node<E> o = null;
        Node<E> p2 = prev;
        while (true) {
            Node q;
            if (p2.item != null || (q = p2.prev) == null) {
                if (o != null && p2.next != p2 && last2.casPrev(prev, p2)) {
                    this.skipDeletedSuccessors(p2);
                    if (last2.next == null && (p2.prev == null || p2.item != null) && p2.next == last2) {
                        this.updateHead();
                        this.updateTail();
                        o.lazySetPrev(o);
                        o.lazySetNext(this.nextTerminator());
                    }
                }
                return;
            }
            if (p2 == q) {
                return;
            }
            o = p2;
            p2 = q;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateHead() {
        block0: while (true) {
            h = this.head;
            if (h.item != null || (p = h.prev) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((q = p.prev) == null) break block4;
                        p = q;
                        q = p.prev;
                        if (q != null) break block5;
                    }
                    if (!this.casHead(h, p)) continue block0;
                    return;
                }
                if (h == this.head) ** break;
                continue block0;
                p = q;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateTail() {
        block0: while (true) {
            t = this.tail;
            if (t.item != null || (p = t.next) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((q = p.next) == null) break block4;
                        p = q;
                        q = p.next;
                        if (q != null) break block5;
                    }
                    if (!this.casTail(t, p)) continue block0;
                    return;
                }
                if (t == this.tail) ** break;
                continue block0;
                p = q;
            }
            break;
        }
    }

    private void skipDeletedPredecessors(Node<E> x) {
        block0: do {
            Node prev;
            Node p2 = prev = x.prev;
            while (p2.item == null) {
                Node q = p2.prev;
                if (q == null) {
                    if (p2.next != p2) break;
                    continue block0;
                }
                if (p2 == q) continue block0;
                p2 = q;
            }
            if (prev != p2 && !x.casPrev(prev, p2)) continue;
            return;
        } while (x.item != null || x.next == null);
    }

    private void skipDeletedSuccessors(Node<E> x) {
        block0: do {
            Node next;
            Node p2 = next = x.next;
            while (p2.item == null) {
                Node q = p2.next;
                if (q == null) {
                    if (p2.prev != p2) break;
                    continue block0;
                }
                if (p2 == q) continue block0;
                p2 = q;
            }
            if (next != p2 && !x.casNext(next, p2)) continue;
            return;
        } while (x.item != null || x.prev == null);
    }

    final Node<E> succ(Node<E> p2) {
        Node q = p2.next;
        return p2 == q ? this.first() : q;
    }

    final Node<E> pred(Node<E> p2) {
        Node q = p2.prev;
        return p2 == q ? this.last() : q;
    }

    Node<E> first() {
        Node<E> h;
        Node<E> p2;
        block0: do {
            Node q;
            p2 = h = this.head;
            while ((q = p2.prev) != null) {
                p2 = q;
                q = p2.prev;
                if (q == null) continue block0;
                p2 = h != (h = this.head) ? h : q;
            }
        } while (p2 != h && !this.casHead(h, p2));
        return p2;
    }

    Node<E> last() {
        Node<E> t;
        Node<E> p2;
        block0: do {
            Node q;
            p2 = t = this.tail;
            while ((q = p2.next) != null) {
                p2 = q;
                q = p2.next;
                if (q == null) continue block0;
                p2 = t != (t = this.tail) ? t : q;
            }
        } while (p2 != t && !this.casTail(t, p2));
        return p2;
    }

    private static void checkNotNull(Object v) {
        if (v == null) {
            throw new NullPointerException();
        }
    }

    private E screenNullResult(E v) {
        if (v == null) {
            throw new NoSuchElementException();
        }
        return v;
    }

    private ArrayList<E> toArrayList() {
        ArrayList list2 = new ArrayList();
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null) {
                list2.add(item);
            }
            p2 = this.succ(p2);
        }
        return list2;
    }

    public ConcurrentLinkedDeque() {
        this.tail = new Node<Object>(null);
        this.head = this.tail;
    }

    public ConcurrentLinkedDeque(Collection<? extends E> c) {
        Node<E> h = null;
        Node<E> t = null;
        for (E e : c) {
            ConcurrentLinkedDeque.checkNotNull(e);
            Node<E> newNode = new Node<E>(e);
            if (h == null) {
                h = t = newNode;
                continue;
            }
            t.lazySetNext(newNode);
            newNode.lazySetPrev(t);
            t = newNode;
        }
        this.initHeadTail(h, t);
    }

    private void initHeadTail(Node<E> h, Node<E> t) {
        if (h == t) {
            if (h == null) {
                t = new Node<Object>(null);
                h = t;
            } else {
                Node<Object> newNode = new Node<Object>(null);
                t.lazySetNext(newNode);
                newNode.lazySetPrev(t);
                t = newNode;
            }
        }
        this.head = h;
        this.tail = t;
    }

    @Override
    public void addFirst(E e) {
        this.linkFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.linkLast(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.linkFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.linkLast(e);
        return true;
    }

    @Override
    public E peekFirst() {
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null) {
                return item;
            }
            p2 = this.succ(p2);
        }
        return null;
    }

    @Override
    public E peekLast() {
        Node<E> p2 = this.last();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null) {
                return item;
            }
            p2 = this.pred(p2);
        }
        return null;
    }

    @Override
    public E getFirst() {
        return this.screenNullResult(this.peekFirst());
    }

    @Override
    public E getLast() {
        return this.screenNullResult(this.peekLast());
    }

    @Override
    public E pollFirst() {
        Node<Object> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && p2.casItem(item, null)) {
                this.unlink(p2);
                return item;
            }
            p2 = this.succ(p2);
        }
        return null;
    }

    @Override
    public E pollLast() {
        Node<Object> p2 = this.last();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && p2.casItem(item, null)) {
                this.unlink(p2);
                return item;
            }
            p2 = this.pred(p2);
        }
        return null;
    }

    @Override
    public E removeFirst() {
        return this.screenNullResult(this.pollFirst());
    }

    @Override
    public E removeLast() {
        return this.screenNullResult(this.pollLast());
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public boolean add(E e) {
        return this.offerLast(e);
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        ConcurrentLinkedDeque.checkNotNull(o);
        Node<Object> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && o.equals(item) && p2.casItem(item, null)) {
                this.unlink(p2);
                return true;
            }
            p2 = this.succ(p2);
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        ConcurrentLinkedDeque.checkNotNull(o);
        Node<Object> p2 = this.last();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && o.equals(item) && p2.casItem(item, null)) {
                this.unlink(p2);
                return true;
            }
            p2 = this.pred(p2);
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && o.equals(item)) {
                return true;
            }
            p2 = this.succ(p2);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.peekFirst() == null;
    }

    @Override
    public int size() {
        int count2 = 0;
        Node<E> p2 = this.first();
        while (p2 != null && (p2.item == null || ++count2 != Integer.MAX_VALUE)) {
            p2 = this.succ(p2);
        }
        return count2;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Node t;
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Node beginningOfTheEnd = null;
        Node last2 = null;
        for (E e : c) {
            ConcurrentLinkedDeque.checkNotNull(e);
            Node newNode = new Node(e);
            if (beginningOfTheEnd == null) {
                beginningOfTheEnd = last2 = newNode;
                continue;
            }
            last2.lazySetNext(newNode);
            newNode.lazySetPrev(last2);
            last2 = newNode;
        }
        if (beginningOfTheEnd == null) {
            return false;
        }
        block1: while (true) {
            Node p2 = t = this.tail;
            while (true) {
                Node q;
                if ((q = p2.next) != null) {
                    p2 = q;
                    q = p2.next;
                    if (q != null) {
                        p2 = t != (t = this.tail) ? t : q;
                        continue;
                    }
                }
                if (p2.prev == p2) continue block1;
                beginningOfTheEnd.lazySetPrev(p2);
                if (p2.casNext(null, beginningOfTheEnd)) break block1;
            }
            break;
        }
        if (!this.casTail(t, last2)) {
            t = this.tail;
            if (last2.next == null) {
                this.casTail(t, last2);
            }
        }
        return true;
    }

    @Override
    public void clear() {
        while (this.pollFirst() != null) {
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArrayList().toArray(a);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null) {
                s2.writeObject(item);
            }
            p2 = this.succ(p2);
        }
        s2.writeObject(null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        Object item;
        s2.defaultReadObject();
        Node<Object> h = null;
        Node<Object> t = null;
        while ((item = s2.readObject()) != null) {
            Node<Object> newNode = new Node<Object>(item);
            if (h == null) {
                h = t = newNode;
                continue;
            }
            t.lazySetNext(newNode);
            newNode.lazySetPrev(t);
            t = newNode;
        }
        this.initHeadTail(h, t);
    }

    private boolean casHead(Node<E> cmp2, Node<E> val) {
        return UNSAFE.compareAndSwapObject(this, headOffset, cmp2, val);
    }

    private boolean casTail(Node<E> cmp2, Node<E> val) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, cmp2, val);
    }

    static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException tryReflectionInstead) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static {
        ConcurrentLinkedDeque.PREV_TERMINATOR.next = PREV_TERMINATOR;
        NEXT_TERMINATOR = new Node();
        ConcurrentLinkedDeque.NEXT_TERMINATOR.prev = NEXT_TERMINATOR;
        try {
            UNSAFE = ConcurrentLinkedDeque.getUnsafe();
            Class<ConcurrentLinkedDeque> k = ConcurrentLinkedDeque.class;
            headOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("tail"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        @Override
        Node<E> startNode() {
            return ConcurrentLinkedDeque.this.last();
        }

        @Override
        Node<E> nextNode(Node<E> p2) {
            return ConcurrentLinkedDeque.this.pred(p2);
        }
    }

    private class Itr
    extends AbstractItr {
        private Itr() {
        }

        @Override
        Node<E> startNode() {
            return ConcurrentLinkedDeque.this.first();
        }

        @Override
        Node<E> nextNode(Node<E> p2) {
            return ConcurrentLinkedDeque.this.succ(p2);
        }
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        abstract Node<E> startNode();

        abstract Node<E> nextNode(Node<E> var1);

        AbstractItr() {
            this.advance();
        }

        private void advance() {
            Node p2;
            this.lastRet = this.nextNode;
            Node node = p2 = this.nextNode == null ? this.startNode() : this.nextNode(this.nextNode);
            while (true) {
                if (p2 == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    break;
                }
                Object item = p2.item;
                if (item != null) {
                    this.nextNode = p2;
                    this.nextItem = item;
                    break;
                }
                p2 = this.nextNode(p2);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public E next() {
            Object item = this.nextItem;
            if (item == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return item;
        }

        @Override
        public void remove() {
            Node l = this.lastRet;
            if (l == null) {
                throw new IllegalStateException();
            }
            l.item = null;
            ConcurrentLinkedDeque.this.unlink(l);
            this.lastRet = null;
        }
    }

    static final class Node<E> {
        volatile Node<E> prev;
        volatile E item;
        volatile Node<E> next;
        private static final Unsafe UNSAFE;
        private static final long prevOffset;
        private static final long itemOffset;
        private static final long nextOffset;

        Node() {
        }

        Node(E item) {
            UNSAFE.putObject(this, itemOffset, item);
        }

        boolean casItem(E cmp2, E val) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, cmp2, val);
        }

        void lazySetNext(Node<E> val) {
            UNSAFE.putOrderedObject(this, nextOffset, val);
        }

        boolean casNext(Node<E> cmp2, Node<E> val) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, cmp2, val);
        }

        void lazySetPrev(Node<E> val) {
            UNSAFE.putOrderedObject(this, prevOffset, val);
        }

        boolean casPrev(Node<E> cmp2, Node<E> val) {
            return UNSAFE.compareAndSwapObject(this, prevOffset, cmp2, val);
        }

        static {
            try {
                UNSAFE = ConcurrentLinkedDeque.getUnsafe();
                Class<Node> k = Node.class;
                prevOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("prev"));
                itemOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("item"));
                nextOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("next"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }
}

