/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166e.extra;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.elasticsearch.common.util.concurrent.jsr166e.StampedLock;

public class ReadMostlyVector<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    Object[] array;
    final StampedLock lock;
    int count;
    final int capacityIncrement;
    static final int INITIAL_CAP = 16;

    public ReadMostlyVector(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.array = new Object[initialCapacity];
        this.capacityIncrement = capacityIncrement;
        this.lock = new StampedLock();
    }

    public ReadMostlyVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ReadMostlyVector() {
        this.capacityIncrement = 0;
        this.lock = new StampedLock();
    }

    public ReadMostlyVector(Collection<? extends E> c) {
        Object[] elements = c.toArray();
        if (elements.getClass() != Object[].class) {
            elements = Arrays.copyOf(elements, elements.length, Object[].class);
        }
        this.array = elements;
        this.count = elements.length;
        this.capacityIncrement = 0;
        this.lock = new StampedLock();
    }

    ReadMostlyVector(Object[] array, int count2, int capacityIncrement) {
        this.array = array;
        this.count = count2;
        this.capacityIncrement = capacityIncrement;
        this.lock = new StampedLock();
    }

    final Object[] grow(int minCapacity) {
        int newCapacity;
        Object[] items = this.array;
        if (this.array == null) {
            newCapacity = 16;
        } else {
            int oldCapacity = this.array.length;
            newCapacity = oldCapacity + (this.capacityIncrement > 0 ? this.capacityIncrement : oldCapacity);
        }
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
        }
        this.array = items == null ? new Object[newCapacity] : Arrays.copyOf(items, newCapacity);
        return this.array;
    }

    static int findFirstIndex(Object[] items, Object x, int index2, int fence) {
        int len;
        if (items != null && (len = items.length) > 0) {
            int start2 = index2 < 0 ? 0 : index2;
            int bound = fence < len ? fence : len;
            for (int i2 = start2; i2 < bound; ++i2) {
                Object e = items[i2];
                if (!(x == null ? e == null : x.equals(e))) continue;
                return i2;
            }
        }
        return -1;
    }

    static int findLastIndex(Object[] items, Object x, int index2, int origin) {
        int len;
        if (items != null && (len = items.length) > 0) {
            int last2 = index2 < len ? index2 : len - 1;
            int start2 = origin < 0 ? 0 : origin;
            for (int i2 = last2; i2 >= start2; --i2) {
                Object e = items[i2];
                if (!(x == null ? e == null : x.equals(e))) continue;
                return i2;
            }
        }
        return -1;
    }

    final void rawAdd(E e) {
        int n = this.count;
        Object[] items = this.array;
        if (items == null || n >= items.length) {
            items = this.grow(n + 1);
        }
        items[n] = e;
        this.count = n + 1;
    }

    final void rawAddAt(int index2, E e) {
        int n = this.count;
        Object[] items = this.array;
        if (index2 > n) {
            throw new ArrayIndexOutOfBoundsException(index2);
        }
        if (items == null || n >= items.length) {
            items = this.grow(n + 1);
        }
        if (index2 < n) {
            System.arraycopy(items, index2, items, index2 + 1, n - index2);
        }
        items[index2] = e;
        this.count = n + 1;
    }

    final boolean rawAddAllAt(int index2, Object[] elements) {
        int mv;
        int n = this.count;
        Object[] items = this.array;
        if (index2 < 0 || index2 > n) {
            throw new ArrayIndexOutOfBoundsException(index2);
        }
        int len = elements.length;
        if (len == 0) {
            return false;
        }
        int newCount = n + len;
        if (items == null || newCount >= items.length) {
            items = this.grow(newCount);
        }
        if ((mv = n - index2) > 0) {
            System.arraycopy(items, index2, items, index2 + len, mv);
        }
        System.arraycopy(elements, 0, items, index2, len);
        this.count = newCount;
        return true;
    }

    final boolean rawRemoveAt(int index2) {
        int n = this.count - 1;
        Object[] items = this.array;
        if (items == null || index2 < 0 || index2 > n) {
            return false;
        }
        int mv = n - index2;
        if (mv > 0) {
            System.arraycopy(items, index2 + 1, items, index2, mv);
        }
        items[n] = null;
        this.count = n;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean lockedRemoveAll(Collection<?> c, int origin, int bound) {
        boolean removed = false;
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            int fence;
            int n = this.count;
            int n2 = fence = bound < 0 || bound > n ? n : bound;
            if (origin >= 0 && origin < fence) {
                for (Object x : c) {
                    while (this.rawRemoveAt(ReadMostlyVector.findFirstIndex(this.array, x, origin, fence))) {
                        removed = true;
                    }
                }
            }
        }
        finally {
            lock2.unlockWrite(stamp);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean lockedRetainAll(Collection<?> c, int origin, int bound) {
        StampedLock lock2 = this.lock;
        boolean removed = false;
        if (c != this) {
            long stamp = lock2.writeLock();
            try {
                int i2;
                int n;
                Object[] items = this.array;
                if (this.array != null && (n = this.count) > 0 && n < items.length && (i2 = origin) >= 0) {
                    int fence;
                    int n2 = fence = bound < 0 || bound > n ? n : bound;
                    while (i2 < fence) {
                        int mv;
                        if (c.contains(items[i2])) {
                            ++i2;
                            continue;
                        }
                        --fence;
                        if ((mv = --n - i2) <= 0) continue;
                        System.arraycopy(items, i2 + 1, items, i2, mv);
                    }
                    if (this.count != n) {
                        this.count = n;
                        removed = true;
                    }
                }
            }
            finally {
                lock2.unlockWrite(stamp);
            }
        }
        return removed;
    }

    final void internalClear(int origin, int bound) {
        int len;
        Object[] items = this.array;
        if (this.array != null && (len = items.length) > 0) {
            int n;
            if (origin < 0) {
                origin = 0;
            }
            if ((n = this.count) > len) {
                n = len;
            }
            int fence = bound < 0 || bound > n ? n : bound;
            int removed = fence - origin;
            int newCount = n - removed;
            int mv = n - (origin + removed);
            if (mv > 0) {
                System.arraycopy(items, origin + removed, items, origin, mv);
            }
            for (int i2 = n; i2 < newCount; ++i2) {
                items[i2] = null;
            }
            this.count = newCount;
        }
    }

    final boolean internalContainsAll(Collection<?> c, int origin, int bound) {
        int len;
        Object[] items = this.array;
        if (this.array != null && (len = items.length) > 0) {
            int n;
            if (origin < 0) {
                origin = 0;
            }
            if ((n = this.count) > len) {
                n = len;
            }
            int fence = bound < 0 || bound > n ? n : bound;
            for (Object e : c) {
                if (ReadMostlyVector.findFirstIndex(items, e, origin, fence) >= 0) continue;
                return false;
            }
        } else if (!c.isEmpty()) {
            return false;
        }
        return true;
    }

    final boolean internalEquals(List<?> list2, int origin, int bound) {
        int len;
        Object[] items = this.array;
        if (this.array != null && (len = items.length) > 0) {
            int n;
            if (origin < 0) {
                origin = 0;
            }
            if ((n = this.count) > len) {
                n = len;
            }
            int fence = bound < 0 || bound > n ? n : bound;
            Iterator<?> it = list2.iterator();
            for (int i2 = origin; i2 < fence; ++i2) {
                if (!it.hasNext()) {
                    return false;
                }
                Object x = items[i2];
                Object y = it.next();
                if (x == y || x != null && x.equals(y)) continue;
                return false;
            }
            if (it.hasNext()) {
                return false;
            }
        } else if (!list2.isEmpty()) {
            return false;
        }
        return true;
    }

    final int internalHashCode(int origin, int bound) {
        int len;
        int hash2 = 1;
        Object[] items = this.array;
        if (this.array != null && (len = items.length) > 0) {
            int n;
            if (origin < 0) {
                origin = 0;
            }
            if ((n = this.count) > len) {
                n = len;
            }
            int fence = bound < 0 || bound > n ? n : bound;
            for (int i2 = origin; i2 < fence; ++i2) {
                Object e = items[i2];
                hash2 = 31 * hash2 + (e == null ? 0 : e.hashCode());
            }
        }
        return hash2;
    }

    final String internalToString(int origin, int bound) {
        int len;
        Object[] items = this.array;
        if (this.array != null && (len = items.length) > 0) {
            int i2;
            int n = this.count;
            if (n > len) {
                n = len;
            }
            int fence = bound < 0 || bound > n ? n : bound;
            int n2 = i2 = origin < 0 ? 0 : origin;
            if (i2 != fence) {
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                while (true) {
                    Object e;
                    sb.append((e = items[i2]) == this ? "(this Collection)" : e.toString());
                    if (++i2 >= fence) break;
                    sb.append(',').append(' ');
                }
                return sb.append(']').toString();
            }
        }
        return "[]";
    }

    final Object[] internalToArray(int origin, int bound) {
        int len;
        Object[] items = this.array;
        if (this.array != null && (len = items.length) > 0) {
            int i2;
            int n;
            if (origin < 0) {
                origin = 0;
            }
            if ((n = this.count) > len) {
                n = len;
            }
            int fence = bound < 0 || bound > n ? n : bound;
            int n2 = i2 = origin < 0 ? 0 : origin;
            if (i2 != fence) {
                return Arrays.copyOfRange(items, i2, fence, Object[].class);
            }
        }
        return new Object[0];
    }

    final <T> T[] internalToArray(T[] a, int origin, int bound) {
        int len;
        int alen = a.length;
        Object[] items = this.array;
        if (this.array != null && (len = items.length) > 0) {
            int n;
            if (origin < 0) {
                origin = 0;
            }
            if ((n = this.count) > len) {
                n = len;
            }
            int fence = bound < 0 || bound > n ? n : bound;
            int i2 = origin < 0 ? 0 : origin;
            int rlen = fence - origin;
            if (rlen > 0) {
                if (alen >= rlen) {
                    System.arraycopy(items, 0, a, origin, rlen);
                    if (alen > rlen) {
                        a[rlen] = null;
                    }
                    return a;
                }
                return Arrays.copyOfRange(items, i2, fence, a.getClass());
            }
        }
        if (alen > 0) {
            a[0] = null;
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            this.rawAdd(e);
        }
        finally {
            lock2.unlockWrite(stamp);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index2, E element) {
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            this.rawAddAt(index2, element);
        }
        finally {
            lock2.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] elements = c.toArray();
        int len = elements.length;
        if (len == 0) {
            return false;
        }
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            Object[] items = this.array;
            int n = this.count;
            int newCount = n + len;
            if (items == null || newCount >= items.length) {
                items = this.grow(newCount);
            }
            System.arraycopy(elements, 0, items, n, len);
            this.count = newCount;
        }
        finally {
            lock2.unlockWrite(stamp);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index2, Collection<? extends E> c) {
        boolean ret;
        Object[] elements = c.toArray();
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            ret = this.rawAddAllAt(index2, elements);
        }
        finally {
            lock2.unlockWrite(stamp);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            int n = this.count;
            Object[] items = this.array;
            if (items != null) {
                for (int i2 = 0; i2 < n; ++i2) {
                    items[i2] = null;
                }
            }
            this.count = 0;
        }
        finally {
            lock2.unlockWrite(stamp);
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o, 0) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        boolean ret;
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            ret = this.internalContainsAll(c, 0, -1);
        }
        finally {
            lock2.unlockRead(stamp);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            boolean bl = this.internalEquals((List)o, 0, -1);
            return bl;
        }
        finally {
            lock2.unlockRead(stamp);
        }
    }

    @Override
    public E get(int index2) {
        StampedLock lock2 = this.lock;
        long stamp = lock2.tryOptimisticRead();
        if (index2 >= 0) {
            Object[] items = this.array;
            if (this.array != null && index2 < this.count && index2 < items.length) {
                Object e = items[index2];
                if (lock2.validate(stamp)) {
                    return (E)e;
                }
            }
        }
        return this.lockedGet(index2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E lockedGet(int index2) {
        boolean oobe = false;
        Object e = null;
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            Object[] items = this.array;
            if (this.array != null && index2 < items.length && index2 < this.count && index2 >= 0) {
                e = items[index2];
            } else {
                oobe = true;
            }
        }
        finally {
            lock2.unlockRead(stamp);
        }
        if (oobe) {
            throw new ArrayIndexOutOfBoundsException(index2);
        }
        return (E)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        int h;
        StampedLock lock2 = this.lock;
        long s2 = lock2.readLock();
        try {
            h = this.internalHashCode(0, -1);
        }
        finally {
            lock2.unlockRead(s2);
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        int idx;
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            idx = ReadMostlyVector.findFirstIndex(this.array, o, 0, this.count);
        }
        finally {
            lock2.unlockRead(stamp);
        }
        return idx;
    }

    @Override
    public boolean isEmpty() {
        StampedLock lock2 = this.lock;
        long stamp = lock2.tryOptimisticRead();
        return this.count == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        int idx;
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            idx = ReadMostlyVector.findLastIndex(this.array, o, this.count - 1, 0);
        }
        finally {
            lock2.unlockRead(stamp);
        }
        return idx;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new Itr(this, 0);
    }

    @Override
    public ListIterator<E> listIterator(int index2) {
        return new Itr(this, index2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index2) {
        Object oldValue = null;
        boolean oobe = false;
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            if (index2 < 0 || index2 >= this.count) {
                oobe = true;
            } else {
                oldValue = this.array[index2];
                this.rawRemoveAt(index2);
            }
        }
        finally {
            lock2.unlockWrite(stamp);
        }
        if (oobe) {
            throw new ArrayIndexOutOfBoundsException(index2);
        }
        return (E)oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            boolean bl = this.rawRemoveAt(ReadMostlyVector.findFirstIndex(this.array, o, 0, this.count));
            return bl;
        }
        finally {
            lock2.unlockWrite(stamp);
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.lockedRemoveAll(c, 0, -1);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.lockedRetainAll(c, 0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index2, E element) {
        Object oldValue = null;
        boolean oobe = false;
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            Object[] items = this.array;
            if (items == null || index2 < 0 || index2 >= this.count) {
                oobe = true;
            } else {
                oldValue = items[index2];
                items[index2] = element;
            }
        }
        finally {
            lock2.unlockWrite(stamp);
        }
        if (oobe) {
            throw new ArrayIndexOutOfBoundsException(index2);
        }
        return (E)oldValue;
    }

    @Override
    public int size() {
        StampedLock lock2 = this.lock;
        long stamp = lock2.tryOptimisticRead();
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lockedSize() {
        int n;
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            n = this.count;
        }
        finally {
            lock2.unlockRead(stamp);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        int ssize = toIndex - fromIndex;
        if (ssize >= 0 && fromIndex >= 0) {
            ReadMostlyVectorSublist ret = null;
            StampedLock lock2 = this.lock;
            long stamp = lock2.readLock();
            try {
                if (toIndex <= this.count) {
                    ret = new ReadMostlyVectorSublist(this, fromIndex, ssize);
                }
            }
            finally {
                lock2.unlockRead(stamp);
            }
            if (ret != null) {
                return ret;
            }
        }
        throw new ArrayIndexOutOfBoundsException(fromIndex < 0 ? fromIndex : toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            Object[] objectArray = this.internalToArray(0, -1);
            return objectArray;
        }
        finally {
            lock2.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            T[] TArray = this.internalToArray(a, 0, -1);
            return TArray;
        }
        finally {
            lock2.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            String string2 = this.internalToString(0, -1);
            return string2;
        }
        finally {
            lock2.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIfAbsent(E e) {
        boolean ret;
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            if (ReadMostlyVector.findFirstIndex(this.array, e, 0, this.count) < 0) {
                this.rawAdd(e);
                ret = true;
            } else {
                ret = false;
            }
        }
        finally {
            lock2.unlockWrite(stamp);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection<? extends E> c) {
        int added = 0;
        Object[] cs = c.toArray();
        int clen = cs.length;
        if (clen != 0) {
            long stamp = this.lock.writeLock();
            try {
                for (int i2 = 0; i2 < clen; ++i2) {
                    Object e = cs[i2];
                    if (ReadMostlyVector.findFirstIndex(this.array, e, 0, this.count) >= 0) continue;
                    this.rawAdd(e);
                    ++added;
                }
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }
        return added;
    }

    public Iterator<E> snapshotIterator() {
        return new SnapshotIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachReadOnly(Action<E> action) {
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            int n;
            int len;
            Object[] items = this.array;
            if (this.array != null && (len = items.length) > 0 && (n = this.count) <= len) {
                for (int i2 = 0; i2 < n; ++i2) {
                    Object e = items[i2];
                    action.apply(e);
                }
            }
        }
        finally {
            lock2.unlockRead(stamp);
        }
    }

    public E firstElement() {
        StampedLock lock2 = this.lock;
        long stamp = lock2.tryOptimisticRead();
        Object[] items = this.array;
        if (this.array != null && this.count > 0 && items.length > 0) {
            Object e = items[0];
            if (lock2.validate(stamp)) {
                return (E)e;
            }
        }
        return this.lockedFirstElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E lockedFirstElement() {
        Object e = null;
        boolean oobe = false;
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            Object[] items = this.array;
            if (items != null && this.count > 0 && items.length > 0) {
                e = items[0];
            } else {
                oobe = true;
            }
        }
        finally {
            lock2.unlockRead(stamp);
        }
        if (oobe) {
            throw new NoSuchElementException();
        }
        return (E)e;
    }

    public E lastElement() {
        int i2;
        StampedLock lock2 = this.lock;
        long stamp = lock2.tryOptimisticRead();
        Object[] items = this.array;
        if (this.array != null && (i2 = this.count - 1) >= 0 && i2 < items.length) {
            Object e = items[i2];
            if (lock2.validate(stamp)) {
                return (E)e;
            }
        }
        return this.lockedLastElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E lockedLastElement() {
        Object e = null;
        boolean oobe = false;
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            Object[] items = this.array;
            int i2 = this.count - 1;
            if (items != null && i2 >= 0 && i2 < items.length) {
                e = items[i2];
            } else {
                oobe = true;
            }
        }
        finally {
            lock2.unlockRead(stamp);
        }
        if (oobe) {
            throw new NoSuchElementException();
        }
        return (E)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o, int index2) {
        int idx;
        if (index2 < 0) {
            throw new ArrayIndexOutOfBoundsException(index2);
        }
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            idx = ReadMostlyVector.findFirstIndex(this.array, o, index2, this.count);
        }
        finally {
            lock2.unlockRead(stamp);
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o, int index2) {
        boolean oobe = false;
        int idx = -1;
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            if (index2 < this.count) {
                idx = ReadMostlyVector.findLastIndex(this.array, o, index2, 0);
            } else {
                oobe = true;
            }
        }
        finally {
            lock2.unlockRead(stamp);
        }
        if (oobe) {
            throw new ArrayIndexOutOfBoundsException(index2);
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int newSize) {
        if (newSize < 0) {
            throw new ArrayIndexOutOfBoundsException(newSize);
        }
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            int n = this.count;
            if (newSize > n) {
                this.grow(newSize);
            } else {
                Object[] items = this.array;
                if (this.array != null) {
                    for (int i2 = newSize; i2 < n; ++i2) {
                        items[i2] = null;
                    }
                }
            }
            this.count = newSize;
        }
        finally {
            lock2.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInto(Object[] anArray) {
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            Object[] items = this.array;
            if (this.array != null) {
                System.arraycopy(items, 0, anArray, 0, this.count);
            }
        }
        finally {
            lock2.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        StampedLock lock2 = this.lock;
        long stamp = lock2.writeLock();
        try {
            Object[] items = this.array;
            int n = this.count;
            if (items != null && n < items.length) {
                this.array = Arrays.copyOf(items, n);
            }
        }
        finally {
            lock2.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int minCapacity) {
        if (minCapacity > 0) {
            StampedLock lock2 = this.lock;
            long stamp = lock2.writeLock();
            try {
                int cap;
                Object[] items = this.array;
                int n = cap = items == null ? 0 : items.length;
                if (minCapacity - cap > 0) {
                    this.grow(minCapacity);
                }
            }
            finally {
                lock2.unlockWrite(stamp);
            }
        }
    }

    public Enumeration<E> elements() {
        return new Itr(this, 0);
    }

    public int capacity() {
        return this.array.length;
    }

    public E elementAt(int index2) {
        return this.get(index2);
    }

    public void setElementAt(E obj, int index2) {
        this.set(index2, obj);
    }

    public void removeElementAt(int index2) {
        this.remove(index2);
    }

    public void insertElementAt(E obj, int index2) {
        this.add(index2, obj);
    }

    public void addElement(E obj) {
        this.add(obj);
    }

    public boolean removeElement(Object obj) {
        return this.remove(obj);
    }

    public void removeAllElements() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadMostlyVector<E> clone() {
        int n;
        Object[] a = null;
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            Object[] items = this.array;
            if (items == null) {
                n = 0;
            } else {
                n = this.count;
                int len = items.length;
                if (n > len) {
                    n = len;
                }
                a = Arrays.copyOf(items, n);
            }
        }
        finally {
            lock2.unlockRead(stamp);
        }
        return new ReadMostlyVector<E>(a, n, this.capacityIncrement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s2) throws IOException {
        StampedLock lock2 = this.lock;
        long stamp = lock2.readLock();
        try {
            s2.defaultWriteObject();
        }
        finally {
            lock2.unlockRead(stamp);
        }
    }

    static final class SubItr<E>
    implements ListIterator<E> {
        final ReadMostlyVectorSublist<E> sublist;
        final ReadMostlyVector<E> list;
        final StampedLock lock;
        Object[] items;
        long seq;
        int cursor;
        int origin;
        int fence;
        int lastRet;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SubItr(ReadMostlyVectorSublist<E> sublist, int index2) {
            StampedLock lock2 = sublist.list.lock;
            long stamp = lock2.readLock();
            try {
                this.sublist = sublist;
                this.list = sublist.list;
                this.lock = lock2;
                this.cursor = index2;
                this.origin = sublist.offset;
                this.fence = this.origin + sublist.size;
                this.lastRet = -1;
            }
            finally {
                this.seq = lock2.tryConvertToOptimisticRead(stamp);
            }
            if (index2 < 0 || this.cursor > this.fence) {
                throw new ArrayIndexOutOfBoundsException(index2);
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor - this.origin;
        }

        @Override
        public int previousIndex() {
            return this.cursor - this.origin - 1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.fence;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > this.origin;
        }

        @Override
        public E next() {
            int i2 = this.cursor;
            Object[] es = this.items;
            if (es == null || i2 < this.origin || i2 >= this.fence || i2 >= es.length) {
                throw new NoSuchElementException();
            }
            Object e = es[i2];
            this.lastRet = i2;
            this.cursor = i2 + 1;
            if (!this.lock.validate(this.seq)) {
                throw new ConcurrentModificationException();
            }
            return (E)e;
        }

        @Override
        public E previous() {
            int i2 = this.cursor - 1;
            Object[] es = this.items;
            if (es == null || i2 < 0 || i2 >= this.fence || i2 >= es.length) {
                throw new NoSuchElementException();
            }
            Object e = es[i2];
            this.lastRet = i2;
            this.cursor = i2;
            if (!this.lock.validate(this.seq)) {
                throw new ConcurrentModificationException();
            }
            return (E)e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            int i2 = this.lastRet;
            if (i2 < 0) {
                throw new IllegalStateException();
            }
            this.seq = this.lock.tryConvertToWriteLock(this.seq);
            if (this.seq == 0L) {
                throw new ConcurrentModificationException();
            }
            try {
                this.list.rawRemoveAt(i2);
                this.fence = this.origin + this.sublist.size;
                this.cursor = i2;
                this.lastRet = -1;
            }
            finally {
                this.seq = this.lock.tryConvertToOptimisticRead(this.seq);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(E e) {
            int i2 = this.lastRet;
            if (i2 < this.origin || i2 >= this.fence) {
                throw new IllegalStateException();
            }
            this.seq = this.lock.tryConvertToWriteLock(this.seq);
            if (this.seq == 0L) {
                throw new ConcurrentModificationException();
            }
            try {
                this.list.set(i2, e);
            }
            finally {
                this.seq = this.lock.tryConvertToOptimisticRead(this.seq);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(E e) {
            int i2 = this.cursor;
            if (i2 < this.origin || i2 >= this.fence) {
                throw new IllegalStateException();
            }
            this.seq = this.lock.tryConvertToWriteLock(this.seq);
            if (this.seq == 0L) {
                throw new ConcurrentModificationException();
            }
            try {
                this.list.rawAddAt(i2, e);
                this.items = this.list.array;
                this.fence = this.origin + this.sublist.size;
                this.cursor = i2 + 1;
                this.lastRet = -1;
            }
            finally {
                this.seq = this.lock.tryConvertToOptimisticRead(this.seq);
            }
        }
    }

    static final class ReadMostlyVectorSublist<E>
    implements List<E>,
    RandomAccess,
    Serializable {
        private static final long serialVersionUID = 3041673470172026059L;
        final ReadMostlyVector<E> list;
        final int offset;
        volatile int size;

        ReadMostlyVectorSublist(ReadMostlyVector<E> list2, int offset2, int size2) {
            this.list = list2;
            this.offset = offset2;
            this.size = size2;
        }

        private void rangeCheck(int index2) {
            if (index2 < 0 || index2 >= this.size) {
                throw new ArrayIndexOutOfBoundsException(index2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E element) {
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.writeLock();
            try {
                int c = this.size;
                this.list.rawAddAt(c + this.offset, element);
                this.size = c + 1;
            }
            finally {
                lock2.unlockWrite(stamp);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index2, E element) {
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.writeLock();
            try {
                if (index2 < 0 || index2 > this.size) {
                    throw new ArrayIndexOutOfBoundsException(index2);
                }
                this.list.rawAddAt(index2 + this.offset, element);
                ++this.size;
            }
            finally {
                lock2.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            Object[] elements = c.toArray();
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.writeLock();
            try {
                int s2 = this.size;
                int pc = this.list.count;
                this.list.rawAddAllAt(this.offset + s2, elements);
                int added = this.list.count - pc;
                this.size = s2 + added;
                boolean bl = added != 0;
                return bl;
            }
            finally {
                lock2.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index2, Collection<? extends E> c) {
            Object[] elements = c.toArray();
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.writeLock();
            try {
                int s2 = this.size;
                if (index2 < 0 || index2 > s2) {
                    throw new ArrayIndexOutOfBoundsException(index2);
                }
                int pc = this.list.count;
                this.list.rawAddAllAt(index2 + this.offset, elements);
                int added = this.list.count - pc;
                this.size = s2 + added;
                boolean bl = added != 0;
                return bl;
            }
            finally {
                lock2.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.writeLock();
            try {
                this.list.internalClear(this.offset, this.offset + this.size);
                this.size = 0;
            }
            finally {
                lock2.unlockWrite(stamp);
            }
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.readLock();
            try {
                boolean bl = this.list.internalContainsAll(c, this.offset, this.offset + this.size);
                return bl;
            }
            finally {
                lock2.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.readLock();
            try {
                boolean bl = this.list.internalEquals((List)o, this.offset, this.offset + this.size);
                return bl;
            }
            finally {
                lock2.unlockRead(stamp);
            }
        }

        @Override
        public E get(int index2) {
            if (index2 < 0 || index2 >= this.size) {
                throw new ArrayIndexOutOfBoundsException(index2);
            }
            return this.list.get(index2 + this.offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.readLock();
            try {
                int n = this.list.internalHashCode(this.offset, this.offset + this.size);
                return n;
            }
            finally {
                lock2.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object o) {
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.readLock();
            try {
                int idx = ReadMostlyVector.findFirstIndex(this.list.array, o, this.offset, this.offset + this.size);
                int n = idx < 0 ? -1 : idx - this.offset;
                return n;
            }
            finally {
                lock2.unlockRead(stamp);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator<E> iterator() {
            return new SubItr(this, this.offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object o) {
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.readLock();
            try {
                int idx = ReadMostlyVector.findLastIndex(this.list.array, o, this.offset + this.size - 1, this.offset);
                int n = idx < 0 ? -1 : idx - this.offset;
                return n;
            }
            finally {
                lock2.unlockRead(stamp);
            }
        }

        @Override
        public ListIterator<E> listIterator() {
            return new SubItr(this, this.offset);
        }

        @Override
        public ListIterator<E> listIterator(int index2) {
            return new SubItr(this, index2 + this.offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index2) {
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.writeLock();
            try {
                Object[] items = this.list.array;
                int i2 = index2 + this.offset;
                if (items == null || index2 < 0 || index2 >= this.size || i2 >= items.length) {
                    throw new ArrayIndexOutOfBoundsException(index2);
                }
                Object result2 = items[i2];
                this.list.rawRemoveAt(i2);
                --this.size;
                Object object = result2;
                return (E)object;
            }
            finally {
                lock2.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.writeLock();
            try {
                if (this.list.rawRemoveAt(ReadMostlyVector.findFirstIndex(this.list.array, o, this.offset, this.offset + this.size))) {
                    --this.size;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                lock2.unlockWrite(stamp);
            }
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.list.lockedRemoveAll(c, this.offset, this.offset + this.size);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.list.lockedRetainAll(c, this.offset, this.offset + this.size);
        }

        @Override
        public E set(int index2, E element) {
            if (index2 < 0 || index2 >= this.size) {
                throw new ArrayIndexOutOfBoundsException(index2);
            }
            return this.list.set(index2 + this.offset, element);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            int c = this.size;
            int ssize = toIndex - fromIndex;
            if (fromIndex < 0) {
                throw new ArrayIndexOutOfBoundsException(fromIndex);
            }
            if (toIndex > c || ssize < 0) {
                throw new ArrayIndexOutOfBoundsException(toIndex);
            }
            return new ReadMostlyVectorSublist<E>(this.list, this.offset + fromIndex, ssize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.readLock();
            try {
                Object[] objectArray = this.list.internalToArray(this.offset, this.offset + this.size);
                return objectArray;
            }
            finally {
                lock2.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.readLock();
            try {
                T[] TArray = this.list.internalToArray(a, this.offset, this.offset + this.size);
                return TArray;
            }
            finally {
                lock2.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StampedLock lock2 = this.list.lock;
            long stamp = lock2.readLock();
            try {
                String string2 = this.list.internalToString(this.offset, this.offset + this.size);
                return string2;
            }
            finally {
                lock2.unlockRead(stamp);
            }
        }
    }

    static final class Itr<E>
    implements ListIterator<E>,
    Enumeration<E> {
        final StampedLock lock;
        final ReadMostlyVector<E> list;
        Object[] items;
        long seq;
        int cursor;
        int fence;
        int lastRet;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr(ReadMostlyVector<E> list2, int index2) {
            StampedLock lock2 = list2.lock;
            long stamp = lock2.readLock();
            try {
                this.list = list2;
                this.lock = lock2;
                this.items = list2.array;
                this.fence = list2.count;
                this.cursor = index2;
                this.lastRet = -1;
            }
            finally {
                this.seq = lock2.tryConvertToOptimisticRead(stamp);
            }
            if (index2 < 0 || index2 > this.fence) {
                throw new ArrayIndexOutOfBoundsException(index2);
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.fence;
        }

        @Override
        public E next() {
            int i2 = this.cursor;
            Object[] es = this.items;
            if (es == null || i2 < 0 || i2 >= this.fence || i2 >= es.length) {
                throw new NoSuchElementException();
            }
            Object e = es[i2];
            this.lastRet = i2;
            this.cursor = i2 + 1;
            if (!this.lock.validate(this.seq)) {
                throw new ConcurrentModificationException();
            }
            return (E)e;
        }

        @Override
        public E previous() {
            int i2 = this.cursor - 1;
            Object[] es = this.items;
            if (es == null || i2 < 0 || i2 >= this.fence || i2 >= es.length) {
                throw new NoSuchElementException();
            }
            Object e = es[i2];
            this.lastRet = i2;
            this.cursor = i2;
            if (!this.lock.validate(this.seq)) {
                throw new ConcurrentModificationException();
            }
            return (E)e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            int i2 = this.lastRet;
            if (i2 < 0) {
                throw new IllegalStateException();
            }
            this.seq = this.lock.tryConvertToWriteLock(this.seq);
            if (this.seq == 0L) {
                throw new ConcurrentModificationException();
            }
            try {
                this.list.rawRemoveAt(i2);
                this.fence = this.list.count;
                this.cursor = i2;
                this.lastRet = -1;
            }
            finally {
                this.seq = this.lock.tryConvertToOptimisticRead(this.seq);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(E e) {
            int i2 = this.lastRet;
            Object[] es = this.items;
            if (es == null || i2 < 0 | i2 >= this.fence) {
                throw new IllegalStateException();
            }
            this.seq = this.lock.tryConvertToWriteLock(this.seq);
            if (this.seq == 0L) {
                throw new ConcurrentModificationException();
            }
            try {
                es[i2] = e;
            }
            finally {
                this.seq = this.lock.tryConvertToOptimisticRead(this.seq);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(E e) {
            int i2 = this.cursor;
            if (i2 < 0) {
                throw new IllegalStateException();
            }
            this.seq = this.lock.tryConvertToWriteLock(this.seq);
            if (this.seq == 0L) {
                throw new ConcurrentModificationException();
            }
            try {
                this.list.rawAddAt(i2, e);
                this.items = this.list.array;
                this.fence = this.list.count;
                this.cursor = i2 + 1;
                this.lastRet = -1;
            }
            finally {
                this.seq = this.lock.tryConvertToOptimisticRead(this.seq);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public E nextElement() {
            return this.next();
        }
    }

    public static interface Action<A> {
        public void apply(A var1);
    }

    static final class SnapshotIterator<E>
    implements Iterator<E> {
        private final Object[] items;
        private int cursor;

        SnapshotIterator(ReadMostlyVector<E> v) {
            this.items = v.toArray();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.items.length;
        }

        @Override
        public E next() {
            if (this.cursor < this.items.length) {
                return (E)this.items[this.cursor++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

