/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166e.extra;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = -2308431214976778248L;
    private final transient long[] array;
    private static final Unsafe unsafe = AtomicDoubleArray.getUnsafe();
    private static final long arrayOffset;
    private static final int base;
    private static final int shift;

    private long checkedByteOffset(int i2) {
        if (i2 < 0 || i2 >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + i2);
        }
        return AtomicDoubleArray.byteOffset(i2);
    }

    private static long byteOffset(int i2) {
        return ((long)i2 << shift) + (long)base;
    }

    public AtomicDoubleArray(int length2) {
        this.array = new long[length2];
    }

    public AtomicDoubleArray(double[] array) {
        int len = array.length;
        long[] a = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            a[i2] = Double.doubleToRawLongBits(array[i2]);
        }
        this.array = a;
    }

    public final int length() {
        return this.array.length;
    }

    public final double get(int i2) {
        return Double.longBitsToDouble(this.getRaw(this.checkedByteOffset(i2)));
    }

    private long getRaw(long offset2) {
        return unsafe.getLongVolatile(this.array, offset2);
    }

    public final void set(int i2, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        unsafe.putLongVolatile(this.array, this.checkedByteOffset(i2), next);
    }

    public final void lazySet(int i2, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        unsafe.putOrderedLong(this.array, this.checkedByteOffset(i2), next);
    }

    public final double getAndSet(int i2, double newValue) {
        long current2;
        long next = Double.doubleToRawLongBits(newValue);
        long offset2 = this.checkedByteOffset(i2);
        while (!this.compareAndSetRaw(offset2, current2 = this.getRaw(offset2), next)) {
        }
        return Double.longBitsToDouble(current2);
    }

    public final boolean compareAndSet(int i2, double expect, double update2) {
        return this.compareAndSetRaw(this.checkedByteOffset(i2), Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update2));
    }

    private boolean compareAndSetRaw(long offset2, long expect, long update2) {
        return unsafe.compareAndSwapLong(this.array, offset2, expect, update2);
    }

    public final boolean weakCompareAndSet(int i2, double expect, double update2) {
        return this.compareAndSet(i2, expect, update2);
    }

    public final double getAndAdd(int i2, double delta) {
        double currentVal;
        double nextVal;
        long next;
        long current2;
        long offset2 = this.checkedByteOffset(i2);
        while (!this.compareAndSetRaw(offset2, current2 = this.getRaw(offset2), next = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current2)) + delta))) {
        }
        return currentVal;
    }

    public double addAndGet(int i2, double delta) {
        double currentVal;
        double nextVal;
        long next;
        long current2;
        long offset2 = this.checkedByteOffset(i2);
        while (!this.compareAndSetRaw(offset2, current2 = this.getRaw(offset2), next = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current2)) + delta))) {
        }
        return nextVal;
    }

    public String toString() {
        int iMax = this.array.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder(19 * (iMax + 1));
        b.append('[');
        int i2 = 0;
        while (true) {
            b.append(Double.longBitsToDouble(this.getRaw(AtomicDoubleArray.byteOffset(i2))));
            if (i2 == iMax) {
                return b.append(']').toString();
            }
            b.append(',').append(' ');
            ++i2;
        }
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        int length2 = this.length();
        s2.writeInt(length2);
        for (int i2 = 0; i2 < length2; ++i2) {
            s2.writeDouble(this.get(i2));
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int length2 = s2.readInt();
        unsafe.putObjectVolatile(this, arrayOffset, new long[length2]);
        for (int i2 = 0; i2 < length2; ++i2) {
            this.set(i2, s2.readDouble());
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException tryReflectionInstead) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static {
        base = unsafe.arrayBaseOffset(long[].class);
        try {
            Class<AtomicDoubleArray> k = AtomicDoubleArray.class;
            arrayOffset = unsafe.objectFieldOffset(k.getDeclaredField("array"));
            int scale = unsafe.arrayIndexScale(long[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            shift = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

