/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166e;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.elasticsearch.common.util.concurrent.jsr166e.Striped64;

public class LongMaxUpdater
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;

    @Override
    final long fn(long v, long x) {
        return v > x ? v : x;
    }

    public LongMaxUpdater() {
        this.base = Long.MIN_VALUE;
    }

    public void update(long x) {
        long b;
        Striped64.Cell[] as = this.cells;
        if (this.cells != null || (b = this.base) < x && !this.casBase(b, x)) {
            long v;
            Striped64.Cell a;
            int n;
            boolean uncontended = true;
            Striped64.HashCode hc = (Striped64.HashCode)threadHashCode.get();
            int h = hc.code;
            if (as == null || (n = as.length) < 1 || (a = as[n - 1 & h]) == null || (v = a.value) < x && !(uncontended = a.cas(v, x))) {
                this.retryUpdate(x, hc, uncontended);
            }
        }
    }

    public long max() {
        Striped64.Cell[] as = this.cells;
        long max2 = this.base;
        if (as != null) {
            for (Striped64.Cell a : as) {
                long v;
                if (a == null || (v = a.value) <= max2) continue;
                max2 = v;
            }
        }
        return max2;
    }

    public void reset() {
        this.internalReset(Long.MIN_VALUE);
    }

    public long maxThenReset() {
        Striped64.Cell[] as = this.cells;
        long max2 = this.base;
        this.base = Long.MIN_VALUE;
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                long v = a.value;
                a.value = Long.MIN_VALUE;
                if (v <= max2) continue;
                max2 = v;
            }
        }
        return max2;
    }

    public String toString() {
        return Long.toString(this.max());
    }

    @Override
    public long longValue() {
        return this.max();
    }

    @Override
    public int intValue() {
        return (int)this.max();
    }

    @Override
    public float floatValue() {
        return this.max();
    }

    @Override
    public double doubleValue() {
        return this.max();
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeLong(this.max());
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.busy = 0;
        this.cells = null;
        this.base = s2.readLong();
    }
}

