/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166e;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.elasticsearch.common.util.concurrent.jsr166e.Striped64;

public class DoubleMaxUpdater
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;
    private static final long MIN_AS_LONG = -4503599627370496L;

    @Override
    final long fn(long v, long x) {
        return Double.longBitsToDouble(v) > Double.longBitsToDouble(x) ? v : x;
    }

    public DoubleMaxUpdater() {
        this.base = -4503599627370496L;
    }

    public void update(double x) {
        block3: {
            Striped64.HashCode hc;
            boolean uncontended;
            long lx;
            block4: {
                long l;
                Striped64.Cell a;
                int n;
                Striped64.Cell[] as;
                block2: {
                    long l2;
                    lx = Double.doubleToRawLongBits(x);
                    as = this.cells;
                    if (this.cells != null) break block2;
                    long b = this.base;
                    if (!(Double.longBitsToDouble(l2) < x) || this.casBase(b, lx)) break block3;
                }
                uncontended = true;
                hc = (Striped64.HashCode)threadHashCode.get();
                int h = hc.code;
                if (as == null || (n = as.length) < 1 || (a = as[n - 1 & h]) == null) break block4;
                long v = a.value;
                if (!(Double.longBitsToDouble(l) < x) || (uncontended = a.cas(v, lx))) break block3;
            }
            this.retryUpdate(lx, hc, uncontended);
        }
    }

    public double max() {
        Striped64.Cell[] as = this.cells;
        double max2 = Double.longBitsToDouble(this.base);
        if (as != null) {
            for (Striped64.Cell a : as) {
                double d;
                if (a == null) continue;
                double v = Double.longBitsToDouble(a.value);
                if (!(d > max2)) continue;
                max2 = v;
            }
        }
        return max2;
    }

    public void reset() {
        this.internalReset(-4503599627370496L);
    }

    public double maxThenReset() {
        Striped64.Cell[] as = this.cells;
        double max2 = Double.longBitsToDouble(this.base);
        this.base = -4503599627370496L;
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                double v = Double.longBitsToDouble(a.value);
                a.value = -4503599627370496L;
                if (!(v > max2)) continue;
                max2 = v;
            }
        }
        return max2;
    }

    public String toString() {
        return Double.toString(this.max());
    }

    @Override
    public double doubleValue() {
        return this.max();
    }

    @Override
    public long longValue() {
        return (long)this.max();
    }

    @Override
    public int intValue() {
        return (int)this.max();
    }

    @Override
    public float floatValue() {
        return (float)this.max();
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeDouble(this.max());
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.busy = 0;
        this.cells = null;
        this.base = Double.doubleToRawLongBits(s2.readDouble());
    }
}

