/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.trove.list.array;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Random;
import org.elasticsearch.common.trove.TByteCollection;
import org.elasticsearch.common.trove.function.TByteFunction;
import org.elasticsearch.common.trove.impl.HashFunctions;
import org.elasticsearch.common.trove.iterator.TByteIterator;
import org.elasticsearch.common.trove.list.TByteList;
import org.elasticsearch.common.trove.procedure.TByteProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TByteArrayList
implements TByteList,
Externalizable {
    static final long serialVersionUID = 1L;
    protected byte[] _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;
    protected byte no_entry_value;

    public TByteArrayList() {
        this(10, 0);
    }

    public TByteArrayList(int capacity) {
        this(capacity, 0);
    }

    public TByteArrayList(int capacity, byte no_entry_value) {
        this._data = new byte[capacity];
        this._pos = 0;
        this.no_entry_value = no_entry_value;
    }

    public TByteArrayList(TByteCollection collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public TByteArrayList(byte[] values2) {
        this(values2.length);
        this.add(values2);
    }

    protected TByteArrayList(byte[] values2, byte no_entry_value, boolean wrap2) {
        if (!wrap2) {
            throw new IllegalStateException("Wrong call");
        }
        if (values2 == null) {
            throw new IllegalArgumentException("values can not be null");
        }
        this._data = values2;
        this._pos = values2.length;
        this.no_entry_value = no_entry_value;
    }

    public static TByteArrayList wrap(byte[] values2) {
        return TByteArrayList.wrap(values2, (byte)0);
    }

    public static TByteArrayList wrap(byte[] values2, byte no_entry_value) {
        return new TByteArrayList(values2, no_entry_value, true){

            public void ensureCapacity(int capacity) {
                if (capacity > this._data.length) {
                    throw new IllegalStateException("Can not grow ArrayList wrapped external array");
                }
            }
        };
    }

    @Override
    public byte getNoEntryValue() {
        return this.no_entry_value;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            byte[] tmp = new byte[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    @Override
    public int size() {
        return this._pos;
    }

    @Override
    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            byte[] tmp = new byte[this.size()];
            this.toArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    @Override
    public boolean add(byte val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
        return true;
    }

    @Override
    public void add(byte[] vals) {
        this.add(vals, 0, vals.length);
    }

    @Override
    public void add(byte[] vals, int offset2, int length2) {
        this.ensureCapacity(this._pos + length2);
        System.arraycopy(vals, offset2, this._data, this._pos, length2);
        this._pos += length2;
    }

    @Override
    public void insert(int offset2, byte value2) {
        if (offset2 == this._pos) {
            this.add(value2);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset2, this._data, offset2 + 1, this._pos - offset2);
        this._data[offset2] = value2;
        ++this._pos;
    }

    @Override
    public void insert(int offset2, byte[] values2) {
        this.insert(offset2, values2, 0, values2.length);
    }

    @Override
    public void insert(int offset2, byte[] values2, int valOffset, int len) {
        if (offset2 == this._pos) {
            this.add(values2, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset2, this._data, offset2 + len, this._pos - offset2);
        System.arraycopy(values2, valOffset, this._data, offset2, len);
        this._pos += len;
    }

    @Override
    public byte get(int offset2) {
        if (offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        return this._data[offset2];
    }

    public byte getQuick(int offset2) {
        return this._data[offset2];
    }

    @Override
    public byte set(int offset2, byte val) {
        if (offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        byte prev_val = this._data[offset2];
        this._data[offset2] = val;
        return prev_val;
    }

    @Override
    public byte replace(int offset2, byte val) {
        if (offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        byte old = this._data[offset2];
        this._data[offset2] = val;
        return old;
    }

    @Override
    public void set(int offset2, byte[] values2) {
        this.set(offset2, values2, 0, values2.length);
    }

    @Override
    public void set(int offset2, byte[] values2, int valOffset, int length2) {
        if (offset2 < 0 || offset2 + length2 > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(values2, valOffset, this._data, offset2, length2);
    }

    public void setQuick(int offset2, byte val) {
        this._data[offset2] = val;
    }

    @Override
    public void clear() {
        this.clear(10);
    }

    public void clear(int capacity) {
        this._data = new byte[capacity];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        Arrays.fill(this._data, this.no_entry_value);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    @Override
    public boolean remove(byte value2) {
        for (int index2 = 0; index2 < this._pos; ++index2) {
            if (value2 != this._data[index2]) continue;
            this.remove(index2, 1);
            return true;
        }
        return false;
    }

    @Override
    public byte removeAt(int offset2) {
        byte old = this.get(offset2);
        this.remove(offset2, 1);
        return old;
    }

    @Override
    public void remove(int offset2, int length2) {
        if (length2 == 0) {
            return;
        }
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        if (offset2 == 0) {
            System.arraycopy(this._data, length2, this._data, 0, this._pos - length2);
        } else if (this._pos - length2 != offset2) {
            System.arraycopy(this._data, offset2 + length2, this._data, offset2, this._pos - (offset2 + length2));
        }
        this._pos -= length2;
    }

    @Override
    public TByteIterator iterator() {
        return new TByteArrayIterator(0);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (element instanceof Byte) {
                byte c = (Byte)element;
                if (this.contains(c)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(TByteCollection collection) {
        if (this == collection) {
            return true;
        }
        TByteIterator iter = collection.iterator();
        while (iter.hasNext()) {
            byte element = iter.next();
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(byte[] array) {
        int i2 = array.length;
        while (i2-- > 0) {
            if (this.contains(array[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Byte> collection) {
        boolean changed = false;
        for (Byte by : collection) {
            byte e = by;
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(TByteCollection collection) {
        boolean changed = false;
        TByteIterator iter = collection.iterator();
        while (iter.hasNext()) {
            byte element = iter.next();
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(byte[] array) {
        boolean changed = false;
        for (byte element : array) {
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        TByteIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (collection.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(TByteCollection collection) {
        if (this == collection) {
            return false;
        }
        boolean modified = false;
        TByteIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (collection.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(byte[] array) {
        boolean changed = false;
        Arrays.sort(array);
        byte[] data2 = this._data;
        int i2 = this._pos;
        while (i2-- > 0) {
            if (Arrays.binarySearch(array, data2[i2]) >= 0) continue;
            this.remove(i2, 1);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object element : collection) {
            byte c;
            if (!(element instanceof Byte) || !this.remove(c = ((Byte)element).byteValue())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(TByteCollection collection) {
        if (collection == this) {
            this.clear();
            return true;
        }
        boolean changed = false;
        TByteIterator iter = collection.iterator();
        while (iter.hasNext()) {
            byte element = iter.next();
            if (!this.remove(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(byte[] array) {
        boolean changed = false;
        int i2 = array.length;
        while (i2-- > 0) {
            if (!this.remove(array[i2])) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void transformValues(TByteFunction function) {
        int i2 = this._pos;
        while (i2-- > 0) {
            this._data[i2] = function.execute(this._data[i2]);
        }
    }

    @Override
    public void reverse() {
        this.reverse(0, this._pos);
    }

    @Override
    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i2 = from;
        for (int j = to - 1; i2 < j; ++i2, --j) {
            this.swap(i2, j);
        }
    }

    @Override
    public void shuffle(Random rand2) {
        int i2 = this._pos;
        while (i2-- > 1) {
            this.swap(i2, rand2.nextInt(i2));
        }
    }

    private void swap(int i2, int j) {
        byte tmp = this._data[i2];
        this._data[i2] = this._data[j];
        this._data[j] = tmp;
    }

    @Override
    public TByteList subList(int begin2, int end2) {
        if (end2 < begin2) {
            throw new IllegalArgumentException("end index " + end2 + " greater than begin index " + begin2);
        }
        if (begin2 < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (end2 > this._data.length) {
            throw new IndexOutOfBoundsException("end index < " + this._data.length);
        }
        TByteArrayList list2 = new TByteArrayList(end2 - begin2);
        for (int i2 = begin2; i2 < end2; ++i2) {
            list2.add(this._data[i2]);
        }
        return list2;
    }

    @Override
    public byte[] toArray() {
        return this.toArray(0, this._pos);
    }

    @Override
    public byte[] toArray(int offset2, int len) {
        byte[] rv = new byte[len];
        this.toArray(rv, offset2, len);
        return rv;
    }

    @Override
    public byte[] toArray(byte[] dest) {
        int len = dest.length;
        if (dest.length > this._pos) {
            len = this._pos;
            dest[len] = this.no_entry_value;
        }
        this.toArray(dest, 0, len);
        return dest;
    }

    @Override
    public byte[] toArray(byte[] dest, int offset2, int len) {
        if (len == 0) {
            return dest;
        }
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(this._data, offset2, dest, 0, len);
        return dest;
    }

    @Override
    public byte[] toArray(byte[] dest, int source_pos, int dest_pos, int len) {
        if (len == 0) {
            return dest;
        }
        if (source_pos < 0 || source_pos >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(source_pos);
        }
        System.arraycopy(this._data, source_pos, dest, dest_pos, len);
        return dest;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TByteArrayList) {
            TByteArrayList that = (TByteArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i2 = this._pos;
            while (i2-- > 0) {
                if (this._data[i2] == that._data[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i2 = this._pos;
        while (i2-- > 0) {
            h += HashFunctions.hash(this._data[i2]);
        }
        return h;
    }

    @Override
    public boolean forEach(TByteProcedure procedure) {
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (procedure.execute(this._data[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachDescending(TByteProcedure procedure) {
        int i2 = this._pos;
        while (i2-- > 0) {
            if (procedure.execute(this._data[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    @Override
    public void sort(int fromIndex, int toIndex) {
        Arrays.sort(this._data, fromIndex, toIndex);
    }

    @Override
    public void fill(byte val) {
        Arrays.fill(this._data, 0, this._pos, val);
    }

    @Override
    public void fill(int fromIndex, int toIndex, byte val) {
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        Arrays.fill(this._data, fromIndex, toIndex, val);
    }

    @Override
    public int binarySearch(byte value2) {
        return this.binarySearch(value2, 0, this._pos);
    }

    @Override
    public int binarySearch(byte value2, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte midVal = this._data[mid];
            if (midVal < value2) {
                low = mid + 1;
                continue;
            }
            if (midVal > value2) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public int indexOf(byte value2) {
        return this.indexOf(0, value2);
    }

    @Override
    public int indexOf(int offset2, byte value2) {
        for (int i2 = offset2; i2 < this._pos; ++i2) {
            if (this._data[i2] != value2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte value2) {
        return this.lastIndexOf(this._pos, value2);
    }

    @Override
    public int lastIndexOf(int offset2, byte value2) {
        int i2 = offset2;
        while (i2-- > 0) {
            if (this._data[i2] != value2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean contains(byte value2) {
        return this.lastIndexOf(value2) >= 0;
    }

    @Override
    public TByteList grep(TByteProcedure condition) {
        TByteArrayList list2 = new TByteArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (!condition.execute(this._data[i2])) continue;
            list2.add(this._data[i2]);
        }
        return list2;
    }

    @Override
    public TByteList inverseGrep(TByteProcedure condition) {
        TByteArrayList list2 = new TByteArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (condition.execute(this._data[i2])) continue;
            list2.add(this._data[i2]);
        }
        return list2;
    }

    @Override
    public byte max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        byte max2 = -128;
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (this._data[i2] <= max2) continue;
            max2 = this._data[i2];
        }
        return max2;
    }

    @Override
    public byte min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        byte min2 = 127;
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (this._data[i2] >= min2) continue;
            min2 = this._data[i2];
        }
        return min2;
    }

    @Override
    public byte sum() {
        byte sum2 = 0;
        for (int i2 = 0; i2 < this._pos; ++i2) {
            sum2 = (byte)(sum2 + this._data[i2]);
        }
        return sum2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("{");
        int end2 = this._pos - 1;
        for (int i2 = 0; i2 < end2; ++i2) {
            buf.append(this._data[i2]);
            buf.append(", ");
        }
        if (this.size() > 0) {
            buf.append(this._data[this._pos - 1]);
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._pos);
        out.writeByte(this.no_entry_value);
        int len = this._data.length;
        out.writeInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            out.writeByte(this._data[i2]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._pos = in.readInt();
        this.no_entry_value = in.readByte();
        int len = in.readInt();
        this._data = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            this._data[i2] = in.readByte();
        }
    }

    class TByteArrayIterator
    implements TByteIterator {
        private int cursor = 0;
        int lastRet = -1;

        TByteArrayIterator(int index2) {
            this.cursor = index2;
        }

        public boolean hasNext() {
            return this.cursor < TByteArrayList.this.size();
        }

        public byte next() {
            try {
                byte next = TByteArrayList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                TByteArrayList.this.remove(this.lastRet, 1);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

