/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.trove.impl.hash;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.elasticsearch.common.trove.impl.HashFunctions;
import org.elasticsearch.common.trove.impl.hash.TPrimitiveHash;
import org.elasticsearch.common.trove.procedure.TLongProcedure;

public abstract class TLongLongHash
extends TPrimitiveHash {
    static final long serialVersionUID = 1L;
    public transient long[] _set;
    protected long no_entry_key;
    protected long no_entry_value;
    protected boolean consumeFreeSlot;

    public TLongLongHash() {
        this.no_entry_key = 0L;
        this.no_entry_value = 0L;
    }

    public TLongLongHash(int initialCapacity) {
        super(initialCapacity);
        this.no_entry_key = 0L;
        this.no_entry_value = 0L;
    }

    public TLongLongHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.no_entry_key = 0L;
        this.no_entry_value = 0L;
    }

    public TLongLongHash(int initialCapacity, float loadFactor, long no_entry_key, long no_entry_value) {
        super(initialCapacity, loadFactor);
        this.no_entry_key = no_entry_key;
        this.no_entry_value = no_entry_value;
    }

    public long getNoEntryKey() {
        return this.no_entry_key;
    }

    public long getNoEntryValue() {
        return this.no_entry_value;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new long[capacity];
        return capacity;
    }

    public boolean contains(long val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TLongProcedure procedure) {
        byte[] states = this._states;
        long[] set = this._set;
        int i2 = set.length;
        while (i2-- > 0) {
            if (states[i2] != 1 || procedure.execute(set[i2])) continue;
            return false;
        }
        return true;
    }

    protected void removeAt(int index2) {
        this._set[index2] = this.no_entry_key;
        super.removeAt(index2);
    }

    protected int index(long key2) {
        byte[] states = this._states;
        long[] set = this._set;
        int length2 = states.length;
        int hash2 = HashFunctions.hash(key2) & Integer.MAX_VALUE;
        int index2 = hash2 % length2;
        byte state2 = states[index2];
        if (state2 == 0) {
            return -1;
        }
        if (state2 == 1 && set[index2] == key2) {
            return index2;
        }
        return this.indexRehashed(key2, index2, hash2, state2);
    }

    int indexRehashed(long key2, int index2, int hash2, byte state2) {
        int length2 = this._set.length;
        int probe = 1 + hash2 % (length2 - 2);
        int loopIndex = index2;
        do {
            if ((index2 -= probe) < 0) {
                index2 += length2;
            }
            if ((state2 = this._states[index2]) == 0) {
                return -1;
            }
            if (key2 != this._set[index2] || state2 == 2) continue;
            return index2;
        } while (index2 != loopIndex);
        return -1;
    }

    protected int insertKey(long val) {
        int hash2 = HashFunctions.hash(val) & Integer.MAX_VALUE;
        int index2 = hash2 % this._states.length;
        byte state2 = this._states[index2];
        this.consumeFreeSlot = false;
        if (state2 == 0) {
            this.consumeFreeSlot = true;
            this.insertKeyAt(index2, val);
            return index2;
        }
        if (state2 == 1 && this._set[index2] == val) {
            return -index2 - 1;
        }
        return this.insertKeyRehash(val, index2, hash2, state2);
    }

    int insertKeyRehash(long val, int index2, int hash2, byte state2) {
        int length2 = this._set.length;
        int probe = 1 + hash2 % (length2 - 2);
        int loopIndex = index2;
        int firstRemoved = -1;
        do {
            if (state2 == 2 && firstRemoved == -1) {
                firstRemoved = index2;
            }
            if ((index2 -= probe) < 0) {
                index2 += length2;
            }
            if ((state2 = this._states[index2]) == 0) {
                if (firstRemoved != -1) {
                    this.insertKeyAt(firstRemoved, val);
                    return firstRemoved;
                }
                this.consumeFreeSlot = true;
                this.insertKeyAt(index2, val);
                return index2;
            }
            if (state2 != 1 || this._set[index2] != val) continue;
            return -index2 - 1;
        } while (index2 != loopIndex);
        if (firstRemoved != -1) {
            this.insertKeyAt(firstRemoved, val);
            return firstRemoved;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    void insertKeyAt(int index2, long val) {
        this._set[index2] = val;
        this._states[index2] = 1;
    }

    protected int XinsertKey(long key2) {
        byte[] states = this._states;
        long[] set = this._set;
        int length2 = states.length;
        int hash2 = HashFunctions.hash(key2) & Integer.MAX_VALUE;
        int index2 = hash2 % length2;
        byte state2 = states[index2];
        this.consumeFreeSlot = false;
        if (state2 == 0) {
            this.consumeFreeSlot = true;
            set[index2] = key2;
            states[index2] = 1;
            return index2;
        }
        if (state2 == 1 && set[index2] == key2) {
            return -index2 - 1;
        }
        int probe = 1 + hash2 % (length2 - 2);
        if (state2 != 2) {
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length2;
            } while ((state2 = states[index2]) == 1 && set[index2] != key2);
        }
        if (state2 == 2) {
            int firstRemoved = index2;
            while (state2 != 0 && (state2 == 2 || set[index2] != key2)) {
                if ((index2 -= probe) < 0) {
                    index2 += length2;
                }
                state2 = states[index2];
            }
            if (state2 == 1) {
                return -index2 - 1;
            }
            set[index2] = key2;
            states[index2] = 1;
            return firstRemoved;
        }
        if (state2 == 1) {
            return -index2 - 1;
        }
        this.consumeFreeSlot = true;
        set[index2] = key2;
        states[index2] = 1;
        return index2;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeLong(this.no_entry_key);
        out.writeLong(this.no_entry_value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        this.no_entry_key = in.readLong();
        this.no_entry_value = in.readLong();
    }
}

