/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import java.util.StringTokenizer;
import org.elasticsearch.common.trove.list.array.TIntArrayList;

public class PortsRange {
    private final String portRange;

    public PortsRange(String portRange) {
        this.portRange = portRange;
    }

    public int[] ports() throws NumberFormatException {
        final TIntArrayList ports = new TIntArrayList();
        this.iterate(new PortCallback(){

            @Override
            public boolean onPortNumber(int portNumber) {
                ports.add(portNumber);
                return false;
            }
        });
        return ports.toArray(new int[ports.size()]);
    }

    public boolean iterate(PortCallback callback) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(this.portRange, ",");
        boolean success2 = false;
        while (st.hasMoreTokens() && !success2) {
            String portToken = st.nextToken().trim();
            int index2 = portToken.indexOf(45);
            if (index2 == -1) {
                int portNumber = Integer.parseInt(portToken.trim());
                success2 = callback.onPortNumber(portNumber);
                if (!success2) continue;
                break;
            }
            int startPort = Integer.parseInt(portToken.substring(0, index2).trim());
            int endPort = Integer.parseInt(portToken.substring(index2 + 1).trim());
            if (endPort < startPort) {
                throw new IllegalArgumentException("Start port [" + startPort + "] must be greater than end port [" + endPort + "]");
            }
            for (int i2 = startPort; i2 <= endPort && !(success2 = callback.onPortNumber(i2)); ++i2) {
            }
        }
        return success2;
    }

    public static interface PortCallback {
        public boolean onPortNumber(int var1);
    }
}

