/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.text;

import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.text.Text;

public class StringAndBytesText
implements Text {
    public static final Text[] EMPTY_ARRAY = new Text[0];
    private BytesReference bytes;
    private String text;

    public static Text[] convertFromStringArray(String[] strings) {
        if (strings.length == 0) {
            return EMPTY_ARRAY;
        }
        Text[] texts = new Text[strings.length];
        for (int i2 = 0; i2 < strings.length; ++i2) {
            texts[i2] = new StringAndBytesText(strings[i2]);
        }
        return texts;
    }

    public StringAndBytesText(BytesReference bytes2) {
        this.bytes = bytes2;
    }

    public StringAndBytesText(String text) {
        this.text = text;
    }

    @Override
    public boolean hasBytes() {
        return this.bytes != null;
    }

    @Override
    public BytesReference bytes() {
        if (this.bytes == null) {
            this.bytes = new BytesArray(this.text.getBytes(Charsets.UTF_8));
        }
        return this.bytes;
    }

    @Override
    public boolean hasString() {
        return this.text != null;
    }

    @Override
    public String string() {
        if (this.text == null) {
            if (!this.bytes.hasArray()) {
                this.bytes = this.bytes.toBytesArray();
            }
            this.text = new String(this.bytes.array(), this.bytes.arrayOffset(), this.bytes.length(), Charsets.UTF_8);
        }
        return this.text;
    }

    @Override
    public String toString() {
        return this.string();
    }
}

