/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings.loader;

import org.elasticsearch.common.settings.loader.JsonSettingsLoader;
import org.elasticsearch.common.settings.loader.PropertiesSettingsLoader;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.settings.loader.YamlSettingsLoader;

public final class SettingsLoaderFactory {
    private SettingsLoaderFactory() {
    }

    public static SettingsLoader loaderFromResource(String resourceName) {
        if (resourceName.endsWith(".json")) {
            return new JsonSettingsLoader();
        }
        if (resourceName.endsWith(".yml") || resourceName.endsWith(".yaml")) {
            return new YamlSettingsLoader();
        }
        if (resourceName.endsWith(".properties")) {
            return new PropertiesSettingsLoader();
        }
        return new JsonSettingsLoader();
    }

    public static SettingsLoader loaderFromSource(String source2) {
        if (source2.indexOf(123) != -1 && source2.indexOf(125) != -1) {
            return new JsonSettingsLoader();
        }
        if (source2.indexOf(58) != -1) {
            return new YamlSettingsLoader();
        }
        return new PropertiesSettingsLoader();
    }
}

