/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.util.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.InternalLoggerFactory;

public final class SystemPropertyUtil {
    private static boolean initializedLogger;
    private static final InternalLogger logger;
    private static boolean loggedException;
    private static final Pattern INTEGER_PATTERN;

    public static boolean contains(String key2) {
        return SystemPropertyUtil.get(key2) != null;
    }

    public static String get(String key2) {
        return SystemPropertyUtil.get(key2, null);
    }

    public static String get(String key2, String def) {
        String value2;
        block5: {
            if (key2 == null) {
                throw new NullPointerException("key");
            }
            if (key2.length() == 0) {
                throw new IllegalArgumentException("key must not be empty.");
            }
            value2 = null;
            try {
                value2 = System.getProperty(key2);
            }
            catch (Exception e) {
                if (loggedException) break block5;
                SystemPropertyUtil.log("Unable to retrieve a system property '" + key2 + "'; default values will be used.", e);
                loggedException = true;
            }
        }
        if (value2 == null) {
            return def;
        }
        return value2;
    }

    public static boolean getBoolean(String key2, boolean def) {
        String value2 = SystemPropertyUtil.get(key2);
        if (value2 == null) {
            return def;
        }
        if ((value2 = value2.trim().toLowerCase()).length() == 0) {
            return true;
        }
        if ("true".equals(value2) || "yes".equals(value2) || "1".equals(value2)) {
            return true;
        }
        if ("false".equals(value2) || "no".equals(value2) || "0".equals(value2)) {
            return false;
        }
        SystemPropertyUtil.log("Unable to parse the boolean system property '" + key2 + "':" + value2 + " - " + "using the default value: " + def);
        return def;
    }

    public static int getInt(String key2, int def) {
        String value2 = SystemPropertyUtil.get(key2);
        if (value2 == null) {
            return def;
        }
        if (INTEGER_PATTERN.matcher(value2 = value2.trim().toLowerCase()).matches()) {
            try {
                return Integer.parseInt(value2);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        SystemPropertyUtil.log("Unable to parse the integer system property '" + key2 + "':" + value2 + " - " + "using the default value: " + def);
        return def;
    }

    public static long getLong(String key2, long def) {
        String value2 = SystemPropertyUtil.get(key2);
        if (value2 == null) {
            return def;
        }
        if (INTEGER_PATTERN.matcher(value2 = value2.trim().toLowerCase()).matches()) {
            try {
                return Long.parseLong(value2);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        SystemPropertyUtil.log("Unable to parse the long integer system property '" + key2 + "':" + value2 + " - " + "using the default value: " + def);
        return def;
    }

    private static void log(String msg) {
        if (initializedLogger) {
            logger.warn(msg);
        } else {
            Logger.getLogger(SystemPropertyUtil.class.getName()).log(Level.WARNING, msg);
        }
    }

    private static void log(String msg, Exception e) {
        if (initializedLogger) {
            logger.warn(msg, e);
        } else {
            Logger.getLogger(SystemPropertyUtil.class.getName()).log(Level.WARNING, msg, e);
        }
    }

    private SystemPropertyUtil() {
    }

    static {
        logger = InternalLoggerFactory.getInstance(SystemPropertyUtil.class);
        initializedLogger = true;
        INTEGER_PATTERN = Pattern.compile("-?[0-9]+");
    }
}

