/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.replay;

import java.net.SocketAddress;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelStateEvent;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.handler.codec.frame.FrameDecoder;
import org.elasticsearch.common.netty.handler.codec.replay.ReplayError;
import org.elasticsearch.common.netty.handler.codec.replay.ReplayingDecoderBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReplayingDecoder<T extends Enum<T>>
extends FrameDecoder {
    private final ReplayingDecoderBuffer replayable = new ReplayingDecoderBuffer(this);
    private T state;
    private int checkpoint;
    private boolean needsCleanup;

    protected ReplayingDecoder() {
        this(null);
    }

    protected ReplayingDecoder(boolean unfold) {
        this(null, unfold);
    }

    protected ReplayingDecoder(T initialState) {
        this(initialState, false);
    }

    protected ReplayingDecoder(T initialState, boolean unfold) {
        super(unfold);
        this.state = initialState;
    }

    @Override
    protected ChannelBuffer internalBuffer() {
        return super.internalBuffer();
    }

    protected void checkpoint() {
        ChannelBuffer cumulation = this.cumulation;
        this.checkpoint = cumulation != null ? cumulation.readerIndex() : -1;
    }

    protected void checkpoint(T state2) {
        this.checkpoint();
        this.setState(state2);
    }

    protected T getState() {
        return this.state;
    }

    protected T setState(T newState) {
        T oldState = this.state;
        this.state = newState;
        return oldState;
    }

    protected abstract Object decode(ChannelHandlerContext var1, Channel var2, ChannelBuffer var3, T var4) throws Exception;

    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, T state2) throws Exception {
        return this.decode(ctx, channel, buffer, state2);
    }

    @Override
    protected final Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        return this.decode(ctx, channel, buffer, this.state);
    }

    @Override
    protected final Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        return this.decodeLast(ctx, channel, buffer, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object m = e.getMessage();
        if (!(m instanceof ChannelBuffer)) {
            ctx.sendUpstream(e);
            return;
        }
        ChannelBuffer input = (ChannelBuffer)m;
        if (!input.readable()) {
            return;
        }
        this.needsCleanup = true;
        if (this.cumulation == null) {
            this.cumulation = input;
            int oldReaderIndex = input.readerIndex();
            int inputSize = input.readableBytes();
            try {
                this.callDecode(ctx, e.getChannel(), input, this.replayable, e.getRemoteAddress());
                Object var8_7 = null;
                int readableBytes = input.readableBytes();
                if (readableBytes > 0) {
                    boolean copy;
                    int inputCapacity = input.capacity();
                    boolean bl = copy = readableBytes != inputCapacity && inputCapacity > this.getMaxCumulationBufferCapacity();
                    if (this.checkpoint > 0) {
                        int bytesToPreserve = inputSize - (this.checkpoint - oldReaderIndex);
                        if (copy) {
                            ChannelBuffer cumulation;
                            this.cumulation = cumulation = this.newCumulationBuffer(ctx, bytesToPreserve);
                            cumulation.writeBytes(input, this.checkpoint, bytesToPreserve);
                            return;
                        }
                        this.cumulation = input.slice(this.checkpoint, bytesToPreserve);
                        return;
                    }
                    if (this.checkpoint == 0) {
                        ChannelBuffer cumulation;
                        if (copy) {
                            ChannelBuffer cumulation2;
                            this.cumulation = cumulation2 = this.newCumulationBuffer(ctx, inputSize);
                            cumulation2.writeBytes(input, oldReaderIndex, inputSize);
                            cumulation2.readerIndex(input.readerIndex());
                            return;
                        }
                        this.cumulation = cumulation = input.slice(oldReaderIndex, inputSize);
                        cumulation.readerIndex(input.readerIndex());
                        return;
                    }
                    if (copy) {
                        ChannelBuffer cumulation;
                        this.cumulation = cumulation = this.newCumulationBuffer(ctx, input.readableBytes());
                        cumulation.writeBytes(input);
                        return;
                    }
                    this.cumulation = input;
                    return;
                }
                this.cumulation = null;
                return;
            }
            catch (Throwable throwable) {
                boolean copy;
                Object var8_8 = null;
                int readableBytes = input.readableBytes();
                if (readableBytes <= 0) {
                    this.cumulation = null;
                    throw throwable;
                }
                int inputCapacity = input.capacity();
                boolean bl = copy = readableBytes != inputCapacity && inputCapacity > this.getMaxCumulationBufferCapacity();
                if (this.checkpoint > 0) {
                    int bytesToPreserve = inputSize - (this.checkpoint - oldReaderIndex);
                    if (copy) {
                        ChannelBuffer cumulation;
                        this.cumulation = cumulation = this.newCumulationBuffer(ctx, bytesToPreserve);
                        cumulation.writeBytes(input, this.checkpoint, bytesToPreserve);
                        throw throwable;
                    }
                    this.cumulation = input.slice(this.checkpoint, bytesToPreserve);
                    throw throwable;
                }
                if (this.checkpoint == 0) {
                    ChannelBuffer cumulation;
                    if (copy) {
                        ChannelBuffer cumulation2;
                        this.cumulation = cumulation2 = this.newCumulationBuffer(ctx, inputSize);
                        cumulation2.writeBytes(input, oldReaderIndex, inputSize);
                        cumulation2.readerIndex(input.readerIndex());
                        throw throwable;
                    }
                    this.cumulation = cumulation = input.slice(oldReaderIndex, inputSize);
                    cumulation.readerIndex(input.readerIndex());
                    throw throwable;
                }
                if (copy) {
                    ChannelBuffer cumulation;
                    this.cumulation = cumulation = this.newCumulationBuffer(ctx, input.readableBytes());
                    cumulation.writeBytes(input);
                    throw throwable;
                }
                this.cumulation = input;
                throw throwable;
            }
        }
        input = this.appendToCumulation(input);
        try {
            this.callDecode(ctx, e.getChannel(), input, this.replayable, e.getRemoteAddress());
            Object var15_26 = null;
            this.updateCumulation(ctx, input);
            return;
        }
        catch (Throwable throwable) {
            Object var15_27 = null;
            this.updateCumulation(ctx, input);
            throw throwable;
        }
    }

    private void callDecode(ChannelHandlerContext context, Channel channel, ChannelBuffer input, ChannelBuffer replayableInput, SocketAddress remoteAddress) throws Exception {
        while (input.readable()) {
            T oldState;
            Object result2;
            int oldReaderIndex;
            block5: {
                oldReaderIndex = this.checkpoint = input.readerIndex();
                result2 = null;
                oldState = this.state;
                try {
                    result2 = this.decode(context, channel, replayableInput, this.state);
                    if (result2 == null) {
                        if (oldReaderIndex != input.readerIndex() || oldState != this.state) continue;
                        throw new IllegalStateException("null cannot be returned if no data is consumed and state didn't change.");
                    }
                }
                catch (ReplayError replay) {
                    int checkpoint = this.checkpoint;
                    if (checkpoint < 0) break block5;
                    input.readerIndex(checkpoint);
                }
            }
            if (result2 == null) break;
            if (oldReaderIndex == input.readerIndex() && oldState == this.state) {
                throw new IllegalStateException("decode() method must consume at least one byte if it returned a decoded message (caused by: " + this.getClass() + ')');
            }
            this.unfoldAndFireMessageReceived(context, remoteAddress, result2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void cleanup(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            try {
                ChannelBuffer cumulation = this.cumulation;
                if (!this.needsCleanup) {
                    Object var6_5 = null;
                    ctx.sendUpstream(e);
                    return;
                }
                this.needsCleanup = false;
                this.replayable.terminate();
                if (cumulation != null && cumulation.readable()) {
                    this.callDecode(ctx, e.getChannel(), cumulation, this.replayable, null);
                }
                Object partiallyDecoded = this.decodeLast(ctx, e.getChannel(), this.replayable, this.state);
                this.cumulation = null;
                if (partiallyDecoded != null) {
                    this.unfoldAndFireMessageReceived(ctx, null, partiallyDecoded);
                }
            }
            catch (ReplayError replayError) {
                Object var6_7 = null;
                ctx.sendUpstream(e);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            ctx.sendUpstream(e);
            throw throwable;
        }
        Object var6_6 = null;
        ctx.sendUpstream(e);
    }
}

