/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.socket.oio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.regex.Pattern;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.DefaultFileRegion;
import org.elasticsearch.common.netty.channel.FileRegion;
import org.elasticsearch.common.netty.channel.socket.oio.AbstractOioWorker;
import org.elasticsearch.common.netty.channel.socket.oio.OioAcceptedSocketChannel;
import org.elasticsearch.common.netty.channel.socket.oio.OioSocketChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OioWorker
extends AbstractOioWorker<OioSocketChannel> {
    private static final Pattern SOCKET_CLOSED_MESSAGE = Pattern.compile("^.*(?:Socket.*closed).*$", 2);

    OioWorker(OioSocketChannel channel) {
        super(channel);
    }

    @Override
    public void run() {
        boolean fireConnected = this.channel instanceof OioAcceptedSocketChannel;
        if (fireConnected && ((OioSocketChannel)this.channel).isOpen()) {
            Channels.fireChannelConnected(this.channel, (SocketAddress)((OioSocketChannel)this.channel).getRemoteAddress());
        }
        super.run();
    }

    @Override
    boolean process() throws IOException {
        PushbackInputStream in = ((OioSocketChannel)this.channel).getInputStream();
        int bytesToRead = in.available();
        if (bytesToRead <= 0) {
            int b = in.read();
            if (b < 0) {
                return false;
            }
            in.unread(b);
            return true;
        }
        byte[] buf = new byte[bytesToRead];
        int readBytes = in.read(buf);
        Channels.fireMessageReceived(this.channel, (Object)((OioSocketChannel)this.channel).getConfig().getBufferFactory().getBuffer(buf, 0, readBytes));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void write(OioSocketChannel channel, ChannelFuture future, Object message2) {
        boolean iothread = OioWorker.isIoThread(channel);
        OutputStream out = channel.getOutputStream();
        if (out == null) {
            ClosedChannelException e = new ClosedChannelException();
            future.setFailure(e);
            if (iothread) {
                Channels.fireExceptionCaught(channel, (Throwable)e);
            } else {
                Channels.fireExceptionCaughtLater(channel, (Throwable)e);
            }
            return;
        }
        try {
            int length2;
            block21: {
                length2 = 0;
                if (message2 instanceof FileRegion) {
                    FileRegion fr = (FileRegion)message2;
                    try {
                        OutputStream outputStream = out;
                        synchronized (outputStream) {
                            long i2;
                            WritableByteChannel bchannel = java.nio.channels.Channels.newChannel(out);
                            while ((i2 = fr.transferTo(bchannel, length2)) > 0L && (long)(length2 = (int)((long)length2 + i2)) < fr.getCount()) {
                            }
                            break block21;
                        }
                    }
                    finally {
                        DefaultFileRegion dfr;
                        if (fr instanceof DefaultFileRegion && (dfr = (DefaultFileRegion)fr).releaseAfterTransfer()) {
                            fr.releaseExternalResources();
                        }
                    }
                }
                ChannelBuffer a = (ChannelBuffer)message2;
                length2 = a.readableBytes();
                OutputStream outputStream = out;
                synchronized (outputStream) {
                    a.getBytes(a.readerIndex(), out, length2);
                }
            }
            future.setSuccess();
            if (iothread) {
                Channels.fireWriteComplete(channel, (long)length2);
            } else {
                Channels.fireWriteCompleteLater(channel, length2);
            }
        }
        catch (Throwable t2) {
            ClosedChannelException t2;
            if (t2 instanceof SocketException && SOCKET_CLOSED_MESSAGE.matcher(String.valueOf(t2.getMessage())).matches()) {
                t2 = new ClosedChannelException();
            }
            future.setFailure(t2);
            if (iothread) {
                Channels.fireExceptionCaught(channel, (Throwable)t2);
            }
            Channels.fireExceptionCaughtLater(channel, (Throwable)t2);
        }
    }
}

