/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.socket;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.elasticsearch.common.netty.channel.ChannelException;
import org.elasticsearch.common.netty.channel.DefaultChannelConfig;
import org.elasticsearch.common.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.ReceiveBufferSizePredictor;
import org.elasticsearch.common.netty.channel.ReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.socket.DatagramChannelConfig;
import org.elasticsearch.common.netty.util.internal.ConversionUtil;

public class DefaultDatagramChannelConfig
extends DefaultChannelConfig
implements DatagramChannelConfig {
    private static final ReceiveBufferSizePredictorFactory DEFAULT_PREDICTOR_FACTORY = new FixedReceiveBufferSizePredictorFactory(768);
    private final DatagramSocket socket;
    private volatile ReceiveBufferSizePredictor predictor;
    private volatile ReceiveBufferSizePredictorFactory predictorFactory = DEFAULT_PREDICTOR_FACTORY;

    public DefaultDatagramChannelConfig(DatagramSocket socket2) {
        if (socket2 == null) {
            throw new NullPointerException("socket");
        }
        this.socket = socket2;
    }

    public boolean setOption(String key2, Object value2) {
        if (super.setOption(key2, value2)) {
            return true;
        }
        if ("broadcast".equals(key2)) {
            this.setBroadcast(ConversionUtil.toBoolean(value2));
        } else if ("receiveBufferSize".equals(key2)) {
            this.setReceiveBufferSize(ConversionUtil.toInt(value2));
        } else if ("sendBufferSize".equals(key2)) {
            this.setSendBufferSize(ConversionUtil.toInt(value2));
        } else if ("receiveBufferSizePredictorFactory".equals(key2)) {
            this.setReceiveBufferSizePredictorFactory((ReceiveBufferSizePredictorFactory)value2);
        } else if ("receiveBufferSizePredictor".equals(key2)) {
            this.setReceiveBufferSizePredictor((ReceiveBufferSizePredictor)value2);
        } else if ("reuseAddress".equals(key2)) {
            this.setReuseAddress(ConversionUtil.toBoolean(value2));
        } else if ("loopbackModeDisabled".equals(key2)) {
            this.setLoopbackModeDisabled(ConversionUtil.toBoolean(value2));
        } else if ("interface".equals(key2)) {
            this.setInterface((InetAddress)value2);
        } else if ("networkInterface".equals(key2)) {
            this.setNetworkInterface((NetworkInterface)value2);
        } else if ("timeToLive".equals(key2)) {
            this.setTimeToLive(ConversionUtil.toInt(value2));
        } else if ("trafficClass".equals(key2)) {
            this.setTrafficClass(ConversionUtil.toInt(value2));
        } else {
            return false;
        }
        return true;
    }

    public boolean isBroadcast() {
        try {
            return this.socket.getBroadcast();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setBroadcast(boolean broadcast2) {
        try {
            this.socket.setBroadcast(broadcast2);
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public InetAddress getInterface() {
        if (this.socket instanceof MulticastSocket) {
            try {
                return ((MulticastSocket)this.socket).getInterface();
            }
            catch (SocketException e) {
                throw new ChannelException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setInterface(InetAddress interfaceAddress) {
        if (this.socket instanceof MulticastSocket) {
            try {
                ((MulticastSocket)this.socket).setInterface(interfaceAddress);
            }
            catch (SocketException e) {
                throw new ChannelException(e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public boolean isLoopbackModeDisabled() {
        if (this.socket instanceof MulticastSocket) {
            try {
                return ((MulticastSocket)this.socket).getLoopbackMode();
            }
            catch (SocketException e) {
                throw new ChannelException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setLoopbackModeDisabled(boolean loopbackModeDisabled) {
        if (this.socket instanceof MulticastSocket) {
            try {
                ((MulticastSocket)this.socket).setLoopbackMode(loopbackModeDisabled);
            }
            catch (SocketException e) {
                throw new ChannelException(e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public NetworkInterface getNetworkInterface() {
        if (this.socket instanceof MulticastSocket) {
            try {
                return ((MulticastSocket)this.socket).getNetworkInterface();
            }
            catch (SocketException e) {
                throw new ChannelException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setNetworkInterface(NetworkInterface networkInterface) {
        if (this.socket instanceof MulticastSocket) {
            try {
                ((MulticastSocket)this.socket).setNetworkInterface(networkInterface);
            }
            catch (SocketException e) {
                throw new ChannelException(e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public boolean isReuseAddress() {
        try {
            return this.socket.getReuseAddress();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setReuseAddress(boolean reuseAddress) {
        try {
            this.socket.setReuseAddress(reuseAddress);
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public int getReceiveBufferSize() {
        try {
            return this.socket.getReceiveBufferSize();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        try {
            this.socket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public int getSendBufferSize() {
        try {
            return this.socket.getSendBufferSize();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setSendBufferSize(int sendBufferSize) {
        try {
            this.socket.setSendBufferSize(sendBufferSize);
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public int getTimeToLive() {
        if (this.socket instanceof MulticastSocket) {
            try {
                return ((MulticastSocket)this.socket).getTimeToLive();
            }
            catch (IOException e) {
                throw new ChannelException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setTimeToLive(int ttl) {
        if (this.socket instanceof MulticastSocket) {
            try {
                ((MulticastSocket)this.socket).setTimeToLive(ttl);
            }
            catch (IOException e) {
                throw new ChannelException(e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public int getTrafficClass() {
        try {
            return this.socket.getTrafficClass();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setTrafficClass(int trafficClass) {
        try {
            this.socket.setTrafficClass(trafficClass);
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public ReceiveBufferSizePredictor getReceiveBufferSizePredictor() {
        ReceiveBufferSizePredictor predictor = this.predictor;
        if (predictor == null) {
            try {
                this.predictor = predictor = this.getReceiveBufferSizePredictorFactory().getPredictor();
            }
            catch (Exception e) {
                throw new ChannelException("Failed to create a new " + ReceiveBufferSizePredictor.class.getSimpleName() + '.', e);
            }
        }
        return predictor;
    }

    public void setReceiveBufferSizePredictor(ReceiveBufferSizePredictor predictor) {
        if (predictor == null) {
            throw new NullPointerException("predictor");
        }
        this.predictor = predictor;
    }

    public ReceiveBufferSizePredictorFactory getReceiveBufferSizePredictorFactory() {
        return this.predictorFactory;
    }

    public void setReceiveBufferSizePredictorFactory(ReceiveBufferSizePredictorFactory predictorFactory) {
        if (predictorFactory == null) {
            throw new NullPointerException("predictorFactory");
        }
        this.predictorFactory = predictorFactory;
    }
}

