/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.RejectedExecutionException;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelDownstreamHandler;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelHandler;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelHandlerLifeCycleException;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelPipelineException;
import org.elasticsearch.common.netty.channel.ChannelSink;
import org.elasticsearch.common.netty.channel.ChannelUpstreamHandler;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.channel.LifeCycleAwareChannelHandler;
import org.elasticsearch.common.netty.channel.UpstreamMessageEvent;
import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.InternalLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChannelPipeline
implements ChannelPipeline {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelPipeline.class);
    static final ChannelSink discardingSink = new DiscardingChannelSink();
    private volatile Channel channel;
    private volatile ChannelSink sink;
    private volatile DefaultChannelHandlerContext head;
    private volatile DefaultChannelHandlerContext tail;
    private final Map<String, DefaultChannelHandlerContext> name2ctx = new HashMap<String, DefaultChannelHandlerContext>(4);

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public ChannelSink getSink() {
        ChannelSink sink = this.sink;
        if (sink == null) {
            return discardingSink;
        }
        return sink;
    }

    @Override
    public void attach(Channel channel, ChannelSink sink) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (sink == null) {
            throw new NullPointerException("sink");
        }
        if (this.channel != null || this.sink != null) {
            throw new IllegalStateException("attached already");
        }
        this.channel = channel;
        this.sink = sink;
    }

    @Override
    public boolean isAttached() {
        return this.sink != null;
    }

    @Override
    public synchronized void addFirst(String name2, ChannelHandler handler) {
        if (this.name2ctx.isEmpty()) {
            this.init(name2, handler);
        } else {
            this.checkDuplicateName(name2);
            DefaultChannelHandlerContext oldHead = this.head;
            DefaultChannelHandlerContext newHead = new DefaultChannelHandlerContext(null, oldHead, name2, handler);
            DefaultChannelPipeline.callBeforeAdd(newHead);
            oldHead.prev = newHead;
            this.head = newHead;
            this.name2ctx.put(name2, newHead);
            this.callAfterAdd(newHead);
        }
    }

    @Override
    public synchronized void addLast(String name2, ChannelHandler handler) {
        if (this.name2ctx.isEmpty()) {
            this.init(name2, handler);
        } else {
            this.checkDuplicateName(name2);
            DefaultChannelHandlerContext oldTail = this.tail;
            DefaultChannelHandlerContext newTail = new DefaultChannelHandlerContext(oldTail, null, name2, handler);
            DefaultChannelPipeline.callBeforeAdd(newTail);
            oldTail.next = newTail;
            this.tail = newTail;
            this.name2ctx.put(name2, newTail);
            this.callAfterAdd(newTail);
        }
    }

    @Override
    public synchronized void addBefore(String baseName, String name2, ChannelHandler handler) {
        DefaultChannelHandlerContext ctx = this.getContextOrDie(baseName);
        if (ctx == this.head) {
            this.addFirst(name2, handler);
        } else {
            this.checkDuplicateName(name2);
            DefaultChannelHandlerContext newCtx = new DefaultChannelHandlerContext(ctx.prev, ctx, name2, handler);
            DefaultChannelPipeline.callBeforeAdd(newCtx);
            ctx.prev.next = newCtx;
            ctx.prev = newCtx;
            this.name2ctx.put(name2, newCtx);
            this.callAfterAdd(newCtx);
        }
    }

    @Override
    public synchronized void addAfter(String baseName, String name2, ChannelHandler handler) {
        DefaultChannelHandlerContext ctx = this.getContextOrDie(baseName);
        if (ctx == this.tail) {
            this.addLast(name2, handler);
        } else {
            this.checkDuplicateName(name2);
            DefaultChannelHandlerContext newCtx = new DefaultChannelHandlerContext(ctx, ctx.next, name2, handler);
            DefaultChannelPipeline.callBeforeAdd(newCtx);
            ctx.next.prev = newCtx;
            ctx.next = newCtx;
            this.name2ctx.put(name2, newCtx);
            this.callAfterAdd(newCtx);
        }
    }

    @Override
    public synchronized void remove(ChannelHandler handler) {
        this.remove(this.getContextOrDie(handler));
    }

    @Override
    public synchronized ChannelHandler remove(String name2) {
        return this.remove(this.getContextOrDie(name2)).getHandler();
    }

    @Override
    public synchronized <T extends ChannelHandler> T remove(Class<T> handlerType) {
        return (T)this.remove(this.getContextOrDie(handlerType)).getHandler();
    }

    private DefaultChannelHandlerContext remove(DefaultChannelHandlerContext ctx) {
        if (this.head == this.tail) {
            this.tail = null;
            this.head = null;
            this.name2ctx.clear();
        } else if (ctx == this.head) {
            this.removeFirst();
        } else if (ctx == this.tail) {
            this.removeLast();
        } else {
            DefaultChannelHandlerContext next;
            DefaultChannelPipeline.callBeforeRemove(ctx);
            DefaultChannelHandlerContext prev = ctx.prev;
            prev.next = next = ctx.next;
            next.prev = prev;
            this.name2ctx.remove(ctx.getName());
            DefaultChannelPipeline.callAfterRemove(ctx);
        }
        return ctx;
    }

    @Override
    public synchronized ChannelHandler removeFirst() {
        if (this.name2ctx.isEmpty()) {
            throw new NoSuchElementException();
        }
        DefaultChannelHandlerContext oldHead = this.head;
        if (oldHead == null) {
            throw new NoSuchElementException();
        }
        DefaultChannelPipeline.callBeforeRemove(oldHead);
        if (oldHead.next == null) {
            this.tail = null;
            this.head = null;
            this.name2ctx.clear();
        } else {
            oldHead.next.prev = null;
            this.head = oldHead.next;
            this.name2ctx.remove(oldHead.getName());
        }
        DefaultChannelPipeline.callAfterRemove(oldHead);
        return oldHead.getHandler();
    }

    @Override
    public synchronized ChannelHandler removeLast() {
        if (this.name2ctx.isEmpty()) {
            throw new NoSuchElementException();
        }
        DefaultChannelHandlerContext oldTail = this.tail;
        if (oldTail == null) {
            throw new NoSuchElementException();
        }
        DefaultChannelPipeline.callBeforeRemove(oldTail);
        if (oldTail.prev == null) {
            this.tail = null;
            this.head = null;
            this.name2ctx.clear();
        } else {
            oldTail.prev.next = null;
            this.tail = oldTail.prev;
            this.name2ctx.remove(oldTail.getName());
        }
        DefaultChannelPipeline.callBeforeRemove(oldTail);
        return oldTail.getHandler();
    }

    @Override
    public synchronized void replace(ChannelHandler oldHandler, String newName, ChannelHandler newHandler) {
        this.replace(this.getContextOrDie(oldHandler), newName, newHandler);
    }

    @Override
    public synchronized ChannelHandler replace(String oldName, String newName, ChannelHandler newHandler) {
        return this.replace(this.getContextOrDie(oldName), newName, newHandler);
    }

    @Override
    public synchronized <T extends ChannelHandler> T replace(Class<T> oldHandlerType, String newName, ChannelHandler newHandler) {
        return (T)this.replace(this.getContextOrDie(oldHandlerType), newName, newHandler);
    }

    private ChannelHandler replace(DefaultChannelHandlerContext ctx, String newName, ChannelHandler newHandler) {
        if (ctx == this.head) {
            this.removeFirst();
            this.addFirst(newName, newHandler);
        } else if (ctx == this.tail) {
            this.removeLast();
            this.addLast(newName, newHandler);
        } else {
            boolean sameName = ctx.getName().equals(newName);
            if (!sameName) {
                this.checkDuplicateName(newName);
            }
            DefaultChannelHandlerContext prev = ctx.prev;
            DefaultChannelHandlerContext next = ctx.next;
            DefaultChannelHandlerContext newCtx = new DefaultChannelHandlerContext(prev, next, newName, newHandler);
            DefaultChannelPipeline.callBeforeRemove(ctx);
            DefaultChannelPipeline.callBeforeAdd(newCtx);
            prev.next = newCtx;
            next.prev = newCtx;
            if (!sameName) {
                this.name2ctx.remove(ctx.getName());
            }
            this.name2ctx.put(newName, newCtx);
            ChannelHandlerLifeCycleException removeException = null;
            ChannelHandlerLifeCycleException addException = null;
            boolean removed = false;
            try {
                DefaultChannelPipeline.callAfterRemove(ctx);
                removed = true;
            }
            catch (ChannelHandlerLifeCycleException e) {
                removeException = e;
            }
            boolean added = false;
            try {
                this.callAfterAdd(newCtx);
                added = true;
            }
            catch (ChannelHandlerLifeCycleException e) {
                addException = e;
            }
            if (!removed && !added) {
                logger.warn(removeException.getMessage(), removeException);
                logger.warn(addException.getMessage(), addException);
                throw new ChannelHandlerLifeCycleException("Both " + ctx.getHandler().getClass().getName() + ".afterRemove() and " + newCtx.getHandler().getClass().getName() + ".afterAdd() failed; see logs.");
            }
            if (!removed) {
                throw removeException;
            }
            if (!added) {
                throw addException;
            }
        }
        return ctx.getHandler();
    }

    private static void callBeforeAdd(ChannelHandlerContext ctx) {
        if (!(ctx.getHandler() instanceof LifeCycleAwareChannelHandler)) {
            return;
        }
        LifeCycleAwareChannelHandler h = (LifeCycleAwareChannelHandler)ctx.getHandler();
        try {
            h.beforeAdd(ctx);
        }
        catch (Throwable t) {
            throw new ChannelHandlerLifeCycleException(h.getClass().getName() + ".beforeAdd() has thrown an exception; not adding.", t);
        }
    }

    private void callAfterAdd(ChannelHandlerContext ctx) {
        if (!(ctx.getHandler() instanceof LifeCycleAwareChannelHandler)) {
            return;
        }
        LifeCycleAwareChannelHandler h = (LifeCycleAwareChannelHandler)ctx.getHandler();
        try {
            h.afterAdd(ctx);
        }
        catch (Throwable t) {
            boolean removed;
            block6: {
                removed = false;
                try {
                    this.remove((DefaultChannelHandlerContext)ctx);
                    removed = true;
                }
                catch (Throwable t2) {
                    if (!logger.isWarnEnabled()) break block6;
                    logger.warn("Failed to remove a handler: " + ctx.getName(), t2);
                }
            }
            if (removed) {
                throw new ChannelHandlerLifeCycleException(h.getClass().getName() + ".afterAdd() has thrown an exception; removed.", t);
            }
            throw new ChannelHandlerLifeCycleException(h.getClass().getName() + ".afterAdd() has thrown an exception; also failed to remove.", t);
        }
    }

    private static void callBeforeRemove(ChannelHandlerContext ctx) {
        if (!(ctx.getHandler() instanceof LifeCycleAwareChannelHandler)) {
            return;
        }
        LifeCycleAwareChannelHandler h = (LifeCycleAwareChannelHandler)ctx.getHandler();
        try {
            h.beforeRemove(ctx);
        }
        catch (Throwable t) {
            throw new ChannelHandlerLifeCycleException(h.getClass().getName() + ".beforeRemove() has thrown an exception; not removing.", t);
        }
    }

    private static void callAfterRemove(ChannelHandlerContext ctx) {
        if (!(ctx.getHandler() instanceof LifeCycleAwareChannelHandler)) {
            return;
        }
        LifeCycleAwareChannelHandler h = (LifeCycleAwareChannelHandler)ctx.getHandler();
        try {
            h.afterRemove(ctx);
        }
        catch (Throwable t) {
            throw new ChannelHandlerLifeCycleException(h.getClass().getName() + ".afterRemove() has thrown an exception.", t);
        }
    }

    @Override
    public synchronized ChannelHandler getFirst() {
        DefaultChannelHandlerContext head = this.head;
        if (head == null) {
            return null;
        }
        return head.getHandler();
    }

    @Override
    public synchronized ChannelHandler getLast() {
        DefaultChannelHandlerContext tail = this.tail;
        if (tail == null) {
            return null;
        }
        return tail.getHandler();
    }

    @Override
    public synchronized ChannelHandler get(String name2) {
        DefaultChannelHandlerContext ctx = this.name2ctx.get(name2);
        if (ctx == null) {
            return null;
        }
        return ctx.getHandler();
    }

    @Override
    public synchronized <T extends ChannelHandler> T get(Class<T> handlerType) {
        ChannelHandlerContext ctx = this.getContext(handlerType);
        if (ctx == null) {
            return null;
        }
        ChannelHandler handler = ctx.getHandler();
        return (T)handler;
    }

    @Override
    public synchronized ChannelHandlerContext getContext(String name2) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        return this.name2ctx.get(name2);
    }

    @Override
    public synchronized ChannelHandlerContext getContext(ChannelHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (this.name2ctx.isEmpty()) {
            return null;
        }
        DefaultChannelHandlerContext ctx = this.head;
        do {
            if (ctx.getHandler() != handler) continue;
            return ctx;
        } while ((ctx = ctx.next) != null);
        return null;
    }

    @Override
    public synchronized ChannelHandlerContext getContext(Class<? extends ChannelHandler> handlerType) {
        if (handlerType == null) {
            throw new NullPointerException("handlerType");
        }
        if (this.name2ctx.isEmpty()) {
            return null;
        }
        DefaultChannelHandlerContext ctx = this.head;
        do {
            if (!handlerType.isAssignableFrom(ctx.getHandler().getClass())) continue;
            return ctx;
        } while ((ctx = ctx.next) != null);
        return null;
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> list2 = new ArrayList<String>();
        if (this.name2ctx.isEmpty()) {
            return list2;
        }
        DefaultChannelHandlerContext ctx = this.head;
        do {
            list2.add(ctx.getName());
        } while ((ctx = ctx.next) != null);
        return list2;
    }

    @Override
    public Map<String, ChannelHandler> toMap() {
        LinkedHashMap<String, ChannelHandler> map = new LinkedHashMap<String, ChannelHandler>();
        if (this.name2ctx.isEmpty()) {
            return map;
        }
        DefaultChannelHandlerContext ctx = this.head;
        do {
            map.put(ctx.getName(), ctx.getHandler());
        } while ((ctx = ctx.next) != null);
        return map;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('{');
        DefaultChannelHandlerContext ctx = this.head;
        if (ctx != null) {
            while (true) {
                buf.append('(');
                buf.append(ctx.getName());
                buf.append(" = ");
                buf.append(ctx.getHandler().getClass().getName());
                buf.append(')');
                ctx = ctx.next;
                if (ctx == null) break;
                buf.append(", ");
            }
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public void sendUpstream(ChannelEvent e) {
        DefaultChannelHandlerContext head = this.getActualUpstreamContext(this.head);
        if (head == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("The pipeline contains no upstream handlers; discarding: " + e);
            }
            return;
        }
        this.sendUpstream(head, e);
    }

    void sendUpstream(DefaultChannelHandlerContext ctx, ChannelEvent e) {
        try {
            ((ChannelUpstreamHandler)ctx.getHandler()).handleUpstream(ctx, e);
        }
        catch (Throwable t) {
            this.notifyHandlerException(e, t);
        }
    }

    @Override
    public void sendDownstream(ChannelEvent e) {
        DefaultChannelHandlerContext tail = this.getActualDownstreamContext(this.tail);
        if (tail == null) {
            try {
                this.getSink().eventSunk(this, e);
                return;
            }
            catch (Throwable t) {
                this.notifyHandlerException(e, t);
                return;
            }
        }
        this.sendDownstream(tail, e);
    }

    void sendDownstream(DefaultChannelHandlerContext ctx, ChannelEvent e) {
        if (e instanceof UpstreamMessageEvent) {
            throw new IllegalArgumentException("cannot send an upstream event to downstream");
        }
        try {
            ((ChannelDownstreamHandler)ctx.getHandler()).handleDownstream(ctx, e);
        }
        catch (Throwable t) {
            e.getFuture().setFailure(t);
            this.notifyHandlerException(e, t);
        }
    }

    private DefaultChannelHandlerContext getActualUpstreamContext(DefaultChannelHandlerContext ctx) {
        if (ctx == null) {
            return null;
        }
        DefaultChannelHandlerContext realCtx = ctx;
        while (!realCtx.canHandleUpstream()) {
            realCtx = realCtx.next;
            if (realCtx != null) continue;
            return null;
        }
        return realCtx;
    }

    private DefaultChannelHandlerContext getActualDownstreamContext(DefaultChannelHandlerContext ctx) {
        if (ctx == null) {
            return null;
        }
        DefaultChannelHandlerContext realCtx = ctx;
        while (!realCtx.canHandleDownstream()) {
            realCtx = realCtx.prev;
            if (realCtx != null) continue;
            return null;
        }
        return realCtx;
    }

    @Override
    public ChannelFuture execute(Runnable task) {
        return this.getSink().execute(this, task);
    }

    protected void notifyHandlerException(ChannelEvent e, Throwable t) {
        block4: {
            if (e instanceof ExceptionEvent) {
                if (logger.isWarnEnabled()) {
                    logger.warn("An exception was thrown by a user handler while handling an exception event (" + e + ')', t);
                }
                return;
            }
            ChannelPipelineException pe = t instanceof ChannelPipelineException ? (ChannelPipelineException)t : new ChannelPipelineException(t);
            try {
                this.sink.exceptionCaught(this, e, pe);
            }
            catch (Exception e1) {
                if (!logger.isWarnEnabled()) break block4;
                logger.warn("An exception was thrown by an exception handler.", e1);
            }
        }
    }

    private void init(String name2, ChannelHandler handler) {
        DefaultChannelHandlerContext ctx = new DefaultChannelHandlerContext(null, null, name2, handler);
        DefaultChannelPipeline.callBeforeAdd(ctx);
        this.head = this.tail = ctx;
        this.name2ctx.clear();
        this.name2ctx.put(name2, ctx);
        this.callAfterAdd(ctx);
    }

    private void checkDuplicateName(String name2) {
        if (this.name2ctx.containsKey(name2)) {
            throw new IllegalArgumentException("Duplicate handler name: " + name2);
        }
    }

    private DefaultChannelHandlerContext getContextOrDie(String name2) {
        DefaultChannelHandlerContext ctx = (DefaultChannelHandlerContext)this.getContext(name2);
        if (ctx == null) {
            throw new NoSuchElementException(name2);
        }
        return ctx;
    }

    private DefaultChannelHandlerContext getContextOrDie(ChannelHandler handler) {
        DefaultChannelHandlerContext ctx = (DefaultChannelHandlerContext)this.getContext(handler);
        if (ctx == null) {
            throw new NoSuchElementException(handler.getClass().getName());
        }
        return ctx;
    }

    private DefaultChannelHandlerContext getContextOrDie(Class<? extends ChannelHandler> handlerType) {
        DefaultChannelHandlerContext ctx = (DefaultChannelHandlerContext)this.getContext(handlerType);
        if (ctx == null) {
            throw new NoSuchElementException(handlerType.getName());
        }
        return ctx;
    }

    private static final class DiscardingChannelSink
    implements ChannelSink {
        DiscardingChannelSink() {
        }

        public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Not attached yet; discarding: " + e);
            }
        }

        public void exceptionCaught(ChannelPipeline pipeline, ChannelEvent e, ChannelPipelineException cause2) throws Exception {
            throw cause2;
        }

        public ChannelFuture execute(ChannelPipeline pipeline, Runnable task) {
            if (logger.isWarnEnabled()) {
                logger.warn("Not attached yet; rejecting: " + task);
            }
            return Channels.failedFuture(pipeline.getChannel(), new RejectedExecutionException("Not attached yet"));
        }
    }

    private final class DefaultChannelHandlerContext
    implements ChannelHandlerContext {
        volatile DefaultChannelHandlerContext next;
        volatile DefaultChannelHandlerContext prev;
        private final String name;
        private final ChannelHandler handler;
        private final boolean canHandleUpstream;
        private final boolean canHandleDownstream;
        private volatile Object attachment;

        DefaultChannelHandlerContext(DefaultChannelHandlerContext prev, DefaultChannelHandlerContext next, String name2, ChannelHandler handler) {
            if (name2 == null) {
                throw new NullPointerException("name");
            }
            if (handler == null) {
                throw new NullPointerException("handler");
            }
            this.canHandleUpstream = handler instanceof ChannelUpstreamHandler;
            this.canHandleDownstream = handler instanceof ChannelDownstreamHandler;
            if (!this.canHandleUpstream && !this.canHandleDownstream) {
                throw new IllegalArgumentException("handler must be either " + ChannelUpstreamHandler.class.getName() + " or " + ChannelDownstreamHandler.class.getName() + '.');
            }
            this.prev = prev;
            this.next = next;
            this.name = name2;
            this.handler = handler;
        }

        public Channel getChannel() {
            return this.getPipeline().getChannel();
        }

        public ChannelPipeline getPipeline() {
            return DefaultChannelPipeline.this;
        }

        public boolean canHandleDownstream() {
            return this.canHandleDownstream;
        }

        public boolean canHandleUpstream() {
            return this.canHandleUpstream;
        }

        public ChannelHandler getHandler() {
            return this.handler;
        }

        public String getName() {
            return this.name;
        }

        public Object getAttachment() {
            return this.attachment;
        }

        public void setAttachment(Object attachment) {
            this.attachment = attachment;
        }

        public void sendDownstream(ChannelEvent e) {
            DefaultChannelHandlerContext prev = DefaultChannelPipeline.this.getActualDownstreamContext(this.prev);
            if (prev == null) {
                try {
                    DefaultChannelPipeline.this.getSink().eventSunk(DefaultChannelPipeline.this, e);
                }
                catch (Throwable t) {
                    DefaultChannelPipeline.this.notifyHandlerException(e, t);
                }
            } else {
                DefaultChannelPipeline.this.sendDownstream(prev, e);
            }
        }

        public void sendUpstream(ChannelEvent e) {
            DefaultChannelHandlerContext next = DefaultChannelPipeline.this.getActualUpstreamContext(this.next);
            if (next != null) {
                DefaultChannelPipeline.this.sendUpstream(next, e);
            }
        }
    }
}

