/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.netty.buffer.BigEndianHeapChannelBuffer;
import org.elasticsearch.common.netty.buffer.ByteBufferBackedChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBufferFactory;
import org.elasticsearch.common.netty.buffer.ChannelBufferIndexFinder;
import org.elasticsearch.common.netty.buffer.CompositeChannelBuffer;
import org.elasticsearch.common.netty.buffer.DynamicChannelBuffer;
import org.elasticsearch.common.netty.buffer.LittleEndianHeapChannelBuffer;
import org.elasticsearch.common.netty.buffer.ReadOnlyChannelBuffer;
import org.elasticsearch.common.netty.buffer.SlicedChannelBuffer;
import org.elasticsearch.common.netty.buffer.TruncatedChannelBuffer;
import org.elasticsearch.common.netty.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelBuffers {
    public static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    public static final ChannelBuffer EMPTY_BUFFER = new BigEndianHeapChannelBuffer(0);
    private static final char[] HEXDUMP_TABLE = new char[1024];

    public static ChannelBuffer buffer(int capacity) {
        return ChannelBuffers.buffer(BIG_ENDIAN, capacity);
    }

    public static ChannelBuffer buffer(ByteOrder endianness, int capacity) {
        if (endianness == BIG_ENDIAN) {
            if (capacity == 0) {
                return EMPTY_BUFFER;
            }
            return new BigEndianHeapChannelBuffer(capacity);
        }
        if (endianness == LITTLE_ENDIAN) {
            if (capacity == 0) {
                return EMPTY_BUFFER;
            }
            return new LittleEndianHeapChannelBuffer(capacity);
        }
        throw new NullPointerException("endianness");
    }

    public static ChannelBuffer directBuffer(int capacity) {
        return ChannelBuffers.directBuffer(BIG_ENDIAN, capacity);
    }

    public static ChannelBuffer directBuffer(ByteOrder endianness, int capacity) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (capacity == 0) {
            return EMPTY_BUFFER;
        }
        ByteBufferBackedChannelBuffer buffer = new ByteBufferBackedChannelBuffer(ByteBuffer.allocateDirect(capacity).order(endianness));
        buffer.clear();
        return buffer;
    }

    public static ChannelBuffer dynamicBuffer() {
        return ChannelBuffers.dynamicBuffer(BIG_ENDIAN, 256);
    }

    public static ChannelBuffer dynamicBuffer(ChannelBufferFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        return new DynamicChannelBuffer(factory.getDefaultOrder(), 256, factory);
    }

    public static ChannelBuffer dynamicBuffer(int estimatedLength) {
        return ChannelBuffers.dynamicBuffer(BIG_ENDIAN, estimatedLength);
    }

    public static ChannelBuffer dynamicBuffer(ByteOrder endianness, int estimatedLength) {
        return new DynamicChannelBuffer(endianness, estimatedLength);
    }

    public static ChannelBuffer dynamicBuffer(int estimatedLength, ChannelBufferFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        return new DynamicChannelBuffer(factory.getDefaultOrder(), estimatedLength, factory);
    }

    public static ChannelBuffer dynamicBuffer(ByteOrder endianness, int estimatedLength, ChannelBufferFactory factory) {
        return new DynamicChannelBuffer(endianness, estimatedLength, factory);
    }

    public static ChannelBuffer wrappedBuffer(byte[] array) {
        return ChannelBuffers.wrappedBuffer(BIG_ENDIAN, array);
    }

    public static ChannelBuffer wrappedBuffer(ByteOrder endianness, byte[] array) {
        if (endianness == BIG_ENDIAN) {
            if (array.length == 0) {
                return EMPTY_BUFFER;
            }
            return new BigEndianHeapChannelBuffer(array);
        }
        if (endianness == LITTLE_ENDIAN) {
            if (array.length == 0) {
                return EMPTY_BUFFER;
            }
            return new LittleEndianHeapChannelBuffer(array);
        }
        throw new NullPointerException("endianness");
    }

    public static ChannelBuffer wrappedBuffer(byte[] array, int offset2, int length2) {
        return ChannelBuffers.wrappedBuffer(BIG_ENDIAN, array, offset2, length2);
    }

    public static ChannelBuffer wrappedBuffer(ByteOrder endianness, byte[] array, int offset2, int length2) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (offset2 == 0) {
            if (length2 == array.length) {
                return ChannelBuffers.wrappedBuffer(endianness, array);
            }
            if (length2 == 0) {
                return EMPTY_BUFFER;
            }
            return new TruncatedChannelBuffer(ChannelBuffers.wrappedBuffer(endianness, array), length2);
        }
        if (length2 == 0) {
            return EMPTY_BUFFER;
        }
        return new SlicedChannelBuffer(ChannelBuffers.wrappedBuffer(endianness, array), offset2, length2);
    }

    public static ChannelBuffer wrappedBuffer(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return EMPTY_BUFFER;
        }
        if (buffer.hasArray()) {
            return ChannelBuffers.wrappedBuffer(buffer.order(), buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }
        return new ByteBufferBackedChannelBuffer(buffer);
    }

    public static ChannelBuffer wrappedBuffer(ChannelBuffer buffer) {
        if (buffer.readable()) {
            return buffer.slice();
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer wrappedBuffer(byte[] ... arrays) {
        return ChannelBuffers.wrappedBuffer(BIG_ENDIAN, arrays);
    }

    public static ChannelBuffer wrappedBuffer(ByteOrder endianness, byte[] ... arrays) {
        switch (arrays.length) {
            case 0: {
                break;
            }
            case 1: {
                if (arrays[0].length == 0) break;
                return ChannelBuffers.wrappedBuffer(endianness, arrays[0]);
            }
            default: {
                ArrayList<ChannelBuffer> components = new ArrayList<ChannelBuffer>(arrays.length);
                for (byte[] a : arrays) {
                    if (a == null) break;
                    if (a.length <= 0) continue;
                    components.add(ChannelBuffers.wrappedBuffer(endianness, a));
                }
                return ChannelBuffers.compositeBuffer(endianness, components, false);
            }
        }
        return EMPTY_BUFFER;
    }

    private static ChannelBuffer compositeBuffer(ByteOrder endianness, List<ChannelBuffer> components, boolean gathering) {
        switch (components.size()) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return components.get(0);
            }
        }
        return new CompositeChannelBuffer(endianness, components, gathering);
    }

    public static ChannelBuffer wrappedBuffer(ChannelBuffer ... buffers) {
        return ChannelBuffers.wrappedBuffer(false, buffers);
    }

    public static ChannelBuffer wrappedBuffer(boolean gathering, ChannelBuffer ... buffers) {
        switch (buffers.length) {
            case 0: {
                break;
            }
            case 1: {
                if (!buffers[0].readable()) break;
                return ChannelBuffers.wrappedBuffer(buffers[0]);
            }
            default: {
                ByteOrder order2 = null;
                ArrayList<ChannelBuffer> components = new ArrayList<ChannelBuffer>(buffers.length);
                for (ChannelBuffer c : buffers) {
                    if (c == null) break;
                    if (!c.readable()) continue;
                    if (order2 != null) {
                        if (!order2.equals(c.order())) {
                            throw new IllegalArgumentException("inconsistent byte order");
                        }
                    } else {
                        order2 = c.order();
                    }
                    if (c instanceof CompositeChannelBuffer) {
                        components.addAll(((CompositeChannelBuffer)c).decompose(c.readerIndex(), c.readableBytes()));
                        continue;
                    }
                    components.add(c.slice());
                }
                return ChannelBuffers.compositeBuffer(order2, components, gathering);
            }
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer wrappedBuffer(ByteBuffer ... buffers) {
        return ChannelBuffers.wrappedBuffer(false, buffers);
    }

    public static ChannelBuffer wrappedBuffer(boolean gathering, ByteBuffer ... buffers) {
        switch (buffers.length) {
            case 0: {
                break;
            }
            case 1: {
                if (!buffers[0].hasRemaining()) break;
                return ChannelBuffers.wrappedBuffer(buffers[0]);
            }
            default: {
                ByteOrder order2 = null;
                ArrayList<ChannelBuffer> components = new ArrayList<ChannelBuffer>(buffers.length);
                for (ByteBuffer b : buffers) {
                    if (b == null) break;
                    if (!b.hasRemaining()) continue;
                    if (order2 != null) {
                        if (!order2.equals(b.order())) {
                            throw new IllegalArgumentException("inconsistent byte order");
                        }
                    } else {
                        order2 = b.order();
                    }
                    components.add(ChannelBuffers.wrappedBuffer(b));
                }
                return ChannelBuffers.compositeBuffer(order2, components, gathering);
            }
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer copiedBuffer(byte[] array) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, array);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, byte[] array) {
        if (endianness == BIG_ENDIAN) {
            if (array.length == 0) {
                return EMPTY_BUFFER;
            }
            return new BigEndianHeapChannelBuffer((byte[])array.clone());
        }
        if (endianness == LITTLE_ENDIAN) {
            if (array.length == 0) {
                return EMPTY_BUFFER;
            }
            return new LittleEndianHeapChannelBuffer((byte[])array.clone());
        }
        throw new NullPointerException("endianness");
    }

    public static ChannelBuffer copiedBuffer(byte[] array, int offset2, int length2) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, array, offset2, length2);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, byte[] array, int offset2, int length2) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (length2 == 0) {
            return EMPTY_BUFFER;
        }
        byte[] copy = new byte[length2];
        System.arraycopy(array, offset2, copy, 0, length2);
        return ChannelBuffers.wrappedBuffer(endianness, copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelBuffer copiedBuffer(ByteBuffer buffer) {
        int length2 = buffer.remaining();
        if (length2 == 0) {
            return EMPTY_BUFFER;
        }
        byte[] copy = new byte[length2];
        int position = buffer.position();
        try {
            buffer.get(copy);
        }
        finally {
            buffer.position(position);
        }
        return ChannelBuffers.wrappedBuffer(buffer.order(), copy);
    }

    public static ChannelBuffer copiedBuffer(ChannelBuffer buffer) {
        if (buffer.readable()) {
            return buffer.copy();
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer copiedBuffer(byte[] ... arrays) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, arrays);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, byte[] ... arrays) {
        switch (arrays.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                if (arrays[0].length == 0) {
                    return EMPTY_BUFFER;
                }
                return ChannelBuffers.copiedBuffer(endianness, arrays[0]);
            }
        }
        int length2 = 0;
        for (byte[] a : arrays) {
            if (Integer.MAX_VALUE - length2 < a.length) {
                throw new IllegalArgumentException("The total length of the specified arrays is too big.");
            }
            length2 += a.length;
        }
        if (length2 == 0) {
            return EMPTY_BUFFER;
        }
        byte[] mergedArray = new byte[length2];
        int j = 0;
        for (int i2 = 0; i2 < arrays.length; ++i2) {
            byte[] a;
            a = arrays[i2];
            System.arraycopy(a, 0, mergedArray, j, a.length);
            j += a.length;
        }
        return ChannelBuffers.wrappedBuffer(endianness, mergedArray);
    }

    public static ChannelBuffer copiedBuffer(ChannelBuffer ... buffers) {
        switch (buffers.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return ChannelBuffers.copiedBuffer(buffers[0]);
            }
        }
        ChannelBuffer[] copiedBuffers = new ChannelBuffer[buffers.length];
        for (int i2 = 0; i2 < buffers.length; ++i2) {
            copiedBuffers[i2] = ChannelBuffers.copiedBuffer(buffers[i2]);
        }
        return ChannelBuffers.wrappedBuffer(false, copiedBuffers);
    }

    public static ChannelBuffer copiedBuffer(ByteBuffer ... buffers) {
        switch (buffers.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return ChannelBuffers.copiedBuffer(buffers[0]);
            }
        }
        ChannelBuffer[] copiedBuffers = new ChannelBuffer[buffers.length];
        for (int i2 = 0; i2 < buffers.length; ++i2) {
            copiedBuffers[i2] = ChannelBuffers.copiedBuffer(buffers[i2]);
        }
        return ChannelBuffers.wrappedBuffer(false, copiedBuffers);
    }

    public static ChannelBuffer copiedBuffer(CharSequence string2, Charset charset) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, string2, charset);
    }

    public static ChannelBuffer copiedBuffer(CharSequence string2, int offset2, int length2, Charset charset) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, string2, offset2, length2, charset);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, CharSequence string2, Charset charset) {
        if (string2 == null) {
            throw new NullPointerException("string");
        }
        if (string2 instanceof CharBuffer) {
            return ChannelBuffers.copiedBuffer(endianness, (CharBuffer)string2, charset);
        }
        return ChannelBuffers.copiedBuffer(endianness, CharBuffer.wrap(string2), charset);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, CharSequence string2, int offset2, int length2, Charset charset) {
        if (string2 == null) {
            throw new NullPointerException("string");
        }
        if (length2 == 0) {
            return EMPTY_BUFFER;
        }
        if (string2 instanceof CharBuffer) {
            CharBuffer buf = (CharBuffer)string2;
            if (buf.hasArray()) {
                return ChannelBuffers.copiedBuffer(endianness, buf.array(), buf.arrayOffset() + buf.position() + offset2, length2, charset);
            }
            buf = buf.slice();
            buf.limit(length2);
            buf.position(offset2);
            return ChannelBuffers.copiedBuffer(endianness, buf, charset);
        }
        return ChannelBuffers.copiedBuffer(endianness, CharBuffer.wrap(string2, offset2, offset2 + length2), charset);
    }

    public static ChannelBuffer copiedBuffer(char[] array, Charset charset) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, array, 0, array.length, charset);
    }

    public static ChannelBuffer copiedBuffer(char[] array, int offset2, int length2, Charset charset) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, array, offset2, length2, charset);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, char[] array, Charset charset) {
        return ChannelBuffers.copiedBuffer(endianness, array, 0, array.length, charset);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, char[] array, int offset2, int length2, Charset charset) {
        if (array == null) {
            throw new NullPointerException("array");
        }
        if (length2 == 0) {
            return EMPTY_BUFFER;
        }
        return ChannelBuffers.copiedBuffer(endianness, CharBuffer.wrap(array, offset2, length2), charset);
    }

    private static ChannelBuffer copiedBuffer(ByteOrder endianness, CharBuffer buffer, Charset charset) {
        CharBuffer src = buffer;
        ByteBuffer dst = ChannelBuffers.encodeString(src, charset);
        ChannelBuffer result2 = ChannelBuffers.wrappedBuffer(endianness, dst.array());
        result2.writerIndex(dst.remaining());
        return result2;
    }

    @Deprecated
    public static ChannelBuffer copiedBuffer(String string2, String charsetName) {
        return ChannelBuffers.copiedBuffer((CharSequence)string2, Charset.forName(charsetName));
    }

    @Deprecated
    public static ChannelBuffer copiedBuffer(ByteOrder endianness, String string2, String charsetName) {
        return ChannelBuffers.copiedBuffer(endianness, (CharSequence)string2, Charset.forName(charsetName));
    }

    public static ChannelBuffer unmodifiableBuffer(ChannelBuffer buffer) {
        if (buffer instanceof ReadOnlyChannelBuffer) {
            buffer = ((ReadOnlyChannelBuffer)buffer).unwrap();
        }
        return new ReadOnlyChannelBuffer(buffer);
    }

    public static ChannelBuffer hexDump(String hexString) {
        int len = hexString.length();
        byte[] hexData = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            hexData[i2 / 2] = (byte)((Character.digit(hexString.charAt(i2), 16) << 4) + Character.digit(hexString.charAt(i2 + 1), 16));
        }
        return ChannelBuffers.wrappedBuffer(hexData);
    }

    public static String hexDump(ChannelBuffer buffer) {
        return ChannelBuffers.hexDump(buffer, buffer.readerIndex(), buffer.readableBytes());
    }

    public static String hexDump(ChannelBuffer buffer, int fromIndex, int length2) {
        if (length2 < 0) {
            throw new IllegalArgumentException("length: " + length2);
        }
        if (length2 == 0) {
            return "";
        }
        int endIndex = fromIndex + length2;
        char[] buf = new char[length2 << 1];
        int srcIdx = fromIndex;
        int dstIdx = 0;
        while (srcIdx < endIndex) {
            System.arraycopy(HEXDUMP_TABLE, buffer.getUnsignedByte(srcIdx) << 1, buf, dstIdx, 2);
            ++srcIdx;
            dstIdx += 2;
        }
        return new String(buf);
    }

    public static int hashCode(ChannelBuffer buffer) {
        int i2;
        int aLen = buffer.readableBytes();
        int intCount = aLen >>> 2;
        int byteCount = aLen & 3;
        int hashCode = 1;
        int arrayIndex = buffer.readerIndex();
        if (buffer.order() == BIG_ENDIAN) {
            for (i2 = intCount; i2 > 0; --i2) {
                hashCode = 31 * hashCode + buffer.getInt(arrayIndex);
                arrayIndex += 4;
            }
        } else {
            for (i2 = intCount; i2 > 0; --i2) {
                hashCode = 31 * hashCode + ChannelBuffers.swapInt(buffer.getInt(arrayIndex));
                arrayIndex += 4;
            }
        }
        for (i2 = byteCount; i2 > 0; --i2) {
            hashCode = 31 * hashCode + buffer.getByte(arrayIndex++);
        }
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    public static boolean equals(ChannelBuffer bufferA, ChannelBuffer bufferB) {
        int i2;
        int aLen = bufferA.readableBytes();
        if (aLen != bufferB.readableBytes()) {
            return false;
        }
        int longCount = aLen >>> 3;
        int byteCount = aLen & 7;
        int aIndex = bufferA.readerIndex();
        int bIndex = bufferB.readerIndex();
        if (bufferA.order() == bufferB.order()) {
            for (i2 = longCount; i2 > 0; --i2) {
                if (bufferA.getLong(aIndex) != bufferB.getLong(bIndex)) {
                    return false;
                }
                aIndex += 8;
                bIndex += 8;
            }
        } else {
            for (i2 = longCount; i2 > 0; --i2) {
                if (bufferA.getLong(aIndex) != ChannelBuffers.swapLong(bufferB.getLong(bIndex))) {
                    return false;
                }
                aIndex += 8;
                bIndex += 8;
            }
        }
        for (i2 = byteCount; i2 > 0; --i2) {
            if (bufferA.getByte(aIndex) != bufferB.getByte(bIndex)) {
                return false;
            }
            ++aIndex;
            ++bIndex;
        }
        return true;
    }

    public static int compare(ChannelBuffer bufferA, ChannelBuffer bufferB) {
        long vb;
        long va;
        int i2;
        int aLen = bufferA.readableBytes();
        int bLen = bufferB.readableBytes();
        int minLength = Math.min(aLen, bLen);
        int uintCount = minLength >>> 2;
        int byteCount = minLength & 3;
        int aIndex = bufferA.readerIndex();
        int bIndex = bufferB.readerIndex();
        if (bufferA.order() == bufferB.order()) {
            for (i2 = uintCount; i2 > 0; --i2) {
                va = bufferA.getUnsignedInt(aIndex);
                if (va > (vb = bufferB.getUnsignedInt(bIndex))) {
                    return 1;
                }
                if (va < vb) {
                    return -1;
                }
                aIndex += 4;
                bIndex += 4;
            }
        } else {
            for (i2 = uintCount; i2 > 0; --i2) {
                va = bufferA.getUnsignedInt(aIndex);
                if (va > (vb = (long)ChannelBuffers.swapInt(bufferB.getInt(bIndex)) & 0xFFFFFFFFL)) {
                    return 1;
                }
                if (va < vb) {
                    return -1;
                }
                aIndex += 4;
                bIndex += 4;
            }
        }
        for (i2 = byteCount; i2 > 0; --i2) {
            short vb2;
            short va2 = bufferA.getUnsignedByte(aIndex);
            if (va2 > (vb2 = bufferB.getUnsignedByte(bIndex))) {
                return 1;
            }
            if (va2 < vb2) {
                return -1;
            }
            ++aIndex;
            ++bIndex;
        }
        return aLen - bLen;
    }

    public static int indexOf(ChannelBuffer buffer, int fromIndex, int toIndex, byte value2) {
        if (fromIndex <= toIndex) {
            return ChannelBuffers.firstIndexOf(buffer, fromIndex, toIndex, value2);
        }
        return ChannelBuffers.lastIndexOf(buffer, fromIndex, toIndex, value2);
    }

    public static int indexOf(ChannelBuffer buffer, int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        if (fromIndex <= toIndex) {
            return ChannelBuffers.firstIndexOf(buffer, fromIndex, toIndex, indexFinder);
        }
        return ChannelBuffers.lastIndexOf(buffer, fromIndex, toIndex, indexFinder);
    }

    public static short swapShort(short value2) {
        return (short)(value2 << 8 | value2 >>> 8 & 0xFF);
    }

    public static int swapMedium(int value2) {
        return value2 << 16 & 0xFF0000 | value2 & 0xFF00 | value2 >>> 16 & 0xFF;
    }

    public static int swapInt(int value2) {
        return ChannelBuffers.swapShort((short)value2) << 16 | ChannelBuffers.swapShort((short)(value2 >>> 16)) & 0xFFFF;
    }

    public static long swapLong(long value2) {
        return (long)ChannelBuffers.swapInt((int)value2) << 32 | (long)ChannelBuffers.swapInt((int)(value2 >>> 32)) & 0xFFFFFFFFL;
    }

    private static int firstIndexOf(ChannelBuffer buffer, int fromIndex, int toIndex, byte value2) {
        if ((fromIndex = Math.max(fromIndex, 0)) >= toIndex || buffer.capacity() == 0) {
            return -1;
        }
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            if (buffer.getByte(i2) != value2) continue;
            return i2;
        }
        return -1;
    }

    private static int lastIndexOf(ChannelBuffer buffer, int fromIndex, int toIndex, byte value2) {
        if ((fromIndex = Math.min(fromIndex, buffer.capacity())) < 0 || buffer.capacity() == 0) {
            return -1;
        }
        for (int i2 = fromIndex - 1; i2 >= toIndex; --i2) {
            if (buffer.getByte(i2) != value2) continue;
            return i2;
        }
        return -1;
    }

    private static int firstIndexOf(ChannelBuffer buffer, int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        if ((fromIndex = Math.max(fromIndex, 0)) >= toIndex || buffer.capacity() == 0) {
            return -1;
        }
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            if (!indexFinder.find(buffer, i2)) continue;
            return i2;
        }
        return -1;
    }

    private static int lastIndexOf(ChannelBuffer buffer, int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        if ((fromIndex = Math.min(fromIndex, buffer.capacity())) < 0 || buffer.capacity() == 0) {
            return -1;
        }
        for (int i2 = fromIndex - 1; i2 >= toIndex; --i2) {
            if (!indexFinder.find(buffer, i2)) continue;
            return i2;
        }
        return -1;
    }

    static ByteBuffer encodeString(CharBuffer src, Charset charset) {
        CharsetEncoder encoder = CharsetUtil.getEncoder(charset);
        ByteBuffer dst = ByteBuffer.allocate((int)((double)src.remaining() * (double)encoder.maxBytesPerChar()));
        try {
            CoderResult cr = encoder.encode(src, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = encoder.flush(dst)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
        dst.flip();
        return dst;
    }

    static String decodeString(ByteBuffer src, Charset charset) {
        CharsetDecoder decoder = CharsetUtil.getDecoder(charset);
        CharBuffer dst = CharBuffer.allocate((int)((double)src.remaining() * (double)decoder.maxCharsPerByte()));
        try {
            CoderResult cr = decoder.decode(src, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = decoder.flush(dst)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
        return dst.flip().toString();
    }

    private ChannelBuffers() {
    }

    static {
        char[] DIGITS = "0123456789abcdef".toCharArray();
        for (int i2 = 0; i2 < 256; ++i2) {
            ChannelBuffers.HEXDUMP_TABLE[i2 << 1] = DIGITS[i2 >>> 4 & 0xF];
            ChannelBuffers.HEXDUMP_TABLE[(i2 << 1) + 1] = DIGITS[i2 & 0xF];
        }
    }
}

