/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.buffer;

import java.nio.ByteOrder;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBufferFactory;

public abstract class AbstractChannelBufferFactory
implements ChannelBufferFactory {
    private final ByteOrder defaultOrder;

    protected AbstractChannelBufferFactory() {
        this(ByteOrder.BIG_ENDIAN);
    }

    protected AbstractChannelBufferFactory(ByteOrder defaultOrder) {
        if (defaultOrder == null) {
            throw new NullPointerException("defaultOrder");
        }
        this.defaultOrder = defaultOrder;
    }

    public ChannelBuffer getBuffer(int capacity) {
        return this.getBuffer(this.getDefaultOrder(), capacity);
    }

    public ChannelBuffer getBuffer(byte[] array, int offset2, int length2) {
        return this.getBuffer(this.getDefaultOrder(), array, offset2, length2);
    }

    public ByteOrder getDefaultOrder() {
        return this.defaultOrder;
    }
}

