/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBufferIndexFinder;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;

public abstract class AbstractChannelBuffer
implements ChannelBuffer {
    private int readerIndex;
    private int writerIndex;
    private int markedReaderIndex;
    private int markedWriterIndex;

    public int readerIndex() {
        return this.readerIndex;
    }

    public void readerIndex(int readerIndex) {
        if (readerIndex < 0 || readerIndex > this.writerIndex) {
            throw new IndexOutOfBoundsException();
        }
        this.readerIndex = readerIndex;
    }

    public int writerIndex() {
        return this.writerIndex;
    }

    public void writerIndex(int writerIndex) {
        if (writerIndex < this.readerIndex || writerIndex > this.capacity()) {
            throw new IndexOutOfBoundsException("Invalid readerIndex: " + this.readerIndex + " - Maximum is " + writerIndex);
        }
        this.writerIndex = writerIndex;
    }

    public void setIndex(int readerIndex, int writerIndex) {
        if (readerIndex < 0 || readerIndex > writerIndex || writerIndex > this.capacity()) {
            throw new IndexOutOfBoundsException("Invalid writerIndex: " + writerIndex + " - Maximum is " + readerIndex + " or " + this.capacity());
        }
        this.readerIndex = readerIndex;
        this.writerIndex = writerIndex;
    }

    public void clear() {
        this.writerIndex = 0;
        this.readerIndex = 0;
    }

    public boolean readable() {
        return this.readableBytes() > 0;
    }

    public boolean writable() {
        return this.writableBytes() > 0;
    }

    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    public int writableBytes() {
        return this.capacity() - this.writerIndex;
    }

    public void markReaderIndex() {
        this.markedReaderIndex = this.readerIndex;
    }

    public void resetReaderIndex() {
        this.readerIndex(this.markedReaderIndex);
    }

    public void markWriterIndex() {
        this.markedWriterIndex = this.writerIndex;
    }

    public void resetWriterIndex() {
        this.writerIndex = this.markedWriterIndex;
    }

    public void discardReadBytes() {
        if (this.readerIndex == 0) {
            return;
        }
        this.setBytes(0, this, this.readerIndex, this.writerIndex - this.readerIndex);
        this.writerIndex -= this.readerIndex;
        this.markedReaderIndex = Math.max(this.markedReaderIndex - this.readerIndex, 0);
        this.markedWriterIndex = Math.max(this.markedWriterIndex - this.readerIndex, 0);
        this.readerIndex = 0;
    }

    public void ensureWritableBytes(int writableBytes) {
        if (writableBytes > this.writableBytes()) {
            throw new IndexOutOfBoundsException("Writable bytes exceeded: Got " + writableBytes + ", maximum is " + this.writableBytes());
        }
    }

    public short getUnsignedByte(int index2) {
        return (short)(this.getByte(index2) & 0xFF);
    }

    public int getUnsignedShort(int index2) {
        return this.getShort(index2) & 0xFFFF;
    }

    public int getMedium(int index2) {
        int value2 = this.getUnsignedMedium(index2);
        if ((value2 & 0x800000) != 0) {
            value2 |= 0xFF000000;
        }
        return value2;
    }

    public long getUnsignedInt(int index2) {
        return (long)this.getInt(index2) & 0xFFFFFFFFL;
    }

    public char getChar(int index2) {
        return (char)this.getShort(index2);
    }

    public float getFloat(int index2) {
        return Float.intBitsToFloat(this.getInt(index2));
    }

    public double getDouble(int index2) {
        return Double.longBitsToDouble(this.getLong(index2));
    }

    public void getBytes(int index2, byte[] dst) {
        this.getBytes(index2, dst, 0, dst.length);
    }

    public void getBytes(int index2, ChannelBuffer dst) {
        this.getBytes(index2, dst, dst.writableBytes());
    }

    public void getBytes(int index2, ChannelBuffer dst, int length2) {
        if (length2 > dst.writableBytes()) {
            throw new IndexOutOfBoundsException("Too many bytes to be read: Need " + length2 + ", maximum is " + dst.writableBytes());
        }
        this.getBytes(index2, dst, dst.writerIndex(), length2);
        dst.writerIndex(dst.writerIndex() + length2);
    }

    public void setChar(int index2, int value2) {
        this.setShort(index2, value2);
    }

    public void setFloat(int index2, float value2) {
        this.setInt(index2, Float.floatToRawIntBits(value2));
    }

    public void setDouble(int index2, double value2) {
        this.setLong(index2, Double.doubleToRawLongBits(value2));
    }

    public void setBytes(int index2, byte[] src) {
        this.setBytes(index2, src, 0, src.length);
    }

    public void setBytes(int index2, ChannelBuffer src) {
        this.setBytes(index2, src, src.readableBytes());
    }

    public void setBytes(int index2, ChannelBuffer src, int length2) {
        if (length2 > src.readableBytes()) {
            throw new IndexOutOfBoundsException("Too many bytes to write: Need " + length2 + ", maximum is " + src.readableBytes());
        }
        this.setBytes(index2, src, src.readerIndex(), length2);
        src.readerIndex(src.readerIndex() + length2);
    }

    public void setZero(int index2, int length2) {
        int i2;
        if (length2 == 0) {
            return;
        }
        if (length2 < 0) {
            throw new IllegalArgumentException("length must be 0 or greater than 0.");
        }
        int nLong = length2 >>> 3;
        int nBytes = length2 & 7;
        for (i2 = nLong; i2 > 0; --i2) {
            this.setLong(index2, 0L);
            index2 += 8;
        }
        if (nBytes == 4) {
            this.setInt(index2, 0);
        } else if (nBytes < 4) {
            for (i2 = nBytes; i2 > 0; --i2) {
                this.setByte(index2, 0);
                ++index2;
            }
        } else {
            this.setInt(index2, 0);
            index2 += 4;
            for (i2 = nBytes - 4; i2 > 0; --i2) {
                this.setByte(index2, 0);
                ++index2;
            }
        }
    }

    public byte readByte() {
        if (this.readerIndex == this.writerIndex) {
            throw new IndexOutOfBoundsException("Readable byte limit exceeded: " + this.readerIndex);
        }
        return this.getByte(this.readerIndex++);
    }

    public short readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    public short readShort() {
        this.checkReadableBytes(2);
        short v = this.getShort(this.readerIndex);
        this.readerIndex += 2;
        return v;
    }

    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public int readMedium() {
        int value2 = this.readUnsignedMedium();
        if ((value2 & 0x800000) != 0) {
            value2 |= 0xFF000000;
        }
        return value2;
    }

    public int readUnsignedMedium() {
        this.checkReadableBytes(3);
        int v = this.getUnsignedMedium(this.readerIndex);
        this.readerIndex += 3;
        return v;
    }

    public int readInt() {
        this.checkReadableBytes(4);
        int v = this.getInt(this.readerIndex);
        this.readerIndex += 4;
        return v;
    }

    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong() {
        this.checkReadableBytes(8);
        long v = this.getLong(this.readerIndex);
        this.readerIndex += 8;
        return v;
    }

    public char readChar() {
        return (char)this.readShort();
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public ChannelBuffer readBytes(int length2) {
        this.checkReadableBytes(length2);
        if (length2 == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        ChannelBuffer buf = this.factory().getBuffer(this.order(), length2);
        buf.writeBytes(this, this.readerIndex, length2);
        this.readerIndex += length2;
        return buf;
    }

    @Deprecated
    public ChannelBuffer readBytes(ChannelBufferIndexFinder endIndexFinder) {
        int endIndex = this.indexOf(this.readerIndex, this.writerIndex, endIndexFinder);
        if (endIndex < 0) {
            throw new NoSuchElementException();
        }
        return this.readBytes(endIndex - this.readerIndex);
    }

    public ChannelBuffer readSlice(int length2) {
        ChannelBuffer slice = this.slice(this.readerIndex, length2);
        this.readerIndex += length2;
        return slice;
    }

    @Deprecated
    public ChannelBuffer readSlice(ChannelBufferIndexFinder endIndexFinder) {
        int endIndex = this.indexOf(this.readerIndex, this.writerIndex, endIndexFinder);
        if (endIndex < 0) {
            throw new NoSuchElementException();
        }
        return this.readSlice(endIndex - this.readerIndex);
    }

    public void readBytes(byte[] dst, int dstIndex, int length2) {
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst, dstIndex, length2);
        this.readerIndex += length2;
    }

    public void readBytes(byte[] dst) {
        this.readBytes(dst, 0, dst.length);
    }

    public void readBytes(ChannelBuffer dst) {
        this.readBytes(dst, dst.writableBytes());
    }

    public void readBytes(ChannelBuffer dst, int length2) {
        if (length2 > dst.writableBytes()) {
            throw new IndexOutOfBoundsException("Too many bytes to be read: Need " + length2 + ", maximum is " + dst.writableBytes());
        }
        this.readBytes(dst, dst.writerIndex(), length2);
        dst.writerIndex(dst.writerIndex() + length2);
    }

    public void readBytes(ChannelBuffer dst, int dstIndex, int length2) {
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst, dstIndex, length2);
        this.readerIndex += length2;
    }

    public void readBytes(ByteBuffer dst) {
        int length2 = dst.remaining();
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst);
        this.readerIndex += length2;
    }

    public int readBytes(GatheringByteChannel out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes = this.getBytes(this.readerIndex, out, length2);
        this.readerIndex += readBytes;
        return readBytes;
    }

    public void readBytes(OutputStream out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, out, length2);
        this.readerIndex += length2;
    }

    public void skipBytes(int length2) {
        int newReaderIndex = this.readerIndex + length2;
        if (newReaderIndex > this.writerIndex) {
            throw new IndexOutOfBoundsException("Readable bytes exceeded - Need " + newReaderIndex + ", maximum is " + this.writerIndex);
        }
        this.readerIndex = newReaderIndex;
    }

    @Deprecated
    public int skipBytes(ChannelBufferIndexFinder firstIndexFinder) {
        int oldReaderIndex = this.readerIndex;
        int newReaderIndex = this.indexOf(oldReaderIndex, this.writerIndex, firstIndexFinder);
        if (newReaderIndex < 0) {
            throw new NoSuchElementException();
        }
        this.readerIndex(newReaderIndex);
        return newReaderIndex - oldReaderIndex;
    }

    public void writeByte(int value2) {
        this.setByte(this.writerIndex++, value2);
    }

    public void writeShort(int value2) {
        this.setShort(this.writerIndex, value2);
        this.writerIndex += 2;
    }

    public void writeMedium(int value2) {
        this.setMedium(this.writerIndex, value2);
        this.writerIndex += 3;
    }

    public void writeInt(int value2) {
        this.setInt(this.writerIndex, value2);
        this.writerIndex += 4;
    }

    public void writeLong(long value2) {
        this.setLong(this.writerIndex, value2);
        this.writerIndex += 8;
    }

    public void writeChar(int value2) {
        this.writeShort(value2);
    }

    public void writeFloat(float value2) {
        this.writeInt(Float.floatToRawIntBits(value2));
    }

    public void writeDouble(double value2) {
        this.writeLong(Double.doubleToRawLongBits(value2));
    }

    public void writeBytes(byte[] src, int srcIndex, int length2) {
        this.setBytes(this.writerIndex, src, srcIndex, length2);
        this.writerIndex += length2;
    }

    public void writeBytes(byte[] src) {
        this.writeBytes(src, 0, src.length);
    }

    public void writeBytes(ChannelBuffer src) {
        this.writeBytes(src, src.readableBytes());
    }

    public void writeBytes(ChannelBuffer src, int length2) {
        if (length2 > src.readableBytes()) {
            throw new IndexOutOfBoundsException("Too many bytes to write - Need " + length2 + ", maximum is " + src.readableBytes());
        }
        this.writeBytes(src, src.readerIndex(), length2);
        src.readerIndex(src.readerIndex() + length2);
    }

    public void writeBytes(ChannelBuffer src, int srcIndex, int length2) {
        this.setBytes(this.writerIndex, src, srcIndex, length2);
        this.writerIndex += length2;
    }

    public void writeBytes(ByteBuffer src) {
        int length2 = src.remaining();
        this.setBytes(this.writerIndex, src);
        this.writerIndex += length2;
    }

    public int writeBytes(InputStream in, int length2) throws IOException {
        int writtenBytes = this.setBytes(this.writerIndex, in, length2);
        if (writtenBytes > 0) {
            this.writerIndex += writtenBytes;
        }
        return writtenBytes;
    }

    public int writeBytes(ScatteringByteChannel in, int length2) throws IOException {
        int writtenBytes = this.setBytes(this.writerIndex, in, length2);
        if (writtenBytes > 0) {
            this.writerIndex += writtenBytes;
        }
        return writtenBytes;
    }

    public void writeZero(int length2) {
        int i2;
        if (length2 == 0) {
            return;
        }
        if (length2 < 0) {
            throw new IllegalArgumentException("length must be 0 or greater than 0.");
        }
        int nLong = length2 >>> 3;
        int nBytes = length2 & 7;
        for (i2 = nLong; i2 > 0; --i2) {
            this.writeLong(0L);
        }
        if (nBytes == 4) {
            this.writeInt(0);
        } else if (nBytes < 4) {
            for (i2 = nBytes; i2 > 0; --i2) {
                this.writeByte(0);
            }
        } else {
            this.writeInt(0);
            for (i2 = nBytes - 4; i2 > 0; --i2) {
                this.writeByte(0);
            }
        }
    }

    public ChannelBuffer copy() {
        return this.copy(this.readerIndex, this.readableBytes());
    }

    public ChannelBuffer slice() {
        return this.slice(this.readerIndex, this.readableBytes());
    }

    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(this.readerIndex, this.readableBytes());
    }

    public ByteBuffer[] toByteBuffers() {
        return this.toByteBuffers(this.readerIndex, this.readableBytes());
    }

    public ByteBuffer[] toByteBuffers(int index2, int length2) {
        return new ByteBuffer[]{this.toByteBuffer(index2, length2)};
    }

    public String toString(Charset charset) {
        return this.toString(this.readerIndex, this.readableBytes(), charset);
    }

    public String toString(int index2, int length2, Charset charset) {
        if (length2 == 0) {
            return "";
        }
        return ChannelBuffers.decodeString(this.toByteBuffer(index2, length2), charset);
    }

    @Deprecated
    public String toString(int index2, int length2, String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        if (terminatorFinder == null) {
            return this.toString(index2, length2, charsetName);
        }
        int terminatorIndex = this.indexOf(index2, index2 + length2, terminatorFinder);
        if (terminatorIndex < 0) {
            return this.toString(index2, length2, charsetName);
        }
        return this.toString(index2, terminatorIndex - index2, charsetName);
    }

    @Deprecated
    public String toString(int index2, int length2, String charsetName) {
        return this.toString(index2, length2, Charset.forName(charsetName));
    }

    @Deprecated
    public String toString(String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        return this.toString(this.readerIndex, this.readableBytes(), charsetName, terminatorFinder);
    }

    @Deprecated
    public String toString(String charsetName) {
        return this.toString(Charset.forName(charsetName));
    }

    public int indexOf(int fromIndex, int toIndex, byte value2) {
        return ChannelBuffers.indexOf((ChannelBuffer)this, fromIndex, toIndex, value2);
    }

    public int indexOf(int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        return ChannelBuffers.indexOf((ChannelBuffer)this, fromIndex, toIndex, indexFinder);
    }

    public int bytesBefore(byte value2) {
        return this.bytesBefore(this.readerIndex(), this.readableBytes(), value2);
    }

    public int bytesBefore(ChannelBufferIndexFinder indexFinder) {
        return this.bytesBefore(this.readerIndex(), this.readableBytes(), indexFinder);
    }

    public int bytesBefore(int length2, byte value2) {
        this.checkReadableBytes(length2);
        return this.bytesBefore(this.readerIndex(), length2, value2);
    }

    public int bytesBefore(int length2, ChannelBufferIndexFinder indexFinder) {
        this.checkReadableBytes(length2);
        return this.bytesBefore(this.readerIndex(), length2, indexFinder);
    }

    public int bytesBefore(int index2, int length2, byte value2) {
        int endIndex = this.indexOf(index2, index2 + length2, value2);
        if (endIndex < 0) {
            return -1;
        }
        return endIndex - index2;
    }

    public int bytesBefore(int index2, int length2, ChannelBufferIndexFinder indexFinder) {
        int endIndex = this.indexOf(index2, index2 + length2, indexFinder);
        if (endIndex < 0) {
            return -1;
        }
        return endIndex - index2;
    }

    public int hashCode() {
        return ChannelBuffers.hashCode(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChannelBuffer)) {
            return false;
        }
        return ChannelBuffers.equals(this, (ChannelBuffer)o);
    }

    public int compareTo(ChannelBuffer that) {
        return ChannelBuffers.compare(this, that);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + "ridx=" + this.readerIndex + ", " + "widx=" + this.writerIndex + ", " + "cap=" + this.capacity() + ')';
    }

    protected void checkReadableBytes(int minimumReadableBytes) {
        if (this.readableBytes() < minimumReadableBytes) {
            throw new IndexOutOfBoundsException("Not enough readable bytes - Need " + minimumReadableBytes + ", maximum is " + this.readableBytes());
        }
    }
}

