/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIndexHashMapWrapper<K, V>
implements Map<K, V> {
    private int indexCounter;
    private final Map<K, ValueContainer<K, V>> wrappedMap;
    private final ArrayList<ValueContainer<K, V>> indexBasedLookup;

    public SimpleIndexHashMapWrapper() {
        this.wrappedMap = new HashMap<K, ValueContainer<K, V>>();
        this.indexBasedLookup = new ArrayList();
    }

    public SimpleIndexHashMapWrapper(SimpleIndexHashMapWrapper<K, V> wrapper, boolean allocateOnly) {
        this.indexBasedLookup = new ArrayList(wrapper.indexBasedLookup.size());
        this.wrappedMap = new HashMap<K, ValueContainer<K, V>>();
        int index2 = 0;
        if (allocateOnly) {
            for (ValueContainer<K, V> key2 : wrapper.indexBasedLookup) {
                ValueContainer<K, Object> vc = new ValueContainer<K, Object>(index2++, key2.getKey(), null);
                this.indexBasedLookup.add(vc);
                this.wrappedMap.put(key2.getKey(), vc);
            }
        } else {
            for (ValueContainer<K, V> key3 : wrapper.indexBasedLookup) {
                ValueContainer<K, V> vc = new ValueContainer<K, V>(index2++, key3.getKey(), key3.getValue());
                this.indexBasedLookup.add(vc);
                this.wrappedMap.put(key3.getKey(), vc);
            }
        }
    }

    public SimpleIndexHashMapWrapper(K[] keys2) {
        this.wrappedMap = new HashMap<K, ValueContainer<K, V>>(keys2.length * 2);
        this.indexBasedLookup = new ArrayList(keys2.length);
        this.initWithKeys(keys2);
    }

    public SimpleIndexHashMapWrapper(K[] keys2, int initialCapacity, float load2) {
        this.wrappedMap = new HashMap<K, ValueContainer<K, V>>(initialCapacity * 2, load2);
        this.indexBasedLookup = new ArrayList(initialCapacity);
        this.initWithKeys(keys2);
    }

    public void initWithKeys(K[] keys2) {
        int index2 = 0;
        for (K key2 : keys2) {
            ValueContainer<K, Object> vc = new ValueContainer<K, Object>(index2++, key2, null);
            this.wrappedMap.put(key2, vc);
            this.indexBasedLookup.add(vc);
        }
    }

    public void addKey(K key2) {
        ValueContainer<K, Object> vc = new ValueContainer<K, Object>(this.indexCounter++, key2, null);
        this.indexBasedLookup.add(vc);
        this.wrappedMap.put(key2, vc);
    }

    public void addKey(K key2, V value2) {
        ValueContainer<K, V> vc = new ValueContainer<K, V>(this.indexCounter++, key2, value2);
        this.indexBasedLookup.add(vc);
        this.wrappedMap.put(key2, vc);
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.wrappedMap.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.wrappedMap.containsValue(value2);
    }

    @Override
    public V get(Object key2) {
        return this.wrappedMap.get(key2).getValue();
    }

    public V getByIndex(int index2) {
        return this.indexBasedLookup.get(index2).getValue();
    }

    public K getKeyAtIndex(int index2) {
        return this.indexBasedLookup.get(index2).getKey();
    }

    public int indexOf(K key2) {
        return this.wrappedMap.get(key2).getIndex();
    }

    @Override
    public V put(K key2, V value2) {
        ValueContainer<K, V> vc = this.wrappedMap.get(key2);
        if (vc == null) {
            throw new RuntimeException("cannot add a new entry.  you must allocate a new key with addKey() first.");
        }
        this.indexBasedLookup.add(vc);
        return this.wrappedMap.put(key2, vc).getValue();
    }

    public void putAtIndex(int index2, V value2) {
        ValueContainer<K, V> vc = this.indexBasedLookup.get(index2);
        vc.setValue(value2);
    }

    @Override
    public V remove(Object key2) {
        throw new UnsupportedOperationException("cannot remove keys");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("cannot clear map");
    }

    @Override
    public Set<K> keySet() {
        return this.wrappedMap.keySet();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueContainer<K, V> {
        private int index;
        private K key;
        private V value;

        public ValueContainer(int index2, K key2, V value2) {
            this.index = index2;
            this.key = key2;
            this.value = value2;
        }

        public int getIndex() {
            return this.index;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        void setKey(K key2) {
            this.key = key2;
        }

        void setValue(V value2) {
            this.value = value2;
        }
    }
}

