/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.integration.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.mvel2.UnresolveablePropertyException;
import org.elasticsearch.common.mvel2.integration.VariableResolver;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseVariableResolverFactory
implements VariableResolverFactory {
    protected Map<String, VariableResolver> variableResolvers = new HashMap<String, VariableResolver>();
    protected VariableResolverFactory nextFactory;
    protected int indexOffset = 0;
    protected String[] indexedVariableNames;
    protected VariableResolver[] indexedVariableResolvers;
    private boolean tiltFlag;

    @Override
    public VariableResolverFactory getNextFactory() {
        return this.nextFactory;
    }

    @Override
    public VariableResolverFactory setNextFactory(VariableResolverFactory resolverFactory) {
        this.nextFactory = resolverFactory;
        return this.nextFactory;
    }

    @Override
    public VariableResolver getVariableResolver(String name2) {
        if (this.isResolveable(name2)) {
            if (this.variableResolvers.containsKey(name2)) {
                return this.variableResolvers.get(name2);
            }
            if (this.nextFactory != null) {
                return this.nextFactory.getVariableResolver(name2);
            }
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + name2 + "'");
    }

    public boolean isNextResolveable(String name2) {
        return this.nextFactory != null && this.nextFactory.isResolveable(name2);
    }

    public void appendFactory(VariableResolverFactory resolverFactory) {
        if (this.nextFactory == null) {
            this.nextFactory = resolverFactory;
        } else {
            VariableResolverFactory vrf = this.nextFactory;
            while (vrf.getNextFactory() != null) {
                vrf = vrf.getNextFactory();
            }
            vrf.setNextFactory(this.nextFactory);
        }
    }

    public void insertFactory(VariableResolverFactory resolverFactory) {
        if (this.nextFactory == null) {
            this.nextFactory = resolverFactory;
        } else {
            this.nextFactory = resolverFactory;
            resolverFactory.setNextFactory(this.nextFactory);
        }
    }

    @Override
    public Set<String> getKnownVariables() {
        if (this.nextFactory == null) {
            return new HashSet<String>(this.variableResolvers.keySet());
        }
        HashSet<String> vars = new HashSet<String>(this.variableResolvers.keySet());
        vars.addAll(this.nextFactory.getKnownVariables());
        return vars;
    }

    @Override
    public VariableResolver createIndexedVariable(int index2, String name2, Object value2) {
        if (this.nextFactory != null) {
            return this.nextFactory.createIndexedVariable(index2 - this.indexOffset, name2, value2);
        }
        throw new RuntimeException("cannot create indexed variable: " + name2 + "(" + index2 + "). operation not supported by resolver: " + this.getClass().getName());
    }

    @Override
    public VariableResolver getIndexedVariableResolver(int index2) {
        if (this.nextFactory != null) {
            return this.nextFactory.getIndexedVariableResolver(index2 - this.indexOffset);
        }
        throw new RuntimeException("cannot access indexed variable: " + index2 + ".  operation not supported by resolver: " + this.getClass().getName());
    }

    @Override
    public VariableResolver createIndexedVariable(int index2, String name2, Object value2, Class<?> type2) {
        if (this.nextFactory != null) {
            return this.nextFactory.createIndexedVariable(index2 - this.indexOffset, name2, value2, type2);
        }
        throw new RuntimeException("cannot access indexed variable: " + name2 + "(" + index2 + ").  operation not supported by resolver.: " + this.getClass().getName());
    }

    public Map<String, VariableResolver> getVariableResolvers() {
        return this.variableResolvers;
    }

    public void setVariableResolvers(Map<String, VariableResolver> variableResolvers) {
        this.variableResolvers = variableResolvers;
    }

    public String[] getIndexedVariableNames() {
        return this.indexedVariableNames;
    }

    public void setIndexedVariableNames(String[] indexedVariableNames) {
        this.indexedVariableNames = indexedVariableNames;
    }

    @Override
    public int variableIndexOf(String name2) {
        if (this.indexedVariableNames != null) {
            for (int i2 = 0; i2 < this.indexedVariableNames.length; ++i2) {
                if (!name2.equals(this.indexedVariableNames[i2])) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public VariableResolver setIndexedVariableResolver(int index2, VariableResolver resolver) {
        if (this.indexedVariableResolvers == null) {
            VariableResolver[] variableResolverArray = new VariableResolver[this.indexedVariableNames.length];
            this.indexedVariableResolvers = variableResolverArray;
            VariableResolver variableResolver = resolver;
            variableResolverArray[index2 - this.indexOffset] = variableResolver;
            return variableResolver;
        }
        VariableResolver variableResolver = resolver;
        this.indexedVariableResolvers[index2 - this.indexOffset] = variableResolver;
        return variableResolver;
    }

    @Override
    public boolean isIndexedFactory() {
        return false;
    }

    @Override
    public boolean tiltFlag() {
        return this.tiltFlag;
    }

    @Override
    public void setTiltFlag(boolean tiltFlag) {
        this.tiltFlag = tiltFlag;
        if (this.nextFactory != null) {
            this.nextFactory.setTiltFlag(tiltFlag);
        }
    }
}

