/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ArrayTools;

public class StaticImportNode
extends ASTNode {
    private Class declaringClass;
    private String methodName;
    private transient Method method;

    public StaticImportNode(char[] expr, int start2, int offset2, ParserContext pCtx) {
        super(pCtx);
        try {
            this.expr = expr;
            this.start = start2;
            this.offset = offset2;
            ClassLoader classLoader = this.getClassLoader();
            this.expr = expr;
            int mark2 = ArrayTools.findLast('.', start2, offset2, expr);
            this.declaringClass = Class.forName(new String(expr, start2, mark2 - start2), true, classLoader);
            this.methodName = new String(expr, ++mark2, offset2 - (mark2 - start2));
            if (this.resolveMethod() == null) {
                throw new CompileException("can not find method for static import: " + this.declaringClass.getName() + "." + this.methodName, expr, start2);
            }
        }
        catch (Exception e) {
            throw new CompileException("unable to import class", expr, start2, e);
        }
    }

    private Method resolveMethod() {
        for (Method meth : this.declaringClass.getMethods()) {
            if (!Modifier.isStatic(meth.getModifiers()) || !this.methodName.equals(meth.getName())) continue;
            this.method = meth;
            return this.method;
        }
        return null;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        factory.createVariable(this.methodName, this.method == null ? (this.method = this.resolveMethod()) : this.method);
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }
}

