/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class Sign
extends ASTNode {
    private Signer signer;
    private ExecutableStatement stmt;

    public Sign(char[] expr, int start2, int end2, int fields2, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        this.start = start2 + 1;
        this.offset = end2 - 1;
        this.fields = fields2;
        if ((fields2 & 0x10) != 0) {
            this.stmt = (ExecutableStatement)ParseTools.subCompileExpression(expr, this.start, this.offset, pCtx);
            this.egressType = this.stmt.getKnownEgressType();
            if (this.egressType != null && this.egressType != Object.class) {
                this.initSigner(this.egressType);
            }
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.sign(this.stmt.getValue(ctx, thisValue, factory));
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.sign(MVEL.eval(this.expr, this.start, this.offset, thisValue, factory));
    }

    private Object sign(Object o) {
        if (o == null) {
            return null;
        }
        if (this.signer == null) {
            if (this.egressType == null || this.egressType == Object.class) {
                this.egressType = o.getClass();
            }
            this.initSigner(this.egressType);
        }
        return this.signer.sign(o);
    }

    private void initSigner(Class type2) {
        if (Integer.class.isAssignableFrom(type2 = ParseTools.boxPrimitive(type2))) {
            this.signer = new IntegerSigner();
        } else if (Double.class.isAssignableFrom(type2)) {
            this.signer = new DoubleSigner();
        } else if (Long.class.isAssignableFrom(type2)) {
            this.signer = new LongSigner();
        } else if (Float.class.isAssignableFrom(type2)) {
            this.signer = new FloatSigner();
        } else if (Short.class.isAssignableFrom(type2)) {
            this.signer = new ShortSigner();
        } else if (BigInteger.class.isAssignableFrom(type2)) {
            this.signer = new BigIntSigner();
        } else if (BigDecimal.class.isAssignableFrom(type2)) {
            this.signer = new BigDecSigner();
        } else {
            throw new CompileException("illegal use of '-': cannot be applied to: " + type2.getName(), this.expr, this.start);
        }
    }

    public boolean isIdentifier() {
        return false;
    }

    private class BigDecSigner
    implements Signer {
        private BigDecSigner() {
        }

        public Object sign(Object o) {
            return new BigDecimal(-((BigDecimal)o).doubleValue());
        }
    }

    private class BigIntSigner
    implements Signer {
        private BigIntSigner() {
        }

        public Object sign(Object o) {
            return new BigInteger(String.valueOf(-((BigInteger)o).longValue()));
        }
    }

    private class FloatSigner
    implements Signer {
        private FloatSigner() {
        }

        public Object sign(Object o) {
            return Float.valueOf(-((Float)o).floatValue());
        }
    }

    private class DoubleSigner
    implements Signer {
        private DoubleSigner() {
        }

        public Object sign(Object o) {
            return -((Double)o).doubleValue();
        }
    }

    private class LongSigner
    implements Signer {
        private LongSigner() {
        }

        public Object sign(Object o) {
            return -((Long)o).longValue();
        }
    }

    private class ShortSigner
    implements Signer {
        private ShortSigner() {
        }

        public Object sign(Object o) {
            return (int)(-((Short)o).shortValue());
        }
    }

    private class IntegerSigner
    implements Signer {
        private IntegerSigner() {
        }

        public Object sign(Object o) {
            return -((Integer)o).intValue();
        }
    }

    private static interface Signer
    extends Serializable {
        public Object sign(Object var1);
    }
}

