/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.CompilerTools;

public class Instance
extends ASTNode {
    private ASTNode stmt;
    private ASTNode clsStmt;

    public Instance(ASTNode stmt, ASTNode clsStmt, ParserContext pCtx) {
        super(pCtx);
        this.stmt = stmt;
        this.clsStmt = clsStmt;
        CompilerTools.expectType(clsStmt, Class.class, true);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return ((Class)this.clsStmt.getReducedValueAccelerated(ctx, thisValue, factory)).isInstance(this.stmt.getReducedValueAccelerated(ctx, thisValue, factory));
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            Class i2 = (Class)this.clsStmt.getReducedValue(ctx, thisValue, factory);
            if (i2 == null) {
                throw new ClassCastException();
            }
            return i2.isInstance(this.stmt.getReducedValue(ctx, thisValue, factory));
        }
        catch (ClassCastException e) {
            throw new RuntimeException("not a class reference: " + this.clsStmt.getName());
        }
    }

    public Class getEgressType() {
        return Boolean.class;
    }

    public ASTNode getStatement() {
        return this.stmt;
    }

    public ASTNode getClassStatement() {
        return this.clsStmt;
    }
}

