/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolver;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.math.MathProcessor;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class IndexedOperativeAssign
extends ASTNode {
    private final int register;
    private ExecutableStatement statement;
    private final int operation;

    public IndexedOperativeAssign(char[] expr, int start2, int offset2, int operation, int register, int fields2, ParserContext pCtx) {
        super(pCtx);
        this.operation = operation;
        this.expr = expr;
        this.start = start2;
        this.offset = offset2;
        this.register = register;
        if ((fields2 & 0x10) != 0) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, start2, offset2, pCtx);
            this.egressType = this.statement.getKnownEgressType();
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        VariableResolver resolver = factory.getIndexedVariableResolver(this.register);
        ctx = MathProcessor.doOperations(resolver.getValue(), this.operation, this.statement.getValue(ctx, thisValue, factory));
        resolver.setValue(ctx);
        return ctx;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        VariableResolver resolver = factory.getIndexedVariableResolver(this.register);
        ctx = MathProcessor.doOperations(resolver.getValue(), this.operation, MVEL.eval(this.expr, this.start, this.offset, ctx, factory));
        resolver.setValue(ctx);
        return ctx;
    }
}

