/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.ImmutableDefaultFactory;
import org.elasticsearch.common.mvel2.integration.impl.StackResetResolverFactory;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class ImportNode
extends ASTNode {
    private Class importClass;
    private boolean packageImport;
    private int _offset;
    ParserContext pCtx;
    private static final char[] WC_TEST = new char[]{'.', '*'};

    public ImportNode(char[] expr, int start2, int offset2, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        this.start = start2;
        this.offset = offset2;
        this.pCtx = pCtx;
        if (ParseTools.endsWith(expr, start2, offset2, WC_TEST)) {
            this.packageImport = true;
            this._offset = (short)ParseTools.findLast(expr, start2, offset2, '.');
            if (this._offset == -1) {
                this._offset = 0;
            }
        } else {
            String clsName = new String(expr, start2, offset2);
            ClassLoader classLoader = this.getClassLoader();
            try {
                this.importClass = Class.forName(clsName, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                int idx = clsName.lastIndexOf(46);
                clsName = (clsName.substring(0, idx) + "$" + clsName.substring(idx + 1)).trim();
                try {
                    this.importClass = Class.forName(clsName, true, classLoader);
                }
                catch (ClassNotFoundException e2) {
                    throw new CompileException("class not found: " + new String(expr), expr, start2);
                }
            }
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (!this.packageImport) {
            if (MVEL.COMPILER_OPT_ALLOCATE_TYPE_LITERALS_TO_SHARED_SYMBOL_TABLE) {
                factory.createVariable(this.importClass.getSimpleName(), this.importClass);
                return this.importClass;
            }
            return ParseTools.findClassImportResolverFactory(factory, this.pCtx).addClass(this.importClass);
        }
        if (!(factory instanceof ImmutableDefaultFactory || factory instanceof StackResetResolverFactory && ((StackResetResolverFactory)factory).getDelegate() instanceof ImmutableDefaultFactory)) {
            ParseTools.findClassImportResolverFactory(factory, this.pCtx).addPackageImport(new String(this.expr, this.start, this._offset - this.start));
        }
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    public Class getImportClass() {
        return this.importClass;
    }

    public boolean isPackageImport() {
        return this.packageImport;
    }

    public void setPackageImport(boolean packageImport) {
        this.packageImport = packageImport;
    }

    public String getPackageImport() {
        return new String(this.expr, this.start, this._offset - this.start);
    }
}

