/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.PropertyAccessor;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.ast.Assignment;
import org.elasticsearch.common.mvel2.compiler.AbstractParser;
import org.elasticsearch.common.mvel2.compiler.CompiledAccExpression;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class DeepAssignmentNode
extends ASTNode
implements Assignment {
    private String property;
    private CompiledAccExpression acc;
    private ExecutableStatement statement;

    public DeepAssignmentNode(char[] expr, int start2, int offset2, int fields2, int operation, String name2, ParserContext pCtx) {
        super(pCtx);
        this.fields |= 2 | fields2;
        this.expr = expr;
        this.start = start2;
        this.offset = offset2;
        if (operation != -1) {
            this.property = name2;
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(this.property, expr, start2, offset2, operation), pCtx);
            this.egressType = this.statement.getKnownEgressType();
        } else {
            int mark2 = ParseTools.find(expr, start2, offset2, '=');
            if (mark2 != -1) {
                this.property = ParseTools.createStringTrimmed(expr, start2, mark2 - start2);
                this.start = ParseTools.skipWhitespace(expr, mark2 + 1);
                if (this.start >= start2 + offset2) {
                    throw new CompileException("unexpected end of statement", expr, mark2 + 1);
                }
                this.offset = offset2 - (this.start - start2);
                if ((fields2 & 0x10) != 0) {
                    this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, this.start, this.offset, pCtx);
                }
            } else {
                this.property = new String(expr);
            }
        }
        if ((fields2 & 0x10) != 0) {
            this.acc = (CompiledAccExpression)MVEL.compileSetExpression(this.property.toCharArray(), start2, offset2, pCtx);
        }
    }

    public DeepAssignmentNode(char[] expr, int start2, int offset2, int fields2, ParserContext pCtx) {
        this(expr, start2, offset2, fields2, -1, null, pCtx);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.statement == null) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, this.start, this.offset);
            this.acc = (CompiledAccExpression)MVEL.compileSetExpression(this.property.toCharArray(), this.statement.getKnownEgressType(), AbstractParser.getCurrentThreadParserContext());
        }
        Object object = ctx;
        ctx = this.statement.getValue(ctx, thisValue, factory);
        this.acc.setValue(object, thisValue, factory, ctx);
        return ctx;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object object = ctx;
        ctx = MVEL.eval(this.expr, this.start, this.offset, ctx, factory);
        PropertyAccessor.set(object, factory, this.property, ctx, this.pCtx);
        return ctx;
    }

    public String getAbsoluteName() {
        return this.property.substring(0, this.property.indexOf(46));
    }

    public String getAssignmentVar() {
        return this.property;
    }

    public char[] getExpression() {
        return ParseTools.subArray(this.expr, this.start, this.offset);
    }

    public boolean isNewDeclaration() {
        return false;
    }

    public boolean isAssignment() {
        return true;
    }

    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }
}

