/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class AssertNode
extends ASTNode {
    public ExecutableStatement assertion;
    public ExecutableStatement fail;

    public AssertNode(char[] expr, int start2, int offset2, int fields2, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        this.start = start2;
        this.offset = offset2;
        if ((fields2 & 0x10) != 0) {
            this.assertion = (ExecutableStatement)ParseTools.subCompileExpression(expr, start2, offset2, pCtx);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            if (!((Boolean)this.assertion.getValue(ctx, thisValue, factory)).booleanValue()) {
                throw new AssertionError((Object)("assertion failed in expression: " + new String(this.expr, this.start, this.offset)));
            }
            return true;
        }
        catch (ClassCastException e) {
            throw new CompileException("assertion does not contain a boolean statement", this.expr, this.start);
        }
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            if (!((Boolean)MVEL.eval(this.expr, ctx, factory)).booleanValue()) {
                throw new AssertionError((Object)("assertion failed in expression: " + new String(this.expr, this.start, this.offset)));
            }
            return true;
        }
        catch (ClassCastException e) {
            throw new CompileException("assertion does not contain a boolean statement", this.expr, this.start);
        }
    }
}

