/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.asm;

public class ByteVector {
    byte[] data;
    int length;

    public ByteVector() {
        this.data = new byte[64];
    }

    public ByteVector(int initialSize) {
        this.data = new byte[initialSize];
    }

    public ByteVector putByte(int b) {
        int length2 = this.length;
        if (length2 + 1 > this.data.length) {
            this.enlarge(1);
        }
        this.data[length2++] = (byte)b;
        this.length = length2;
        return this;
    }

    ByteVector put11(int b1, int b2) {
        int length2 = this.length;
        if (length2 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] data2 = this.data;
        data2[length2++] = (byte)b1;
        data2[length2++] = (byte)b2;
        this.length = length2;
        return this;
    }

    public ByteVector putShort(int s2) {
        int length2 = this.length;
        if (length2 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] data2 = this.data;
        data2[length2++] = (byte)(s2 >>> 8);
        data2[length2++] = (byte)s2;
        this.length = length2;
        return this;
    }

    ByteVector put12(int b, int s2) {
        int length2 = this.length;
        if (length2 + 3 > this.data.length) {
            this.enlarge(3);
        }
        byte[] data2 = this.data;
        data2[length2++] = (byte)b;
        data2[length2++] = (byte)(s2 >>> 8);
        data2[length2++] = (byte)s2;
        this.length = length2;
        return this;
    }

    public ByteVector putInt(int i2) {
        int length2 = this.length;
        if (length2 + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] data2 = this.data;
        data2[length2++] = (byte)(i2 >>> 24);
        data2[length2++] = (byte)(i2 >>> 16);
        data2[length2++] = (byte)(i2 >>> 8);
        data2[length2++] = (byte)i2;
        this.length = length2;
        return this;
    }

    public ByteVector putLong(long l) {
        int length2 = this.length;
        if (length2 + 8 > this.data.length) {
            this.enlarge(8);
        }
        byte[] data2 = this.data;
        int i2 = (int)(l >>> 32);
        data2[length2++] = (byte)(i2 >>> 24);
        data2[length2++] = (byte)(i2 >>> 16);
        data2[length2++] = (byte)(i2 >>> 8);
        data2[length2++] = (byte)i2;
        i2 = (int)l;
        data2[length2++] = (byte)(i2 >>> 24);
        data2[length2++] = (byte)(i2 >>> 16);
        data2[length2++] = (byte)(i2 >>> 8);
        data2[length2++] = (byte)i2;
        this.length = length2;
        return this;
    }

    public ByteVector putUTF8(String s2) {
        int len = this.length;
        int charLength = s2.length();
        if (len + 2 + charLength > this.data.length) {
            this.enlarge(2 + charLength);
        }
        byte[] data2 = this.data;
        data2[len++] = (byte)(charLength >>> 8);
        data2[len++] = (byte)charLength;
        for (int i2 = 0; i2 < charLength; ++i2) {
            int j;
            char c = s2.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                data2[len++] = (byte)c;
                continue;
            }
            int byteLength = i2;
            for (j = i2; j < charLength; ++j) {
                c = s2.charAt(j);
                if (c >= '\u0001' && c <= '\u007f') {
                    ++byteLength;
                    continue;
                }
                if (c > '\u07ff') {
                    byteLength += 3;
                    continue;
                }
                byteLength += 2;
            }
            data2[this.length] = (byte)(byteLength >>> 8);
            data2[this.length + 1] = (byte)byteLength;
            if (this.length + 2 + byteLength > data2.length) {
                this.length = len;
                this.enlarge(2 + byteLength);
                data2 = this.data;
            }
            for (j = i2; j < charLength; ++j) {
                c = s2.charAt(j);
                if (c >= '\u0001' && c <= '\u007f') {
                    data2[len++] = (byte)c;
                    continue;
                }
                if (c > '\u07ff') {
                    data2[len++] = (byte)(0xE0 | c >> 12 & 0xF);
                    data2[len++] = (byte)(0x80 | c >> 6 & 0x3F);
                    data2[len++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                data2[len++] = (byte)(0xC0 | c >> 6 & 0x1F);
                data2[len++] = (byte)(0x80 | c & 0x3F);
            }
            break;
        }
        this.length = len;
        return this;
    }

    public ByteVector putByteArray(byte[] b, int off, int len) {
        if (this.length + len > this.data.length) {
            this.enlarge(len);
        }
        if (b != null) {
            System.arraycopy(b, off, this.data, this.length, len);
        }
        this.length += len;
        return this;
    }

    private void enlarge(int size2) {
        int length1 = 2 * this.data.length;
        int length2 = this.length + size2;
        byte[] newData = new byte[length1 > length2 ? length1 : length2];
        System.arraycopy(this.data, 0, newData, 0, this.length);
        this.data = newData;
    }
}

