/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.common.mvel2.ast.Proto;
import org.elasticsearch.common.mvel2.compiler.AbstractParser;
import org.elasticsearch.common.mvel2.integration.Interceptor;
import org.elasticsearch.common.mvel2.util.MethodStub;
import org.elasticsearch.common.mvel2.util.PropertyTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserConfiguration
implements Serializable {
    private static final int MAX_NEGATIVE_CACHE_SIZE;
    protected Map<String, Object> imports;
    protected HashSet<String> packageImports;
    protected Map<String, Interceptor> interceptors;
    protected transient ClassLoader classLoader;
    private transient Set<String> nonValidImports;
    private boolean allowBootstrapBypass = true;

    public ParserConfiguration() {
    }

    public ParserConfiguration(Map<String, Object> imports, Map<String, Interceptor> interceptors) {
        this.addAllImports(imports);
        this.interceptors = interceptors;
    }

    public ParserConfiguration(Map<String, Object> imports, HashSet<String> packageImports, Map<String, Interceptor> interceptors) {
        this.addAllImports(imports);
        this.packageImports = packageImports;
        this.interceptors = interceptors;
    }

    public HashSet<String> getPackageImports() {
        return this.packageImports;
    }

    public void setPackageImports(HashSet<String> packageImports) {
        this.packageImports = packageImports;
    }

    public Class getImport(String name2) {
        if (this.imports != null && this.imports.containsKey(name2) && this.imports.get(name2) instanceof Class) {
            return (Class)this.imports.get(name2);
        }
        return (Class)(AbstractParser.LITERALS.get(name2) instanceof Class ? AbstractParser.LITERALS.get(name2) : null);
    }

    public MethodStub getStaticImport(String name2) {
        return this.imports != null ? (MethodStub)this.imports.get(name2) : null;
    }

    public Object getStaticOrClassImport(String name2) {
        return this.imports != null && this.imports.containsKey(name2) ? this.imports.get(name2) : AbstractParser.LITERALS.get(name2);
    }

    public void addPackageImport(String packageName) {
        if (this.packageImports == null) {
            this.packageImports = new LinkedHashSet<String>();
        }
        this.packageImports.add(packageName);
        if (!this.addClassMemberStaticImports(packageName)) {
            this.packageImports.add(packageName);
        }
    }

    private boolean addClassMemberStaticImports(String packageName) {
        try {
            Class<?> c = Class.forName(packageName);
            this.initImports();
            if (c.isEnum()) {
                for (Enum e : EnumSet.allOf(c)) {
                    this.imports.put(e.name(), e);
                }
                return true;
            }
            for (Field f : c.getDeclaredFields()) {
                if ((f.getModifiers() & 9) == 0) continue;
                this.imports.put(f.getName(), f.get(null));
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("error adding static imports for: " + packageName, e);
        }
        return false;
    }

    public void addAllImports(Map<String, Object> imports) {
        if (imports == null) {
            return;
        }
        this.initImports();
        for (Map.Entry<String, Object> entry : imports.entrySet()) {
            Object o = entry.getValue();
            if (o instanceof Method) {
                this.imports.put(entry.getKey(), new MethodStub((Method)o));
                continue;
            }
            this.imports.put(entry.getKey(), o);
        }
    }

    private boolean checkForDynamicImport(String className) {
        if (this.packageImports == null) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(className.charAt(0))) {
            return false;
        }
        if (this.nonValidImports != null && this.nonValidImports.contains(className)) {
            return false;
        }
        int found = 0;
        Class<?> cls = null;
        for (String pkg : this.packageImports) {
            try {
                cls = Class.forName(pkg + "." + className, true, this.getClassLoader());
                ++found;
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
                if (PropertyTools.contains(e.getMessage(), "wrong name")) continue;
                throw e;
            }
        }
        if (found > 1) {
            throw new RuntimeException("ambiguous class name: " + className);
        }
        if (found == 1) {
            this.addImport(className, cls);
            return true;
        }
        this.cacheNegativeHitForDynamicImport(className);
        return false;
    }

    public boolean hasImport(String name2) {
        return this.imports != null && this.imports.containsKey(name2) || AbstractParser.CLASS_LITERALS.containsKey(name2) || this.checkForDynamicImport(name2);
    }

    private void initImports() {
        if (this.imports == null) {
            this.imports = new ConcurrentHashMap<String, Object>();
        }
    }

    public void addImport(Class cls) {
        this.initImports();
        this.addImport(cls.getSimpleName(), cls);
    }

    public void addImport(String name2, Class cls) {
        this.initImports();
        this.imports.put(name2, cls);
    }

    public void addImport(String name2, Proto proto) {
        this.initImports();
        this.imports.put(name2, proto);
    }

    public void addImport(String name2, Method method2) {
        this.addImport(name2, new MethodStub(method2));
    }

    public void addImport(String name2, MethodStub method2) {
        this.initImports();
        this.imports.put(name2, method2);
    }

    public Map<String, Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(Map<String, Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public Map<String, Object> getImports() {
        return this.imports;
    }

    public void setImports(Map<String, Object> imports) {
        if (imports == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : imports.entrySet()) {
            Object val = entry.getValue();
            if (val instanceof Class) {
                this.addImport(entry.getKey(), (Class)val);
                continue;
            }
            if (val instanceof Method) {
                this.addImport(entry.getKey(), (Method)val);
                continue;
            }
            if (val instanceof MethodStub) {
                this.addImport(entry.getKey(), (MethodStub)val);
                continue;
            }
            if (val instanceof Proto) {
                this.addImport(entry.getKey(), (Proto)entry.getValue());
                continue;
            }
            throw new RuntimeException("invalid element in imports map: " + entry.getKey() + " (" + val + ")");
        }
    }

    public boolean hasImports() {
        return this.imports == null || !this.imports.isEmpty() || this.packageImports != null && this.packageImports.size() != 0;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader == null ? (this.classLoader = Thread.currentThread().getContextClassLoader()) : this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setAllImports(Map<String, Object> imports) {
        this.initImports();
        this.imports.clear();
        if (imports != null) {
            this.imports.putAll(imports);
        }
    }

    public void setImports(HashMap<String, Object> imports) {
        this.setAllImports(imports);
    }

    private void cacheNegativeHitForDynamicImport(String negativeHit) {
        if (this.nonValidImports == null) {
            this.nonValidImports = new LinkedHashSet<String>();
        } else if (this.nonValidImports.size() > 1000) {
            Iterator<String> i2 = this.nonValidImports.iterator();
            i2.next();
            i2.remove();
        }
        this.nonValidImports.add(negativeHit);
    }

    public void flushCaches() {
        if (this.nonValidImports != null) {
            this.nonValidImports.clear();
        }
    }

    public boolean isAllowBootstrapBypass() {
        return this.allowBootstrapBypass;
    }

    public void setAllowBootstrapBypass(boolean allowBootstrapBypass) {
        this.allowBootstrapBypass = allowBootstrapBypass;
    }

    static {
        String negCacheSize = System.getProperty("mvel2.compiler.max_neg_cache_size");
        MAX_NEGATIVE_CACHE_SIZE = negCacheSize != null ? Integer.parseInt(negCacheSize) : 1000;
    }
}

