/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.index.store.support.ForceSyncDirectory;

public class SwitchDirectory
extends Directory
implements ForceSyncDirectory {
    private final Directory secondaryDir;
    private final Directory primaryDir;
    private final ImmutableSet<String> primaryExtensions;
    private boolean doClose;

    public SwitchDirectory(Set<String> primaryExtensions, Directory primaryDir, Directory secondaryDir, boolean doClose) {
        this.primaryExtensions = ImmutableSet.copyOf(primaryExtensions);
        this.primaryDir = primaryDir;
        this.secondaryDir = secondaryDir;
        this.doClose = doClose;
        this.lockFactory = primaryDir.getLockFactory();
    }

    public ImmutableSet<String> primaryExtensions() {
        return this.primaryExtensions;
    }

    public Directory primaryDir() {
        return this.primaryDir;
    }

    public Directory secondaryDir() {
        return this.secondaryDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.doClose) {
            try {
                this.secondaryDir.close();
            }
            finally {
                this.primaryDir.close();
            }
            this.doClose = false;
        }
    }

    @Override
    public String[] listAll() throws IOException {
        HashSet<String> files = new HashSet<String>();
        for (String f : this.primaryDir.listAll()) {
            files.add(f);
        }
        for (String f : this.secondaryDir.listAll()) {
            files.add(f);
        }
        return files.toArray(new String[files.size()]);
    }

    public static String getExtension(String name2) {
        int i2 = name2.lastIndexOf(46);
        if (i2 == -1) {
            return "";
        }
        return name2.substring(i2 + 1, name2.length());
    }

    private Directory getDirectory(String name2) {
        String ext2 = SwitchDirectory.getExtension(name2);
        if (this.primaryExtensions.contains(ext2)) {
            return this.primaryDir;
        }
        return this.secondaryDir;
    }

    @Override
    public boolean fileExists(String name2) throws IOException {
        return this.getDirectory(name2).fileExists(name2);
    }

    @Override
    public long fileModified(String name2) throws IOException {
        return this.getDirectory(name2).fileModified(name2);
    }

    @Override
    public void touchFile(String name2) throws IOException {
        this.getDirectory(name2).touchFile(name2);
    }

    @Override
    public void deleteFile(String name2) throws IOException {
        this.getDirectory(name2).deleteFile(name2);
    }

    @Override
    public long fileLength(String name2) throws IOException {
        return this.getDirectory(name2).fileLength(name2);
    }

    @Override
    public IndexOutput createOutput(String name2) throws IOException {
        return this.getDirectory(name2).createOutput(name2);
    }

    @Override
    public void sync(Collection<String> names2) throws IOException {
        ArrayList<String> primaryNames = new ArrayList<String>();
        ArrayList<String> secondaryNames = new ArrayList<String>();
        for (String name2 : names2) {
            if (this.primaryExtensions.contains(SwitchDirectory.getExtension(name2))) {
                primaryNames.add(name2);
                continue;
            }
            secondaryNames.add(name2);
        }
        this.primaryDir.sync(primaryNames);
        this.secondaryDir.sync(secondaryNames);
    }

    @Override
    public void sync(String name2) throws IOException {
        this.getDirectory(name2).sync(name2);
    }

    @Override
    public void forceSync(String name2) throws IOException {
        Directory dir = this.getDirectory(name2);
        if (dir instanceof ForceSyncDirectory) {
            ((ForceSyncDirectory)((Object)dir)).forceSync(name2);
        } else {
            dir.sync(name2);
        }
    }

    @Override
    public IndexInput openInput(String name2) throws IOException {
        return this.getDirectory(name2).openInput(name2);
    }
}

